/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ClientTests.class, SmallTests.class})
public class TestAsyncAccessControlAdminApi
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncAccessControlAdminApi.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        SecureTestUtil.enableSecurity(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(AccessControlLists.ACL_TABLE_NAME);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @Test
    public void test() throws Exception {
        TableName tableName = TableName.valueOf((String)"test-table");
        final String userName1 = "user1";
        String userName2 = "user2";
        User user2 = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)userName2, (String[])new String[0]);
        Permission permission = Permission.newBuilder((TableName)tableName).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        UserPermission userPermission = new UserPermission(userName1, permission);
        this.admin.grant(userPermission, false).get();
        List userPermissions = (List)this.admin.getUserPermissions(GetUserPermissionsRequest.newBuilder((TableName)tableName).build()).get();
        Assert.assertEquals((long)1L, (long)userPermissions.size());
        Assert.assertEquals((Object)userPermission, userPermissions.get(0));
        userPermissions = (List)this.admin.getUserPermissions(GetUserPermissionsRequest.newBuilder((TableName)tableName).withUserName(userName1).build()).get();
        Assert.assertEquals((long)1L, (long)userPermissions.size());
        Assert.assertEquals((Object)userPermission, userPermissions.get(0));
        userPermissions = (List)this.admin.getUserPermissions(GetUserPermissionsRequest.newBuilder((TableName)tableName).withUserName(userName2).build()).get();
        Assert.assertEquals((long)0L, (long)userPermissions.size());
        final ArrayList permissions = Lists.newArrayList((Object[])new Permission[]{permission});
        boolean hasPermission = (Boolean)((List)this.admin.hasUserPermissions(userName1, (List)permissions).get()).get(0);
        Assert.assertTrue((boolean)hasPermission);
        hasPermission = (Boolean)((List)this.admin.hasUserPermissions(userName2, (List)permissions).get()).get(0);
        Assert.assertFalse((boolean)hasPermission);
        SecureTestUtil.AccessTestAction hasPermissionAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TestAsyncAdminBase.TEST_UTIL.getConfiguration()).get();){
                    Object e = ((List)conn.getAdmin().hasUserPermissions(userName1, permissions).get()).get(0);
                    return e;
                }
            }
        };
        try {
            user2.runAs((PrivilegedExceptionAction)hasPermissionAction);
            Assert.fail((String)"Should not come here");
        }
        catch (Exception e) {
            LOG.error("Call has permission error", (Throwable)e);
        }
        this.admin.hasUserPermissions((List)permissions);
        SecureTestUtil.AccessTestAction checkPermissionsAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TestAsyncAdminBase.TEST_UTIL.getConfiguration()).get();){
                    Object e = ((List)conn.getAdmin().hasUserPermissions(permissions).get()).get(0);
                    return e;
                }
            }
        };
        Assert.assertFalse((boolean)((Boolean)user2.runAs((PrivilegedExceptionAction)checkPermissionsAction)));
    }
}

