/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ClientPushbackTestBase;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncClientPushback
extends ClientPushbackTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncClientPushback.class);
    private AsyncConnectionImpl conn;
    private AsyncBufferedMutator mutator;

    @Before
    public void setUp() throws Exception {
        this.conn = (AsyncConnectionImpl)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
        this.mutator = this.conn.getBufferedMutator(tableName);
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.mutator, (boolean)true);
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    @Override
    protected ClientBackoffPolicy getBackoffPolicy() throws IOException {
        return this.conn.getBackoffPolicy();
    }

    @Override
    protected ServerStatisticTracker getStatisticsTracker() throws IOException {
        return (ServerStatisticTracker)this.conn.getStatisticsTracker().get();
    }

    @Override
    protected MetricsConnection getConnectionMetrics() throws IOException {
        return (MetricsConnection)this.conn.getConnectionMetrics().get();
    }

    @Override
    protected void mutate(Put put) throws IOException {
        CompletableFuture future = this.mutator.mutate((Mutation)put);
        this.mutator.flush();
        future.join();
    }

    @Override
    protected void mutate(Put put, AtomicLong endTime, CountDownLatch latch) throws IOException {
        FutureUtils.addListener((CompletableFuture)this.mutator.mutate((Mutation)put), (r, e) -> {
            endTime.set(EnvironmentEdgeManager.currentTime());
            latch.countDown();
        });
        this.mutator.flush();
    }

    @Override
    protected void mutateRow(RowMutations mutations) throws IOException {
        this.conn.getTable(tableName).mutateRow(mutations).join();
    }
}

