/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.common.io.Closeables;
import java.io.Closeable;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableLocatePrefetch {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableLocatePrefetch.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static AsyncConnection CONN;
    private static AsyncNonMetaRegionLocator LOCATOR;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt(AsyncNonMetaRegionLocator.LOCATE_PREFETCH_LIMIT, 100);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.createMultiRegionTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        LOCATOR = new AsyncNonMetaRegionLocator((AsyncConnectionImpl)CONN);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException, ExecutionException {
        Assert.assertNotNull(LOCATOR.getRegionLocations(TABLE_NAME, Bytes.toBytes((String)"zzz"), 0, RegionLocateType.CURRENT, false).get());
        Thread.sleep(1000L);
        Assert.assertNotNull((Object)LOCATOR.getRegionLocationInCache(TABLE_NAME, Bytes.toBytes((String)"aaa")));
        for (byte[] row : HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE) {
            Assert.assertNotNull((Object)LOCATOR.getRegionLocationInCache(TABLE_NAME, row));
        }
    }
}

