/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableScanRenewLease {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScanRenewLease.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static AsyncConnection CONN;
    private static AsyncTable<AdvancedScanResultConsumer> TABLE;
    private static int SCANNER_LEASE_TIMEOUT_PERIOD_MS;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.scanner.timeout.period", SCANNER_LEASE_TIMEOUT_PERIOD_MS);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        TABLE = CONN.getTable(TABLE_NAME);
        TABLE.putAll(IntStream.range(0, 10).mapToObj(i -> new Put(Bytes.toBytes((String)String.format("%02d", i))).addColumn(FAMILY, CQ, Bytes.toBytes((int)i))).collect(Collectors.toList())).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Throwable {
        RenewLeaseConsumer consumer = new RenewLeaseConsumer();
        TABLE.scan(new Scan(), (ScanResultConsumerBase)consumer);
        List<Result> results = consumer.get();
        Assert.assertEquals((long)10L, (long)results.size());
        IntStream.range(0, 10).forEach(i -> {
            Result result = (Result)results.get(i);
            Assert.assertEquals((Object)String.format("%02d", i), (Object)Bytes.toString((byte[])result.getRow()));
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQ)));
        });
        List results2 = (List)TABLE.scanAll(new Scan()).get();
        Assert.assertEquals((long)11L, (long)results2.size());
        IntStream.range(0, 11).forEach(i -> {
            Result result = (Result)results2.get(i);
            Assert.assertEquals((Object)String.format("%02d", i), (Object)Bytes.toString((byte[])result.getRow()));
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQ)));
        });
    }

    static {
        SCANNER_LEASE_TIMEOUT_PERIOD_MS = 5000;
    }

    private static final class RenewLeaseConsumer
    implements AdvancedScanResultConsumer {
        private final List<Result> results = new ArrayList<Result>();
        private Throwable error;
        private boolean finished = false;
        private boolean suspended = false;

        private RenewLeaseConsumer() {
        }

        public synchronized void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
            for (Result result : results) {
                this.results.add(result);
            }
            if (!this.suspended) {
                AdvancedScanResultConsumer.ScanResumer resumer = controller.suspend();
                new Thread(() -> {
                    Threads.sleep((long)(2 * SCANNER_LEASE_TIMEOUT_PERIOD_MS));
                    try {
                        TABLE.put(new Put(Bytes.toBytes((String)String.format("%02d", 10))).addColumn(FAMILY, CQ, Bytes.toBytes((int)10))).get();
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                    resumer.resume();
                }).start();
            }
        }

        public synchronized void onError(Throwable error) {
            this.finished = true;
            this.error = error;
            this.notifyAll();
        }

        public synchronized void onComplete() {
            this.finished = true;
            this.notifyAll();
        }

        public synchronized List<Result> get() throws Throwable {
            while (!this.finished) {
                this.wait();
            }
            if (this.error != null) {
                throw this.error;
            }
            return this.results;
        }
    }
}

