/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestBlockEvictionFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockEvictionFromClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockEvictionFromClient.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static byte[][] ROWS = new byte[2][];
    private static int NO_OF_THREADS = 3;
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] ROW1 = Bytes.toBytes((String)"testRow1");
    private static byte[] ROW2 = Bytes.toBytes((String)"testRow2");
    private static byte[] ROW3 = Bytes.toBytes((String)"testRow3");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[][] FAMILIES_1 = new byte[1][0];
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
    private static byte[] data = new byte[1000];
    private static byte[] data2 = Bytes.add((byte[])data, (byte[])data);
    protected static int SLAVES = 1;
    private static CountDownLatch latch;
    private static CountDownLatch getLatch;
    private static CountDownLatch compactionLatch;
    private static CountDownLatch exceptionLatch;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestBlockEvictionFromClient.ROWS[0] = ROW;
        TestBlockEvictionFromClient.ROWS[1] = ROW1;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{MultiRowMutationEndpoint.class.getName()});
        conf.setInt("hbase.regionserver.handler.count", 20);
        conf.setInt("hbase.bucketcache.size", 400);
        conf.setStrings("hbase.bucketcache.ioengine", new String[]{"offheap"});
        conf.setFloat("hfile.block.cache.size", 0.2f);
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.1f);
        conf.setInt("hbase.client.retries.number", 0);
        conf.setInt("hbase.client.scanner.timeout.period", 5000);
        TestBlockEvictionFromClient.FAMILIES_1[0] = FAMILY;
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        CustomInnerRegionObserver.waitForGets.set(false);
        CustomInnerRegionObserver.countOfNext.set(0);
        CustomInnerRegionObserver.countOfGets.set(0);
    }

    @After
    public void tearDown() throws Exception {
        TableName[] listTableNames;
        if (latch != null) {
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
        if (getLatch != null) {
            getLatch.countDown();
        }
        if (compactionLatch != null) {
            compactionLatch.countDown();
        }
        if (exceptionLatch != null) {
            exceptionLatch.countDown();
        }
        latch = null;
        getLatch = null;
        compactionLatch = null;
        exceptionLatch = null;
        CustomInnerRegionObserver.throwException.set(false);
        for (TableName tableName : listTableNames = TEST_UTIL.getAdmin().listTableNames()) {
            if (tableName.isSystemTable()) continue;
            TEST_UTIL.getAdmin().disableTable(tableName);
            TEST_UTIL.getAdmin().deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockEvictionWithParallelScans() throws Exception {
        try (Table table = null;){
            latch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserver.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
            region.flush(true);
            ScanThread[] scanThreads = this.initiateScan(table, false);
            Thread.sleep(100L);
            this.checkForBlockEviction(cache, false, false);
            for (ScanThread thread : scanThreads) {
                thread.join();
            }
            Iterator iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            byte[] data2 = Bytes.add((byte[])data, (byte[])data);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            Result r = table.get(new Get(ROW));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            System.out.println("Flushing cache");
            region.flush(true);
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            System.out.println("Compacting");
            Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
            store.triggerMajorCompaction();
            region.compact(true);
            this.waitForStoreFileCount(store, 1, 10000);
            Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            r = table.get(new Get(ROW));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelGetsAndScans() throws IOException, InterruptedException {
        try (Table table = null;){
            latch = new CountDownLatch(2);
            getLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserver.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            this.insertData(table);
            System.out.println("Flushing cache");
            region.flush(true);
            CustomInnerRegionObserver.waitForGets.set(true);
            ScanThread[] scanThreads = this.initiateScan(table, false);
            GetThread[] getThreads = this.initiateGet(table, false, false);
            this.checkForBlockEviction(cache, false, false);
            CustomInnerRegionObserver.waitForGets.set(false);
            this.checkForBlockEviction(cache, false, false);
            for (GetThread getThread : getThreads) {
                getThread.join();
            }
            CustomInnerRegionObserver.waitForGets.set(true);
            this.checkForBlockEviction(cache, true, false);
            getLatch.countDown();
            for (Thread thread : scanThreads) {
                thread.join();
            }
            System.out.println("Scans should have returned the bloks");
            CustomInnerRegionObserver.waitForGets.set(false);
            this.checkForBlockEviction(cache, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithCellsInDifferentFiles() throws IOException, InterruptedException {
        try (Table table = null;){
            latch = new CountDownLatch(1);
            getLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserver.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            region.flush(true);
            System.out.println("Flushing cache");
            CustomInnerRegionObserver.waitForGets.set(true);
            GetThread[] getThreads = this.initiateGet(table, false, false);
            Thread.sleep(200L);
            CustomInnerRegionObserver.getCdl().get().countDown();
            for (GetThread thread : getThreads) {
                thread.join();
            }
            CustomInnerRegionObserver.waitForGets.set(true);
            this.checkForBlockEviction(cache, true, false);
            getLatch.countDown();
            System.out.println("Gets should have returned the bloks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetsWithMultiColumnsAndExplicitTracker() throws IOException, InterruptedException {
        try (Table table = null;){
            latch = new CountDownLatch(1);
            getLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserver.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            BlockCache cache = this.setCacheProperties(region);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            for (int i = 1; i < 10; ++i) {
                put = new Put(ROW);
                put.addColumn(FAMILY, Bytes.toBytes((String)("testQualifier" + i)), data2);
                table.put(put);
                if (i % 2 != 0) continue;
                region.flush(true);
            }
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            region.flush(true);
            System.out.println("Flushing cache");
            CustomInnerRegionObserver.waitForGets.set(true);
            GetThread[] getThreads = this.initiateGet(table, true, false);
            Thread.sleep(200L);
            Iterator iterator = cache.iterator();
            boolean usedBlocksFound = false;
            int refCount = 0;
            int noOfBlocksWithRef = 0;
            while (iterator.hasNext()) {
                CachedBlock next = (CachedBlock)iterator.next();
                BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                System.out.println("The refCount is " + refCount);
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
                ++noOfBlocksWithRef;
            }
            Assert.assertTrue((boolean)usedBlocksFound);
            Assert.assertEquals((long)10L, (long)noOfBlocksWithRef);
            CustomInnerRegionObserver.getCdl().get().countDown();
            for (GetThread thread : getThreads) {
                thread.join();
            }
            CustomInnerRegionObserver.waitForGets.set(true);
            this.checkForBlockEviction(cache, true, false);
            getLatch.countDown();
            System.out.println("Gets should have returned the bloks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithMultipleColumnFamilies() throws IOException, InterruptedException {
        try (Table table = null;){
            latch = new CountDownLatch(1);
            getLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            byte[][] fams = new byte[10][];
            fams[0] = FAMILY;
            for (int i = 1; i < 10; ++i) {
                fams[i] = Bytes.toBytes((String)("testFamily" + i));
            }
            table = TEST_UTIL.createTable(tableName, (byte[][])fams, 1, 1024, CustomInnerRegionObserver.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            BlockCache cache = this.setCacheProperties(region);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            for (int i = 1; i < 10; ++i) {
                put = new Put(ROW);
                put.addColumn(Bytes.toBytes((String)("testFamily" + i)), Bytes.toBytes((String)("testQualifier" + i)), data2);
                table.put(put);
                if (i % 2 != 0) continue;
                region.flush(true);
            }
            region.flush(true);
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            region.flush(true);
            System.out.println("Flushing cache");
            CustomInnerRegionObserver.waitForGets.set(true);
            GetThread[] getThreads = this.initiateGet(table, true, true);
            Thread.sleep(200L);
            Iterator iterator = cache.iterator();
            boolean usedBlocksFound = false;
            int refCount = 0;
            int noOfBlocksWithRef = 0;
            while (iterator.hasNext()) {
                CachedBlock next = (CachedBlock)iterator.next();
                BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                System.out.println("The refCount is " + refCount);
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
                ++noOfBlocksWithRef;
            }
            Assert.assertTrue((boolean)usedBlocksFound);
            Assert.assertEquals((long)3L, (long)noOfBlocksWithRef);
            CustomInnerRegionObserver.getCdl().get().countDown();
            for (GetThread thread : getThreads) {
                thread.join();
            }
            CustomInnerRegionObserver.waitForGets.set(true);
            this.checkForBlockEviction(cache, true, false);
            getLatch.countDown();
            System.out.println("Gets should have returned the bloks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockRefCountAfterSplits() throws IOException, InterruptedException {
        try (Table table = null;){
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024);
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegion().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            put = new Put(ROW2);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            put = new Put(ROW3);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            region.flush(true);
            ServerName rs = (ServerName)Iterables.getOnlyElement((Iterable)TEST_UTIL.getAdmin().getRegionServers());
            int regionCount = TEST_UTIL.getAdmin().getRegions(rs).size();
            LOG.info("About to SPLIT on " + Bytes.toString((byte[])ROW1));
            TEST_UTIL.getAdmin().split(tableName, ROW1);
            TEST_UTIL.waitFor(60000L, () -> TEST_UTIL.getAdmin().getRegions(rs).size() > regionCount);
            region.compact(true);
            Iterator iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiGets() throws IOException, InterruptedException {
        try (Table table = null;){
            latch = new CountDownLatch(2);
            getLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserver.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            region.flush(true);
            System.out.println("Flushing cache");
            CustomInnerRegionObserver.waitForGets.set(true);
            MultiGetThread[] getThreads = this.initiateMultiGet(table);
            Thread.sleep(200L);
            Iterator iterator = cache.iterator();
            boolean foundNonZeroBlock = false;
            while (iterator.hasNext()) {
                int refCount;
                CachedBlock next = (CachedBlock)iterator.next();
                BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                foundNonZeroBlock = true;
            }
            Assert.assertTrue((String)"Should have found nonzero ref count block", (boolean)foundNonZeroBlock);
            CustomInnerRegionObserver.getCdl().get().countDown();
            CustomInnerRegionObserver.getCdl().get().countDown();
            for (MultiGetThread thread : getThreads) {
                thread.join();
            }
            CustomInnerRegionObserver.waitForGets.set(true);
            this.iterateBlockCache(cache, iterator);
            getLatch.countDown();
            System.out.println("Gets should have returned the bloks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanWithMultipleColumnFamilies() throws IOException, InterruptedException {
        try (Table table = null;){
            latch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            byte[][] fams = new byte[10][];
            fams[0] = FAMILY;
            for (int i = 1; i < 10; ++i) {
                fams[i] = Bytes.toBytes((String)("testFamily" + i));
            }
            table = TEST_UTIL.createTable(tableName, (byte[][])fams, 1, 1024, CustomInnerRegionObserver.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            BlockCache cache = this.setCacheProperties(region);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            region.flush(true);
            for (int i = 1; i < 10; ++i) {
                put = new Put(ROW);
                put.addColumn(Bytes.toBytes((String)("testFamily" + i)), Bytes.toBytes((String)("testQualifier" + i)), data2);
                table.put(put);
                if (i % 2 != 0) continue;
                region.flush(true);
            }
            region.flush(true);
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            region.flush(true);
            System.out.println("Flushing cache");
            ScanThread[] scanThreads = this.initiateScan(table, true);
            Thread.sleep(200L);
            Iterator iterator = cache.iterator();
            boolean usedBlocksFound = false;
            int refCount = 0;
            int noOfBlocksWithRef = 0;
            while (iterator.hasNext()) {
                CachedBlock next = (CachedBlock)iterator.next();
                BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                System.out.println("The refCount is " + refCount);
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
                ++noOfBlocksWithRef;
            }
            Assert.assertTrue((boolean)usedBlocksFound);
            Assert.assertEquals((long)12L, (long)noOfBlocksWithRef);
            CustomInnerRegionObserver.getCdl().get().countDown();
            for (ScanThread thread : scanThreads) {
                thread.join();
            }
            this.checkForBlockEviction(cache, true, false);
        }
    }

    private BlockCache setCacheProperties(HRegion region) {
        Iterator strItr = region.getStores().iterator();
        BlockCache cache = null;
        while (strItr.hasNext()) {
            HStore store = (HStore)strItr.next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            cache = (BlockCache)cacheConf.getBlockCache().get();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelGetsAndScanWithWrappedRegionScanner() throws IOException, InterruptedException {
        try (Table table = null;){
            latch = new CountDownLatch(2);
            getLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserverWrapper.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            this.insertData(table);
            System.out.println("Flushing cache");
            region.flush(true);
            CustomInnerRegionObserver.waitForGets.set(true);
            ScanThread[] scanThreads = this.initiateScan(table, false);
            GetThread[] getThreads = this.initiateGet(table, false, false);
            Thread.sleep(100L);
            CustomInnerRegionObserver.waitForGets.set(false);
            this.checkForBlockEviction(cache, false, false);
            CustomInnerRegionObserver.getCdl().get().countDown();
            for (GetThread getThread : getThreads) {
                getThread.join();
            }
            getLatch.countDown();
            for (Thread thread : scanThreads) {
                thread.join();
            }
        }
    }

    @Test
    public void testScanWithCompaction() throws IOException, InterruptedException {
        this.testScanWithCompactionInternals(this.name.getMethodName(), false);
    }

    @Test
    public void testReverseScanWithCompaction() throws IOException, InterruptedException {
        this.testScanWithCompactionInternals(this.name.getMethodName(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScanWithCompactionInternals(String tableNameStr, boolean reversed) throws IOException, InterruptedException {
        try (Table table = null;){
            BlockCacheKey cacheKey;
            latch = new CountDownLatch(1);
            compactionLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)tableNameStr);
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserverWrapper.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
            region.flush(true);
            int refCount = 0;
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            byte[] data2 = Bytes.add((byte[])data, (byte[])data);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            System.out.println("Flushing cache");
            region.flush(true);
            Iterator iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            ScanThread[] scanThreads = this.initiateScan(table, reversed);
            Thread.sleep(100L);
            iterator = cache.iterator();
            boolean usedBlocksFound = false;
            while (iterator.hasNext()) {
                ScanThread[] next = (ScanThread[])iterator.next();
                cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
            }
            Assert.assertTrue((String)"Blocks with non zero ref count should be found ", (boolean)usedBlocksFound);
            usedBlocksFound = false;
            System.out.println("Compacting");
            Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
            store.triggerMajorCompaction();
            region.compact(true);
            this.waitForStoreFileCount(store, 1, 10000);
            Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
            for (ScanThread[] next : cache) {
                cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
            }
            Assert.assertTrue((String)"Blocks with non zero ref count should be found ", (boolean)usedBlocksFound);
            compactionLatch.countDown();
            latch.countDown();
            for (ScanThread thread : scanThreads) {
                thread.join();
            }
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            Result r = table.get(new Get(ROW));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockEvictionAfterHBASE13082WithCompactionAndFlush() throws IOException, InterruptedException {
        try (Table table = null;){
            BlockCacheKey cacheKey;
            latch = new CountDownLatch(1);
            compactionLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserverWrapper.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
            region.flush(true);
            int refCount = 0;
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            byte[] data2 = Bytes.add((byte[])data, (byte[])data);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            System.out.println("Flushing cache");
            region.flush(true);
            Iterator iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            ScanThread[] scanThreads = this.initiateScan(table, false);
            Thread.sleep(100L);
            iterator = cache.iterator();
            boolean usedBlocksFound = false;
            while (iterator.hasNext()) {
                ScanThread[] next = (ScanThread[])iterator.next();
                cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
            }
            QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            data2 = Bytes.add((byte[])data, (byte[])data);
            put = new Put(ROW1);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            System.out.println("Flushing cache");
            region.flush(true);
            Assert.assertTrue((String)"Blocks with non zero ref count should be found ", (boolean)usedBlocksFound);
            usedBlocksFound = false;
            System.out.println("Compacting");
            Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
            store.triggerMajorCompaction();
            region.compact(true);
            this.waitForStoreFileCount(store, 1, 10000);
            Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
            for (ScanThread[] next : cache) {
                cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
            }
            Assert.assertTrue((String)"Blocks with non zero ref count should be found ", (boolean)usedBlocksFound);
            compactionLatch.countDown();
            latch.countDown();
            for (ScanThread thread : scanThreads) {
                thread.join();
            }
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
            Result r = table.get(new Get(ROW));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            iterator = cache.iterator();
            this.iterateBlockCache(cache, iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanWithException() throws IOException, InterruptedException {
        try (Table table = null;){
            CachedBlock next;
            latch = new CountDownLatch(1);
            exceptionLatch = new CountDownLatch(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            table = TEST_UTIL.createTable(tableName, FAMILIES_1, 1, 1024, CustomInnerRegionObserverWrapper.class.getName());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            this.insertData(table);
            System.out.println("Flushing cache");
            region.flush(true);
            CustomInnerRegionObserver.throwException.set(true);
            CachedBlock scanThreads = this.initiateScan(table, false);
            Thread.sleep(100L);
            Iterator iterator = cache.iterator();
            boolean usedBlocksFound = false;
            int refCount = 0;
            while (iterator.hasNext()) {
                next = (CachedBlock)iterator.next();
                BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
            }
            Assert.assertTrue((boolean)usedBlocksFound);
            exceptionLatch.countDown();
            CustomInnerRegionObserver.getCdl().get().countDown();
            for (ScanThread thread : scanThreads) {
                thread.join();
            }
            iterator = cache.iterator();
            usedBlocksFound = false;
            refCount = 0;
            while (iterator.hasNext()) {
                next = (CachedBlock)iterator.next();
                BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
                if (cache instanceof BucketCache) {
                    refCount = ((BucketCache)cache).getRefCount(cacheKey);
                } else {
                    if (!(cache instanceof CombinedBlockCache)) continue;
                    refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
                }
                if (refCount == 0) continue;
                Assert.assertEquals((long)NO_OF_THREADS, (long)refCount);
                usedBlocksFound = true;
            }
            Assert.assertFalse((boolean)usedBlocksFound);
            Assert.assertEquals((long)0L, (long)refCount);
        }
    }

    private void iterateBlockCache(BlockCache cache, Iterator<CachedBlock> iterator) {
        while (iterator.hasNext()) {
            int refCount;
            CachedBlock next = iterator.next();
            BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
            if (cache instanceof BucketCache) {
                refCount = ((BucketCache)cache).getRefCount(cacheKey);
            } else {
                if (!(cache instanceof CombinedBlockCache)) continue;
                refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
            }
            Assert.assertEquals((long)0L, (long)refCount);
        }
    }

    private void insertData(Table table) throws IOException {
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, data);
        table.put(put);
        put = new Put(ROW1);
        put.addColumn(FAMILY, QUALIFIER, data);
        table.put(put);
        byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
        put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER2, data2);
        table.put(put);
    }

    private ScanThread[] initiateScan(Table table, boolean reverse) throws IOException, InterruptedException {
        ScanThread[] scanThreads = new ScanThread[NO_OF_THREADS];
        for (int i = 0; i < NO_OF_THREADS; ++i) {
            scanThreads[i] = new ScanThread(table, reverse);
        }
        for (ScanThread thread : scanThreads) {
            thread.start();
        }
        return scanThreads;
    }

    private GetThread[] initiateGet(Table table, boolean tracker, boolean multipleCFs) throws IOException, InterruptedException {
        GetThread[] getThreads = new GetThread[NO_OF_THREADS];
        for (int i = 0; i < NO_OF_THREADS; ++i) {
            getThreads[i] = new GetThread(table, tracker, multipleCFs);
        }
        for (GetThread thread : getThreads) {
            thread.start();
        }
        return getThreads;
    }

    private MultiGetThread[] initiateMultiGet(Table table) throws IOException, InterruptedException {
        MultiGetThread[] multiGetThreads = new MultiGetThread[NO_OF_THREADS];
        for (int i = 0; i < NO_OF_THREADS; ++i) {
            multiGetThreads[i] = new MultiGetThread(table);
        }
        for (MultiGetThread thread : multiGetThreads) {
            thread.start();
        }
        return multiGetThreads;
    }

    private void checkForBlockEviction(BlockCache cache, boolean getClosed, boolean expectOnlyZero) throws InterruptedException {
        int counter = NO_OF_THREADS;
        if (CustomInnerRegionObserver.waitForGets.get()) {
            --counter;
            while (CustomInnerRegionObserver.countOfGets.get() < NO_OF_THREADS) {
                Thread.sleep(100L);
            }
        } else {
            while (CustomInnerRegionObserver.countOfNext.get() < NO_OF_THREADS) {
                Thread.sleep(100L);
            }
        }
        Iterator iterator = cache.iterator();
        int refCount = 0;
        while (iterator.hasNext()) {
            CachedBlock next = (CachedBlock)iterator.next();
            BlockCacheKey cacheKey = new BlockCacheKey(next.getFilename(), next.getOffset());
            if (cache instanceof BucketCache) {
                refCount = ((BucketCache)cache).getRefCount(cacheKey);
            } else {
                if (!(cache instanceof CombinedBlockCache)) continue;
                refCount = ((CombinedBlockCache)cache).getRefCount(cacheKey);
            }
            System.out.println(" the refcount is " + refCount + " block is " + cacheKey);
            if (CustomInnerRegionObserver.waitForGets.get()) {
                if (expectOnlyZero) {
                    Assert.assertTrue((refCount == 0 ? 1 : 0) != 0);
                }
                if (refCount == 0) continue;
                if (getClosed) {
                    Assert.assertEquals((long)refCount, (long)CustomInnerRegionObserver.countOfGets.get());
                    continue;
                }
                Assert.assertEquals((long)refCount, (long)(CustomInnerRegionObserver.countOfGets.get() + NO_OF_THREADS));
                continue;
            }
            if (expectOnlyZero) {
                Assert.assertTrue((refCount == 0 ? 1 : 0) != 0);
            }
            if (refCount == 0) continue;
            if (getLatch == null) {
                Assert.assertEquals((long)refCount, (long)CustomInnerRegionObserver.countOfNext.get());
                continue;
            }
            Assert.assertEquals((long)refCount, (long)(CustomInnerRegionObserver.countOfNext.get() + NO_OF_THREADS));
        }
        CustomInnerRegionObserver.getCdl().get().countDown();
    }

    private void waitForStoreFileCount(HStore store, int count, int timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (start + (long)timeout > System.currentTimeMillis() && store.getStorefilesCount() != count) {
            Thread.sleep(100L);
        }
        System.out.println("start=" + start + ", now=" + System.currentTimeMillis() + ", cur=" + store.getStorefilesCount());
        Assert.assertEquals((long)count, (long)store.getStorefilesCount());
    }

    public static class CustomInnerRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        static final AtomicLong sleepTime = new AtomicLong(0L);
        static final AtomicBoolean slowDownNext = new AtomicBoolean(false);
        static final AtomicInteger countOfNext = new AtomicInteger(0);
        static final AtomicInteger countOfGets = new AtomicInteger(0);
        static final AtomicBoolean waitForGets = new AtomicBoolean(false);
        static final AtomicBoolean throwException = new AtomicBoolean(false);
        private static final AtomicReference<CountDownLatch> cdl = new AtomicReference<CountDownLatch>(new CountDownLatch(0));

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            this.slowdownCode(e, false);
            if (getLatch != null && getLatch.getCount() > 0L) {
                try {
                    getLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return hasMore;
        }

        public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            this.slowdownCode(e, true);
        }

        public static AtomicReference<CountDownLatch> getCdl() {
            return cdl;
        }

        private void slowdownCode(ObserverContext<RegionCoprocessorEnvironment> e, boolean isGet) {
            CountDownLatch latch = CustomInnerRegionObserver.getCdl().get();
            try {
                System.out.println(latch.getCount() + " is the count " + isGet);
                if (latch.getCount() > 0L) {
                    if (isGet) {
                        countOfGets.incrementAndGet();
                    } else {
                        countOfNext.incrementAndGet();
                    }
                    LOG.info("Waiting for the counterCountDownLatch");
                    latch.await(2L, TimeUnit.MINUTES);
                    if (latch.getCount() > 0L) {
                        throw new RuntimeException("Can't wait more");
                    }
                }
            }
            catch (InterruptedException e1) {
                LOG.error(e1.toString(), (Throwable)e1);
            }
        }
    }

    public static class CustomInnerRegionObserverWrapper
    extends CustomInnerRegionObserver {
        public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
            return new CustomScanner(s);
        }
    }

    private static class CustomScanner
    implements RegionScanner {
        private RegionScanner delegate;

        public CustomScanner(RegionScanner delegate) {
            this.delegate = delegate;
        }

        public boolean next(List<Cell> results) throws IOException {
            return this.delegate.next(results);
        }

        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return this.delegate.next(result, scannerContext);
        }

        public boolean nextRaw(List<Cell> result) throws IOException {
            return this.delegate.nextRaw(result);
        }

        public boolean nextRaw(List<Cell> result, ScannerContext context) throws IOException {
            boolean nextRaw = this.delegate.nextRaw(result, context);
            if (compactionLatch != null && compactionLatch.getCount() > 0L) {
                try {
                    compactionLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (CustomInnerRegionObserver.throwException.get() && exceptionLatch.getCount() > 0L) {
                try {
                    exceptionLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throw new IOException("throw exception");
            }
            return nextRaw;
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public RegionInfo getRegionInfo() {
            return this.delegate.getRegionInfo();
        }

        public boolean isFilterDone() throws IOException {
            return this.delegate.isFilterDone();
        }

        public boolean reseek(byte[] row) throws IOException {
            return false;
        }

        public long getMaxResultSize() {
            return this.delegate.getMaxResultSize();
        }

        public long getMvccReadPoint() {
            return this.delegate.getMvccReadPoint();
        }

        public int getBatch() {
            return this.delegate.getBatch();
        }
    }

    private static class ScanThread
    extends Thread {
        private final Table table;
        private final boolean reverse;

        public ScanThread(Table table, boolean reverse) {
            this.table = table;
            this.reverse = reverse;
        }

        @Override
        public void run() {
            try {
                this.initiateScan(this.table);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void initiateScan(Table table) throws IOException {
            Scan scan = new Scan();
            if (this.reverse) {
                scan.setReversed(true);
            }
            CustomInnerRegionObserver.getCdl().set(latch);
            ResultScanner resScanner = table.getScanner(scan);
            int i = this.reverse ? ROWS.length - 1 : 0;
            boolean resultFound = false;
            for (Result result : resScanner) {
                resultFound = true;
                System.out.println(result);
                if (!this.reverse) {
                    Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])ROWS[i]));
                    ++i;
                    continue;
                }
                Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])ROWS[i]));
                --i;
            }
            Assert.assertTrue((boolean)resultFound);
        }
    }

    private static class GetThread
    extends Thread {
        private final Table table;
        private final boolean tracker;
        private final boolean multipleCFs;

        public GetThread(Table table, boolean tracker, boolean multipleCFs) {
            this.table = table;
            this.tracker = tracker;
            this.multipleCFs = multipleCFs;
        }

        @Override
        public void run() {
            try {
                this.initiateGet(this.table);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void initiateGet(Table table) throws IOException {
            Get get = new Get(ROW);
            if (this.tracker) {
                if (!this.multipleCFs) {
                    get.addColumn(FAMILY, Bytes.toBytes((String)"testQualifier3"));
                    get.addColumn(FAMILY, Bytes.toBytes((String)"testQualifier8"));
                    get.addColumn(FAMILY, Bytes.toBytes((String)"testQualifier9"));
                    get.addColumn(FAMILY, Bytes.toBytes((String)"testQualifier900"));
                } else {
                    get.addColumn(Bytes.toBytes((String)"testFamily3"), Bytes.toBytes((String)"testQualifier3"));
                    get.addColumn(Bytes.toBytes((String)"testFamily8"), Bytes.toBytes((String)"testQualifier8"));
                    get.addColumn(Bytes.toBytes((String)"testFamily9"), Bytes.toBytes((String)"testQualifier9"));
                    get.addColumn(Bytes.toBytes((String)"testFamily9"), Bytes.toBytes((String)"testQualifier900"));
                }
            }
            CustomInnerRegionObserver.getCdl().set(latch);
            Result r = table.get(get);
            System.out.println(r);
            if (!this.tracker) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            } else if (!this.multipleCFs) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"testQualifier3")), (byte[])data2));
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"testQualifier8")), (byte[])data2));
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, Bytes.toBytes((String)"testQualifier9")), (byte[])data2));
            } else {
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(Bytes.toBytes((String)"testFamily3"), Bytes.toBytes((String)"testQualifier3")), (byte[])data2));
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(Bytes.toBytes((String)"testFamily8"), Bytes.toBytes((String)"testQualifier8")), (byte[])data2));
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(Bytes.toBytes((String)"testFamily9"), Bytes.toBytes((String)"testQualifier9")), (byte[])data2));
            }
        }
    }

    private static class MultiGetThread
    extends Thread {
        private final Table table;
        private final List<Get> gets = new ArrayList<Get>();

        public MultiGetThread(Table table) {
            this.table = table;
        }

        @Override
        public void run() {
            this.gets.add(new Get(ROW));
            this.gets.add(new Get(ROW1));
            try {
                CustomInnerRegionObserver.getCdl().set(latch);
                Result[] r = this.table.get(this.gets);
                Assert.assertTrue((boolean)Bytes.equals((byte[])r[0].getRow(), (byte[])ROW));
                Assert.assertTrue((boolean)Bytes.equals((byte[])r[1].getRow(), (byte[])ROW1));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

