/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.regionserver.DelegatingKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestFromClientSideScanExcpetion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFromClientSideScanExcpetion.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static int SLAVES = 3;
    @Rule
    public TestName name = new TestName();
    private static AtomicBoolean ON = new AtomicBoolean(false);
    private static AtomicLong REQ_COUNT = new AtomicLong(0L);
    private static AtomicBoolean IS_DO_NOT_RETRY = new AtomicBoolean(false);
    private static AtomicBoolean THROW_ONCE = new AtomicBoolean(true);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.client.scanner.timeout.period", 6000000L);
        conf.setClass("hbase.hregion.impl", MyHRegion.class, HRegion.class);
        conf.setBoolean("hbase.client.log.scanner.activity", true);
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void reset() {
        ON.set(false);
        REQ_COUNT.set(0L);
        IS_DO_NOT_RETRY.set(false);
        THROW_ONCE.set(true);
    }

    private static void inject() {
        ON.set(true);
    }

    @Test
    public void testClientScannerIsResetWhenScanThrowsIOException() throws IOException, InterruptedException {
        TestFromClientSideScanExcpetion.reset();
        THROW_ONCE.set(true);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Table t = TEST_UTIL.createTable(tableName, FAMILY);){
            int rowCount = TEST_UTIL.loadTable(t, FAMILY, false);
            TEST_UTIL.getAdmin().flush(tableName);
            TestFromClientSideScanExcpetion.inject();
            int actualRowCount = TEST_UTIL.countRows(t, new Scan().addColumn(FAMILY, FAMILY));
            Assert.assertEquals((long)rowCount, (long)actualRowCount);
        }
        Assert.assertTrue((REQ_COUNT.get() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testScannerThrowsExceptionWhenCoprocessorThrowsDNRIOE() throws IOException, InterruptedException {
        TestFromClientSideScanExcpetion.reset();
        IS_DO_NOT_RETRY.set(true);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Table t = TEST_UTIL.createTable(tableName, FAMILY);){
            TEST_UTIL.loadTable(t, FAMILY, false);
            TEST_UTIL.getAdmin().flush(tableName);
            TestFromClientSideScanExcpetion.inject();
            TEST_UTIL.countRows(t, new Scan().addColumn(FAMILY, FAMILY));
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        Assert.assertTrue((REQ_COUNT.get() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testScannerFailsAfterRetriesWhenCoprocessorThrowsIOE() throws IOException, InterruptedException {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TestFromClientSideScanExcpetion.reset();
        THROW_ONCE.set(false);
        try (Table t = TEST_UTIL.createTable(tableName, FAMILY);){
            TEST_UTIL.loadTable(t, FAMILY, false);
            TEST_UTIL.getAdmin().flush(tableName);
            TestFromClientSideScanExcpetion.inject();
            TEST_UTIL.countRows(t, new Scan().addColumn(FAMILY, FAMILY));
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (DoNotRetryIOException expected) {
            Assert.assertThat((Object)((Object)expected), (Matcher)CoreMatchers.instanceOf(ScannerResetException.class));
        }
        Assert.assertTrue((REQ_COUNT.get() >= 3L ? 1 : 0) != 0);
    }

    public static final class MyStoreScanner
    extends StoreScanner {
        public MyStoreScanner(HStore store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
            super(store, scanInfo, scan, columns, readPt);
        }

        protected List<KeyValueScanner> selectScannersFrom(HStore store, List<? extends KeyValueScanner> allScanners) {
            List scanners = super.selectScannersFrom(store, allScanners);
            ArrayList<KeyValueScanner> newScanners = new ArrayList<KeyValueScanner>(scanners.size());
            for (KeyValueScanner scanner : scanners) {
                newScanners.add(new DelegatingKeyValueScanner(scanner){

                    @Override
                    public boolean reseek(Cell key) throws IOException {
                        if (ON.get()) {
                            REQ_COUNT.incrementAndGet();
                            if (!THROW_ONCE.get() || REQ_COUNT.get() == 1L) {
                                if (IS_DO_NOT_RETRY.get()) {
                                    throw new DoNotRetryIOException("Injected exception");
                                }
                                throw new IOException("Injected exception");
                            }
                        }
                        return super.reseek(key);
                    }
                });
            }
            return newScanners;
        }
    }

    public static final class MyHStore
    extends HStore {
        public MyHStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam, boolean warmup) throws IOException {
            super(region, family, confParam, warmup);
        }

        protected KeyValueScanner createScanner(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
            return scan.isReversed() ? new ReversedStoreScanner((HStore)this, scanInfo, scan, targetCols, readPt) : new MyStoreScanner(this, scanInfo, scan, targetCols, readPt);
        }
    }

    public static final class MyHRegion
    extends HRegion {
        public MyHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        protected HStore instantiateHStore(ColumnFamilyDescriptor family, boolean warmup) throws IOException {
            return new MyHStore(this, family, this.conf, warmup);
        }
    }
}

