/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class, ClientTests.class})
public class TestHBaseAdminNoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseAdminNoCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHBaseAdminNoCluster.class);
    @Rule
    public TestName name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testMasterMonitorCallableRetries() throws MasterNotRunningException, ZooKeeperConnectionException, IOException, ch.cern.hbase.thirdparty.com.google.protobuf.ServiceException {
        Configuration configuration = HBaseConfiguration.create();
        configuration.setLong("hbase.client.pause", 1L);
        int count = 10;
        configuration.setInt("hbase.client.retries.number", 10);
        ClusterConnection connection = HConnectionTestingUtility.getMockedConnection(configuration);
        MasterKeepAliveConnection masterAdmin = (MasterKeepAliveConnection)Mockito.mock(MasterKeepAliveConnection.class);
        Mockito.when((Object)masterAdmin.createTable((RpcController)Mockito.any(), (MasterProtos.CreateTableRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException("Test fail").initCause((Throwable)new PleaseHoldException("test"))});
        Mockito.when((Object)connection.getMaster()).thenReturn((Object)masterAdmin);
        HBaseAdmin admin = new HBaseAdmin(connection);
        try {
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
            try {
                admin.createTable((TableDescriptor)htd, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
                Assert.fail();
            }
            catch (RetriesExhaustedException e) {
                LOG.info("Expected fail", (Throwable)e);
            }
            ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)10))).createTable((RpcController)Mockito.any(), (MasterProtos.CreateTableRequest)Mockito.any());
        }
        finally {
            admin.close();
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testMasterOperationsRetries() throws Exception {
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.listTables();
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).getTableDescriptors((RpcController)Mockito.any(), (MasterProtos.GetTableDescriptorsRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.listTableNames();
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).getTableNames((RpcController)Mockito.any(), (MasterProtos.GetTableNamesRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.getTableDescriptor(TableName.valueOf((String)TestHBaseAdminNoCluster.this.name.getMethodName()));
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).getTableDescriptors((RpcController)Mockito.any(), (MasterProtos.GetTableDescriptorsRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.getTableDescriptorsByTableName(new ArrayList());
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).getTableDescriptors((RpcController)Mockito.any(), (MasterProtos.GetTableDescriptorsRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.move(new byte[0]);
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).moveRegion((RpcController)Mockito.any(), (MasterProtos.MoveRegionRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.offline(new byte[0]);
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).offlineRegion((RpcController)Mockito.any(), (MasterProtos.OfflineRegionRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.setBalancerRunning(true, true);
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).setBalancerRunning((RpcController)Mockito.any(), (MasterProtos.SetBalancerRunningRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.balancer();
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).balance((RpcController)Mockito.any(), (MasterProtos.BalanceRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.enableCatalogJanitor(true);
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).enableCatalogJanitor((RpcController)Mockito.any(), (MasterProtos.EnableCatalogJanitorRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.runCatalogScan();
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).runCatalogScan((RpcController)Mockito.any(), (MasterProtos.RunCatalogScanRequest)Mockito.any());
            }
        });
        this.testMasterOperationIsRetried(new MethodCaller(){

            @Override
            public void call(Admin admin) throws Exception {
                admin.isCatalogJanitorEnabled();
            }

            @Override
            public void verify(MasterKeepAliveConnection masterAdmin, int count) throws Exception {
                ((MasterKeepAliveConnection)Mockito.verify((Object)masterAdmin, (VerificationMode)Mockito.atLeast((int)count))).isCatalogJanitorEnabled((RpcController)Mockito.any(), (MasterProtos.IsCatalogJanitorEnabledRequest)Mockito.any());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMasterOperationIsRetried(MethodCaller caller) throws Exception {
        Configuration configuration = HBaseConfiguration.create();
        configuration.setLong("hbase.client.pause", 1L);
        int count = 10;
        configuration.setInt("hbase.client.retries.number", 10);
        ClusterConnection connection = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        Mockito.when((Object)connection.getConfiguration()).thenReturn((Object)configuration);
        MasterKeepAliveConnection masterAdmin = (MasterKeepAliveConnection)Mockito.mock(MasterKeepAliveConnection.class, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                if (invocation.getMethod().getName().equals("close")) {
                    return null;
                }
                throw new MasterNotRunningException();
            }
        });
        Mockito.when((Object)connection.getMaster()).thenReturn((Object)masterAdmin);
        RpcControllerFactory rpcControllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        Mockito.when((Object)connection.getRpcControllerFactory()).thenReturn((Object)rpcControllerFactory);
        Mockito.when((Object)rpcControllerFactory.newController()).thenReturn(Mockito.mock(HBaseRpcController.class));
        RpcRetryingCallerFactory callerFactory = new RpcRetryingCallerFactory(configuration);
        Mockito.when((Object)connection.getRpcRetryingCallerFactory()).thenReturn((Object)callerFactory);
        try (Admin admin = null;){
            admin = (Admin)Mockito.spy((Object)new HBaseAdmin(connection));
            ((HBaseAdmin)Mockito.doReturn(null).when((Object)((HBaseAdmin)admin))).getRegion((byte[])Matchers.any());
            try {
                caller.call(admin);
                Assert.fail();
            }
            catch (RetriesExhaustedException e) {
                LOG.info("Expected fail", (Throwable)e);
            }
            caller.verify(masterAdmin, 10);
        }
    }

    private static interface MethodCaller {
        public void call(Admin var1) throws Exception;

        public void verify(MasterKeepAliveConnection var1, int var2) throws Exception;
    }
}

