/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, MediumTests.class})
public class TestFuzzyRowAndColumnRangeFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFuzzyRowAndColumnRangeFilter.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestFuzzyRowAndColumnRangeFilter.class);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void Test() throws Exception {
        String cf = "f";
        Table ht = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)cf), Integer.MAX_VALUE);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int i2 = 0; i2 < 5; ++i2) {
                byte[] rk = new byte[10];
                ByteBuffer buf = ByteBuffer.wrap(rk);
                buf.clear();
                buf.putShort((short)2);
                buf.putInt(i1);
                buf.putInt(i2);
                for (int c = 0; c < 5; ++c) {
                    byte[] cq = new byte[4];
                    Bytes.putBytes((byte[])cq, (int)0, (byte[])Bytes.toBytes((int)c), (int)0, (int)4);
                    Put p = new Put(rk);
                    p.setDurability(Durability.SKIP_WAL);
                    p.addColumn(cf.getBytes(), cq, Bytes.toBytes((int)c));
                    ht.put(p);
                    LOG.info("Inserting: rk: " + Bytes.toStringBinary((byte[])rk) + " cq: " + Bytes.toStringBinary((byte[])cq));
                }
            }
        }
        TEST_UTIL.flush();
        this.runTest(ht, 0, 10);
        this.runTest(ht, 1, 8);
    }

    private void runTest(Table hTable, int cqStart, int expectedSize) throws IOException {
        byte[] fuzzyKey = new byte[10];
        ByteBuffer buf = ByteBuffer.wrap(fuzzyKey);
        buf.clear();
        buf.putShort((short)2);
        for (int i = 0; i < 4; ++i) {
            buf.put((byte)63);
        }
        buf.putInt(1);
        byte[] mask = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        Pair pair = new Pair((Object)fuzzyKey, (Object)mask);
        FuzzyRowFilter fuzzyRowFilter = new FuzzyRowFilter((List)Lists.newArrayList((Object[])new Pair[]{pair}));
        ColumnRangeFilter columnRangeFilter = new ColumnRangeFilter(Bytes.toBytes((int)cqStart), true, Bytes.toBytes((int)4), true);
        this.runScanner(hTable, expectedSize, new Filter[]{fuzzyRowFilter, columnRangeFilter});
        this.runScanner(hTable, expectedSize, new Filter[]{columnRangeFilter, fuzzyRowFilter});
    }

    private void runScanner(Table hTable, int expectedSize, Filter ... filters) throws IOException {
        Result result;
        String cf = "f";
        Scan scan = new Scan();
        scan.addFamily(cf.getBytes());
        FilterList filterList = new FilterList(filters);
        scan.setFilter((Filter)filterList);
        ResultScanner scanner = hTable.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        long timeBeforeScan = System.currentTimeMillis();
        while ((result = scanner.next()) != null) {
            for (Cell kv : result.listCells()) {
                LOG.info("Got rk: " + Bytes.toStringBinary((byte[])CellUtil.cloneRow((Cell)kv)) + " cq: " + Bytes.toStringBinary((byte[])CellUtil.cloneQualifier((Cell)kv)));
                results.add(kv);
            }
        }
        long scanTime = System.currentTimeMillis() - timeBeforeScan;
        scanner.close();
        LOG.info("scan time = " + scanTime + "ms");
        LOG.info("found " + results.size() + " results");
        Assert.assertEquals((long)expectedSize, (long)results.size());
    }
}

