/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import ch.cern.hbase.thirdparty.io.netty.channel.Channel;
import ch.cern.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import ch.cern.hbase.thirdparty.io.netty.channel.epoll.EpollEventLoopGroup;
import ch.cern.hbase.thirdparty.io.netty.channel.epoll.EpollSocketChannel;
import ch.cern.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import ch.cern.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AbstractTestIPC;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyRpcServerPreambleHandler;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JVM;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, SmallTests.class})
public class TestNettyIPC
extends AbstractTestIPC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyIPC.class);
    @Parameterized.Parameter
    public String eventLoopType;
    private static NioEventLoopGroup NIO;
    private static EpollEventLoopGroup EPOLL;

    @Parameterized.Parameters(name="{index}: EventLoop={0}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{"nio"});
        params.add(new Object[]{"perClientNio"});
        if (JVM.isLinux() && JVM.isAmd64()) {
            params.add(new Object[]{"epoll"});
        }
        return params;
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        NIO = new NioEventLoopGroup();
        if (JVM.isLinux() && JVM.isAmd64()) {
            EPOLL = new EpollEventLoopGroup();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() {
        if (NIO != null) {
            NIO.shutdownGracefully();
        }
        if (EPOLL != null) {
            EPOLL.shutdownGracefully();
        }
    }

    private void setConf(Configuration conf) {
        switch (this.eventLoopType) {
            case "nio": {
                NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)conf, (EventLoopGroup)NIO, NioSocketChannel.class);
                break;
            }
            case "epoll": {
                NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)conf, (EventLoopGroup)EPOLL, EpollSocketChannel.class);
                break;
            }
            case "perClientNio": {
                NettyRpcClientConfigHelper.createEventLoopPerClient((Configuration)conf);
                break;
            }
        }
    }

    @Override
    protected RpcServer createRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        return new NettyRpcServer(server, name, services, bindAddress, conf, scheduler, true);
    }

    protected NettyRpcClient createRpcClientNoCodec(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf){

            Codec getCodec() {
                return null;
            }
        };
    }

    protected NettyRpcClient createRpcClient(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf);
    }

    protected NettyRpcClient createRpcClientRTEDuringConnectionSetup(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf){

            boolean isTcpNoDelay() {
                throw new RuntimeException("Injected fault");
            }
        };
    }

    @Override
    protected RpcServer createTestFailingRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        return new TestFailingRpcServer(server, name, services, bindAddress, conf, scheduler);
    }

    private static class TestFailingRpcServer
    extends NettyRpcServer {
        TestFailingRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
            super(server, name, services, bindAddress, conf, scheduler, true);
        }

        protected NettyRpcServerPreambleHandler createNettyRpcServerPreambleHandler() {
            return new NettyRpcServerPreambleHandler(this){

                protected NettyServerRpcConnection createNettyServerRpcConnection(Channel channel) {
                    return new FailingConnection(this, channel);
                }
            };
        }

        static final class FailingConnection
        extends NettyServerRpcConnection {
            private FailingConnection(TestFailingRpcServer rpcServer, Channel channel) {
                super((NettyRpcServer)rpcServer, channel);
            }

            public void processRequest(ByteBuff buf) throws IOException, InterruptedException {
                throw new DoNotRetryIOException("Failing for test");
            }
        }
    }
}

