/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import ch.cern.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestAssignmentManagerBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestAssignmentManagerBase.class);
    @Rule
    public TestName name = new TestName();
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    protected static final int PROC_NTHREADS = 64;
    protected static final int NREGIONS = 1000;
    protected static final int NSERVERS = Math.max(1, 10);
    protected HBaseTestingUtility util;
    protected MockRSProcedureDispatcher rsDispatcher;
    protected MockMasterServices master;
    protected AssignmentManager am;
    protected NavigableMap<ServerName, SortedSet<byte[]>> regionsToRegionServers = new ConcurrentSkipListMap<ServerName, SortedSet<byte[]>>();
    protected ScheduledExecutorService executor;
    protected ProcedureMetrics assignProcMetrics;
    protected ProcedureMetrics unassignProcMetrics;
    protected ProcedureMetrics moveProcMetrics;
    protected ProcedureMetrics reopenProcMetrics;
    protected ProcedureMetrics openProcMetrics;
    protected ProcedureMetrics closeProcMetrics;
    protected long assignSubmittedCount = 0L;
    protected long assignFailedCount = 0L;
    protected long unassignSubmittedCount = 0L;
    protected long unassignFailedCount = 0L;
    protected long moveSubmittedCount = 0L;
    protected long moveFailedCount = 0L;
    protected long reopenSubmittedCount = 0L;
    protected long reopenFailedCount = 0L;
    protected long openSubmittedCount = 0L;
    protected long openFailedCount = 0L;
    protected long closeSubmittedCount = 0L;
    protected long closeFailedCount = 0L;
    protected int newRsAdded;

    protected int getAssignMaxAttempts() {
        return 1000;
    }

    protected void setupConfiguration(Configuration conf) throws Exception {
        FSUtils.setRootDir((Configuration)conf, (Path)this.util.getDataTestDir());
        conf.setBoolean("hbase.procedure.store.wal.use.hsync", false);
        conf.setInt("hbase.procedure.store.wal.sync.wait.msec", 10);
        conf.setInt("hbase.master.procedure.threads", 64);
        conf.setInt("hbase.regionserver.rpc.startup.waittime", 1000);
        conf.setInt("hbase.assignment.maximum.attempts", this.getAssignMaxAttempts());
        conf.setLong("hbase.procedure.retry.sleep.interval.ms", 10L);
        conf.setLong("hbase.procedure.retry.max.sleep.time.ms", 100L);
    }

    @Before
    public void setUp() throws Exception {
        this.util = new HBaseTestingUtility();
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setUncaughtExceptionHandler((t, e) -> LOG.warn("Uncaught: ", e)).build());
        this.setupConfiguration(this.util.getConfiguration());
        this.master = new MockMasterServices(this.util.getConfiguration(), this.regionsToRegionServers);
        this.rsDispatcher = new MockRSProcedureDispatcher(this.master);
        this.master.start(NSERVERS, this.rsDispatcher);
        this.newRsAdded = 0;
        this.am = this.master.getAssignmentManager();
        this.assignProcMetrics = this.am.getAssignmentManagerMetrics().getAssignProcMetrics();
        this.unassignProcMetrics = this.am.getAssignmentManagerMetrics().getUnassignProcMetrics();
        this.moveProcMetrics = this.am.getAssignmentManagerMetrics().getMoveProcMetrics();
        this.reopenProcMetrics = this.am.getAssignmentManagerMetrics().getReopenProcMetrics();
        this.openProcMetrics = this.am.getAssignmentManagerMetrics().getOpenProcMetrics();
        this.closeProcMetrics = this.am.getAssignmentManagerMetrics().getCloseProcMetrics();
        this.setUpMeta();
    }

    protected void setUpMeta() throws Exception {
        this.rsDispatcher.setMockRsExecutor(new GoodRsExecutor());
        this.am.assign(RegionInfoBuilder.FIRST_META_REGIONINFO);
        this.am.wakeMetaLoadedEvent();
    }

    @After
    public void tearDown() throws Exception {
        this.master.stop("tearDown");
        this.executor.shutdownNow();
    }

    protected Future<byte[]> submitProcedure(Procedure<MasterProcedureEnv> proc) {
        return ProcedureSyncWait.submitProcedure(this.master.getMasterProcedureExecutor(), proc);
    }

    protected byte[] waitOnFuture(Future<byte[]> future) throws Exception {
        try {
            return future.get(3L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            LOG.info("ExecutionException", (Throwable)e);
            Exception ee = (Exception)e.getCause();
            if (ee instanceof InterruptedIOException) {
                for (Procedure p : this.master.getMasterProcedureExecutor().getProcedures()) {
                    LOG.info(p.toStringDetails());
                }
            }
            throw (Exception)e.getCause();
        }
    }

    protected void bulkSubmit(final TransitRegionStateProcedure[] procs) throws Exception {
        int i;
        final Thread[] threads = new Thread[64];
        for (i = 0; i < threads.length; ++i) {
            final int threadId = i;
            threads[i] = new Thread(){

                @Override
                public void run() {
                    TableName tableName = TableName.valueOf((String)("table-" + threadId));
                    int n = procs.length / threads.length;
                    int start = threadId * n;
                    int stop = start + n;
                    for (int j = start; j < stop; ++j) {
                        procs[j] = TestAssignmentManagerBase.this.createAndSubmitAssign(tableName, j);
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        for (i = procs.length - 1; i >= 0 && procs[i] == null; --i) {
            procs[i] = this.createAndSubmitAssign(TableName.valueOf((String)"table-sync"), i);
        }
    }

    protected TransitRegionStateProcedure createAndSubmitAssign(TableName tableName, int regionId) {
        RegionInfo hri = this.createRegionInfo(tableName, regionId);
        TransitRegionStateProcedure proc = this.createAssignProcedure(hri);
        this.master.getMasterProcedureExecutor().submitProcedure((Procedure)proc);
        return proc;
    }

    protected RegionInfo createRegionInfo(TableName tableName, long regionId) {
        return RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((long)regionId)).setEndKey(Bytes.toBytes((long)(regionId + 1L))).setSplit(false).setRegionId(0L).build();
    }

    protected TransitRegionStateProcedure createAssignProcedure(RegionInfo hri) {
        return this.am.createAssignProcedures(Arrays.asList(hri))[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransitRegionStateProcedure createUnassignProcedure(RegionInfo hri) {
        TransitRegionStateProcedure proc;
        RegionStateNode regionNode = this.am.getRegionStates().getRegionStateNode(hri);
        regionNode.lock();
        try {
            Assert.assertFalse((boolean)regionNode.isInTransition());
            proc = TransitRegionStateProcedure.unassign((MasterProcedureEnv)((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment()), (RegionInfo)hri);
            regionNode.setProcedure(proc);
        }
        finally {
            regionNode.unlock();
        }
        return proc;
    }

    protected void sendTransitionReport(ServerName serverName, HBaseProtos.RegionInfo regionInfo, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, long seqId) throws IOException {
        RegionServerStatusProtos.ReportRegionStateTransitionRequest.Builder req = RegionServerStatusProtos.ReportRegionStateTransitionRequest.newBuilder();
        req.setServer(ProtobufUtil.toServerName((ServerName)serverName));
        req.addTransition(RegionServerStatusProtos.RegionStateTransition.newBuilder().addRegionInfo(regionInfo).setTransitionCode(state).setOpenSeqNum(seqId).build());
        this.am.reportRegionStateTransition(req.build());
    }

    protected void doCrash(ServerName serverName) {
        this.master.getServerManager().moveFromOnlineToDeadServers(serverName);
        this.am.submitServerCrash(serverName, false, false);
        ServerName newSn = ServerName.valueOf((String)"localhost", (int)(10000 + this.newRsAdded), (long)1L);
        ++this.newRsAdded;
        try {
            this.master.getServerManager().regionServerReport(newSn, ServerMetricsBuilder.of((ServerName)newSn));
        }
        catch (YouAreDeadException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    protected void doRestart(ServerName serverName) {
        try {
            this.master.restartRegionServer(serverName);
        }
        catch (IOException e) {
            LOG.warn("Can not restart RS with new startcode");
        }
    }

    protected final void collectAssignmentManagerMetrics() {
        this.assignSubmittedCount = this.assignProcMetrics.getSubmittedCounter().getCount();
        this.assignFailedCount = this.assignProcMetrics.getFailedCounter().getCount();
        this.unassignSubmittedCount = this.unassignProcMetrics.getSubmittedCounter().getCount();
        this.unassignFailedCount = this.unassignProcMetrics.getFailedCounter().getCount();
        this.moveSubmittedCount = this.moveProcMetrics.getSubmittedCounter().getCount();
        this.moveFailedCount = this.moveProcMetrics.getFailedCounter().getCount();
        this.reopenSubmittedCount = this.reopenProcMetrics.getSubmittedCounter().getCount();
        this.reopenFailedCount = this.reopenProcMetrics.getFailedCounter().getCount();
        this.openSubmittedCount = this.openProcMetrics.getSubmittedCounter().getCount();
        this.openFailedCount = this.openProcMetrics.getFailedCounter().getCount();
        this.closeSubmittedCount = this.closeProcMetrics.getSubmittedCounter().getCount();
        this.closeFailedCount = this.closeProcMetrics.getFailedCounter().getCount();
    }

    protected class MockRSProcedureDispatcher
    extends RSProcedureDispatcher {
        private MockRSExecutor mockRsExec;

        public MockRSProcedureDispatcher(MasterServices master) {
            super(master);
        }

        public void setMockRsExecutor(MockRSExecutor mockRsExec) {
            this.mockRsExec = mockRsExec;
        }

        protected void remoteDispatch(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
            this.submitTask((Runnable)((Object)new MockRemoteCall(serverName, remoteProcedures)));
        }

        private class MockRemoteCall
        extends RSProcedureDispatcher.ExecuteProceduresRemoteCall {
            public MockRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
                super((RSProcedureDispatcher)MockRSProcedureDispatcher.this, serverName, operations);
            }

            protected AdminProtos.ExecuteProceduresResponse sendRequest(ServerName serverName, AdminProtos.ExecuteProceduresRequest request) throws IOException {
                return MockRSProcedureDispatcher.this.mockRsExec.sendRequest(serverName, request);
            }
        }
    }

    protected static interface MockRSExecutor {
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName var1, AdminProtos.ExecuteProceduresRequest var2) throws IOException;
    }

    protected class RandRsExecutor
    extends NoopRsExecutor {
        private final Random rand;

        protected RandRsExecutor() {
            this.rand = new Random();
        }

        @Override
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName server, AdminProtos.ExecuteProceduresRequest req) throws IOException {
            switch (this.rand.nextInt(5)) {
                case 0: {
                    throw new ServerNotRunningYetException("wait on server startup");
                }
                case 1: {
                    throw new SocketTimeoutException("simulate socket timeout");
                }
                case 2: {
                    throw new RemoteException("java.io.IOException", "unexpected exception");
                }
            }
            return super.sendRequest(server, req);
        }

        @Override
        protected AdminProtos.OpenRegionResponse.RegionOpeningState execOpenRegion(final ServerName server, AdminProtos.OpenRegionRequest.RegionOpenInfo openReq) throws IOException {
            RegionInfo hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)openReq.getRegion());
            long previousOpenSeqNum = TestAssignmentManagerBase.this.am.getRegionStates().getOrCreateRegionStateNode(hri).getOpenSeqNum();
            switch (this.rand.nextInt(3)) {
                case 0: {
                    LOG.info("Return OPENED response");
                    TestAssignmentManagerBase.this.sendTransitionReport(server, openReq.getRegion(), RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED, previousOpenSeqNum + 2L);
                    return AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED;
                }
                case 1: {
                    LOG.info("Return transition report that FAILED_OPEN/FAILED_OPENING response");
                    TestAssignmentManagerBase.this.sendTransitionReport(server, openReq.getRegion(), RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN, -1L);
                    return AdminProtos.OpenRegionResponse.RegionOpeningState.FAILED_OPENING;
                }
            }
            LOG.info("Return null as response; means proc stuck so we send in a crash report after a few seconds...");
            TestAssignmentManagerBase.this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    LOG.info("Delayed CRASHING of " + server);
                    TestAssignmentManagerBase.this.doCrash(server);
                }
            }, 5L, TimeUnit.SECONDS);
            return null;
        }

        @Override
        protected AdminProtos.CloseRegionResponse execCloseRegion(ServerName server, byte[] regionName) throws IOException {
            AdminProtos.CloseRegionResponse.Builder resp = AdminProtos.CloseRegionResponse.newBuilder();
            boolean closed = this.rand.nextBoolean();
            if (closed) {
                RegionInfo hri = TestAssignmentManagerBase.this.am.getRegionInfo(regionName);
                TestAssignmentManagerBase.this.sendTransitionReport(server, ProtobufUtil.toRegionInfo((RegionInfo)hri), RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED, -1L);
            }
            resp.setClosed(closed);
            return resp.build();
        }
    }

    protected class HangOnCloseThenRSCrashExecutor
    extends GoodRsExecutor {
        public static final int TYPES_OF_FAILURE = 6;
        private int invocations;

        protected HangOnCloseThenRSCrashExecutor() {
        }

        @Override
        protected AdminProtos.CloseRegionResponse execCloseRegion(final ServerName server, byte[] regionName) throws IOException {
            switch (this.invocations++) {
                case 0: {
                    throw new NotServingRegionException("Fake");
                }
                case 1: {
                    TestAssignmentManagerBase.this.executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("Sending in CRASH of " + server);
                            TestAssignmentManagerBase.this.doCrash(server);
                        }
                    }, 1L, TimeUnit.SECONDS);
                    throw new RegionServerAbortedException("Fake!");
                }
                case 2: {
                    TestAssignmentManagerBase.this.executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("Sending in CRASH of " + server);
                            TestAssignmentManagerBase.this.doCrash(server);
                        }
                    }, 1L, TimeUnit.SECONDS);
                    throw new RegionServerStoppedException("Fake!");
                }
                case 3: {
                    throw new ServerNotRunningYetException("Fake!");
                }
                case 4: {
                    LOG.info("Returned null from serverName={}; means STUCK...TODO timeout", (Object)server);
                    TestAssignmentManagerBase.this.executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("Sending in CRASH of " + server);
                            TestAssignmentManagerBase.this.doCrash(server);
                        }
                    }, 1L, TimeUnit.SECONDS);
                    return null;
                }
            }
            return super.execCloseRegion(server, regionName);
        }
    }

    protected class HangThenRSRestartExecutor
    extends GoodRsExecutor {
        private int invocations;

        protected HangThenRSRestartExecutor() {
        }

        @Override
        protected AdminProtos.OpenRegionResponse.RegionOpeningState execOpenRegion(final ServerName server, AdminProtos.OpenRegionRequest.RegionOpenInfo openReq) throws IOException {
            if (this.invocations++ > 0) {
                return super.execOpenRegion(server, openReq);
            }
            LOG.info("Return null response from serverName=" + server + "; means STUCK...TODO timeout");
            TestAssignmentManagerBase.this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    LOG.info("Restarting RS of " + server);
                    TestAssignmentManagerBase.this.doRestart(server);
                }
            }, 1L, TimeUnit.SECONDS);
            return null;
        }
    }

    protected class HangThenRSCrashExecutor
    extends GoodRsExecutor {
        private int invocations;

        protected HangThenRSCrashExecutor() {
        }

        @Override
        protected AdminProtos.OpenRegionResponse.RegionOpeningState execOpenRegion(final ServerName server, AdminProtos.OpenRegionRequest.RegionOpenInfo openReq) throws IOException {
            if (this.invocations++ > 0) {
                return super.execOpenRegion(server, openReq);
            }
            LOG.info("Return null response from serverName=" + server + "; means STUCK...TODO timeout");
            TestAssignmentManagerBase.this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    LOG.info("Sending in CRASH of " + server);
                    TestAssignmentManagerBase.this.doCrash(server);
                }
            }, 1L, TimeUnit.SECONDS);
            return null;
        }
    }

    protected class TimeoutThenCallQueueTooBigRsExecutor
    extends GoodRsExecutor {
        private final int queueFullTimes;
        private int retries;
        private ServerName lastServer;

        public TimeoutThenCallQueueTooBigRsExecutor(int queueFullTimes) {
            this.queueFullTimes = queueFullTimes;
        }

        @Override
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName server, AdminProtos.ExecuteProceduresRequest req) throws IOException {
            ++this.retries;
            if (this.retries == 1) {
                this.lastServer = server;
                throw new CallTimeoutException("simulate call timeout");
            }
            Assert.assertEquals((Object)this.lastServer, (Object)server);
            if (this.retries < this.queueFullTimes) {
                throw new CallQueueTooBigException("simulate queue full");
            }
            return super.sendRequest(server, req);
        }
    }

    protected class CallQueueTooBigOnceRsExecutor
    extends GoodRsExecutor {
        private boolean invoked;
        private ServerName lastServer;

        protected CallQueueTooBigOnceRsExecutor() {
            this.invoked = false;
        }

        @Override
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName server, AdminProtos.ExecuteProceduresRequest req) throws IOException {
            if (!this.invoked) {
                this.lastServer = server;
                this.invoked = true;
                throw new CallQueueTooBigException("simulate queue full");
            }
            if (this.lastServer.equals((Object)server)) {
                LOG.warn("We still select the same server, which is not good.");
            }
            return super.sendRequest(server, req);
        }
    }

    protected class SocketTimeoutRsExecutor
    extends GoodRsExecutor {
        private final int timeoutTimes;
        private ServerName lastServer;
        private int retries;

        public SocketTimeoutRsExecutor(int timeoutTimes) {
            this.timeoutTimes = timeoutTimes;
        }

        @Override
        public AdminProtos.ExecuteProceduresResponse sendRequest(final ServerName server, AdminProtos.ExecuteProceduresRequest req) throws IOException {
            ++this.retries;
            if (this.retries == 1) {
                this.lastServer = server;
            }
            if (this.retries <= this.timeoutTimes) {
                LOG.debug("Socket timeout for server=" + server + " retries=" + this.retries);
                Assert.assertEquals((Object)this.lastServer, (Object)server);
                if (this.retries == this.timeoutTimes) {
                    LOG.info("Mark server=" + server + " as dead. retries=" + this.retries);
                    TestAssignmentManagerBase.this.master.getServerManager().moveFromOnlineToDeadServers(server);
                    TestAssignmentManagerBase.this.executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            LOG.info("Sending in CRASH of " + server);
                            TestAssignmentManagerBase.this.doCrash(server);
                        }
                    }, 1L, TimeUnit.SECONDS);
                }
                throw new SocketTimeoutException("simulate socket timeout");
            }
            Assert.assertNotEquals((Object)this.lastServer, (Object)server);
            return super.sendRequest(server, req);
        }
    }

    protected static class FaultyRsExecutor
    implements MockRSExecutor {
        private final IOException exception;

        public FaultyRsExecutor(IOException exception) {
            this.exception = exception;
        }

        @Override
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName server, AdminProtos.ExecuteProceduresRequest req) throws IOException {
            throw this.exception;
        }
    }

    protected static class ServerNotYetRunningRsExecutor
    implements MockRSExecutor {
        protected ServerNotYetRunningRsExecutor() {
        }

        @Override
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName server, AdminProtos.ExecuteProceduresRequest req) throws IOException {
            throw new ServerNotRunningYetException("wait on server startup");
        }
    }

    protected class GoodRsExecutor
    extends NoopRsExecutor {
        protected GoodRsExecutor() {
        }

        @Override
        protected AdminProtos.OpenRegionResponse.RegionOpeningState execOpenRegion(ServerName server, AdminProtos.OpenRegionRequest.RegionOpenInfo openReq) throws IOException {
            RegionInfo hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)openReq.getRegion());
            long previousOpenSeqNum = TestAssignmentManagerBase.this.am.getRegionStates().getOrCreateRegionStateNode(hri).getOpenSeqNum();
            TestAssignmentManagerBase.this.sendTransitionReport(server, openReq.getRegion(), RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED, previousOpenSeqNum + 2L);
            ConcurrentSkipListSet<byte[]> regions = (ConcurrentSkipListSet<byte[]>)TestAssignmentManagerBase.this.regionsToRegionServers.get(server);
            if (regions == null) {
                regions = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
                TestAssignmentManagerBase.this.regionsToRegionServers.put(server, regions);
            }
            if (regions.contains(hri.getRegionName())) {
                throw new UnsupportedOperationException(hri.getRegionNameAsString());
            }
            regions.add(hri.getRegionName());
            return AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED;
        }

        @Override
        protected AdminProtos.CloseRegionResponse execCloseRegion(ServerName server, byte[] regionName) throws IOException {
            RegionInfo hri = TestAssignmentManagerBase.this.am.getRegionInfo(regionName);
            TestAssignmentManagerBase.this.sendTransitionReport(server, ProtobufUtil.toRegionInfo((RegionInfo)hri), RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED, -1L);
            return AdminProtos.CloseRegionResponse.newBuilder().setClosed(true).build();
        }
    }

    protected class NoopRsExecutor
    implements MockRSExecutor {
        protected NoopRsExecutor() {
        }

        @Override
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName server, AdminProtos.ExecuteProceduresRequest request) throws IOException {
            if (request.getOpenRegionCount() > 0) {
                for (AdminProtos.OpenRegionRequest req : request.getOpenRegionList()) {
                    for (AdminProtos.OpenRegionRequest.RegionOpenInfo openReq : req.getOpenInfoList()) {
                        this.execOpenRegion(server, openReq);
                    }
                }
            }
            if (request.getCloseRegionCount() > 0) {
                for (AdminProtos.OpenRegionRequest req : request.getCloseRegionList()) {
                    this.execCloseRegion(server, req.getRegion().getValue().toByteArray());
                }
            }
            return AdminProtos.ExecuteProceduresResponse.newBuilder().build();
        }

        protected AdminProtos.OpenRegionResponse.RegionOpeningState execOpenRegion(ServerName server, AdminProtos.OpenRegionRequest.RegionOpenInfo regionInfo) throws IOException {
            return null;
        }

        protected AdminProtos.CloseRegionResponse execCloseRegion(ServerName server, byte[] regionName) throws IOException {
            return null;
        }
    }
}

