/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import ch.cern.hbase.thirdparty.com.google.protobuf.RpcController;
import ch.cern.hbase.thirdparty.com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestWakeUpUnexpectedProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWakeUpUnexpectedProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWakeUpUnexpectedProcedure.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"Assign");
    private static final List<ServerName> EXCLUDE_SERVERS = new CopyOnWriteArrayList<ServerName>();
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static volatile ServerName SERVER_TO_KILL;
    private static volatile CountDownLatch ARRIVE_EXEC_PROC;
    private static volatile CountDownLatch RESUME_EXEC_PROC;
    private static volatile CountDownLatch RESUME_IS_SERVER_ONLINE;
    private static volatile CountDownLatch ARRIVE_REPORT;
    private static volatile CountDownLatch RESUME_REPORT;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(StartMiniClusterOption.builder().numMasters(1).masterClass(HMasterForTest.class).numRegionServers(3).rsClass(RSForTest.class).build());
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        RegionStateNode rsn = am.getRegionStates().getRegionStateNode(region);
        ServerName sn = rsn.getRegionLocation();
        RESUME_EXEC_PROC = new CountDownLatch(1);
        ARRIVE_EXEC_PROC = new CountDownLatch(1);
        RESUME_IS_SERVER_ONLINE = new CountDownLatch(1);
        am.moveAsync(new RegionPlan(region, sn, sn));
        ARRIVE_EXEC_PROC.await();
        RESUME_REPORT = new CountDownLatch(1);
        ARRIVE_REPORT = new CountDownLatch(1);
        ServerName serverToKill = SERVER_TO_KILL;
        UTIL.getMiniHBaseCluster().stopRegionServer(serverToKill);
        RESUME_EXEC_PROC.countDown();
        ARRIVE_REPORT.await();
        RESUME_IS_SERVER_ONLINE.countDown();
        for (int i = 0; i < 15 && rsn.getState() != RegionState.State.OPEN; ++i) {
            Thread.sleep(1000L);
        }
        RESUME_REPORT.countDown();
        Thread.sleep(10000L);
        int count = 0;
        for (JVMClusterUtil.RegionServerThread t : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            if (t.getRegionServer().getRegions(NAME).isEmpty()) continue;
            LOG.info("{} is on {}", (Object)region, (Object)t.getRegionServer().getServerName());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException, KeeperException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master) {
            return new AMForTest(master);
        }

        protected ServerManager createServerManager(MasterServices master) throws IOException {
            this.setupClusterConnection();
            return new SMForTest(master);
        }
    }

    private static final class SMForTest
    extends ServerManager {
        public SMForTest(MasterServices master) {
            super(master);
        }

        public boolean isServerOnline(ServerName serverName) {
            ServerName toKill = SERVER_TO_KILL;
            if (toKill != null && toKill.equals((Object)serverName)) {
                for (StackTraceElement ele : new Exception().getStackTrace()) {
                    if (!"scheduleForRetry".equals(ele.getMethodName())) continue;
                    if (RESUME_IS_SERVER_ONLINE == null) break;
                    try {
                        RESUME_IS_SERVER_ONLINE.await();
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return super.isServerOnline(serverName);
        }

        public List<ServerName> createDestinationServersList() {
            return super.createDestinationServersList(EXCLUDE_SERVERS);
        }
    }

    private static final class AMForTest
    extends AssignmentManager {
        public AMForTest(MasterServices master) {
            super(master);
        }

        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
            RegionServerStatusProtos.RegionStateTransition rst = req.getTransition(0);
            if (rst.getTransitionCode() == RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED && ProtobufUtil.toTableName((HBaseProtos.TableName)rst.getRegionInfo(0).getTableName()).equals((Object)NAME)) {
                CountDownLatch arrive = ARRIVE_REPORT;
                if (ARRIVE_REPORT != null) {
                    ARRIVE_REPORT = null;
                    arrive.countDown();
                    EXCLUDE_SERVERS.add(ProtobufUtil.toServerName((HBaseProtos.ServerName)req.getServer()));
                    try {
                        RESUME_REPORT.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException();
                    }
                }
            }
            return super.reportRegionStateTransition(req);
        }
    }

    public static final class RSForTest
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public RSForTest(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new RSRpcServicesForTest(this);
        }
    }

    private static final class RSRpcServicesForTest
    extends RSRpcServices {
        public RSRpcServicesForTest(HRegionServer rs) throws IOException {
            super(rs);
        }

        public AdminProtos.ExecuteProceduresResponse executeProcedures(RpcController controller, AdminProtos.ExecuteProceduresRequest request) throws ServiceException {
            if (request.getOpenRegionCount() > 0 && ARRIVE_EXEC_PROC != null) {
                SERVER_TO_KILL = this.regionServer.getServerName();
                ARRIVE_EXEC_PROC.countDown();
                ARRIVE_EXEC_PROC = null;
                try {
                    RESUME_EXEC_PROC.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                throw new ServiceException((Throwable)new ConnectException("Inject error"));
            }
            return super.executeProcedures(controller, request);
        }
    }
}

