/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestBaseLoadBalancer
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBaseLoadBalancer.class);
    private static LoadBalancer loadBalancer;
    private static final Logger LOG;
    private static final ServerName master;
    private static RackManager rackManager;
    private static final int NUM_SERVERS = 15;
    private static ServerName[] servers;
    int[][] regionsAndServersMocks = new int[][]{{0, 0}, {0, 1}, {1, 1}, {2, 1}, {10, 1}, {1, 2}, {2, 2}, {3, 2}, {1, 3}, {2, 3}, {3, 3}, {25, 3}, {2, 10}, {2, 100}, {12, 10}, {12, 100}};
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        loadBalancer = new MockBalancer();
        loadBalancer.setConf(conf);
        MasterServices st = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)st.getServerName()).thenReturn((Object)master);
        loadBalancer.setMasterServices(st);
        rackManager = (RackManager)Mockito.mock(RackManager.class);
        for (int i = 0; i < 15; ++i) {
            TestBaseLoadBalancer.servers[i] = ServerName.valueOf((String)("foo" + i + ":1234"), (long)-1L);
            if (i < 5) {
                Mockito.when((Object)rackManager.getRack(servers[i])).thenReturn((Object)"rack1");
            }
            if (i >= 5 && i < 10) {
                Mockito.when((Object)rackManager.getRack(servers[i])).thenReturn((Object)"rack2");
            }
            if (i < 10) continue;
            Mockito.when((Object)rackManager.getRack(servers[i])).thenReturn((Object)"rack3");
        }
    }

    private void assertImmediateAssignment(List<RegionInfo> regions, List<ServerName> servers, Map<RegionInfo, ServerName> assignments) {
        for (RegionInfo region : regions) {
            Assert.assertTrue((boolean)assignments.containsKey(region));
        }
    }

    @Test
    public void testBulkAssignment() throws Exception {
        List<ServerName> tmp = this.getListOfServerNames(this.randomServers(5, 0));
        List<RegionInfo> hris = this.randomRegions(20);
        hris.add(RegionInfoBuilder.FIRST_META_REGIONINFO);
        tmp.add(master);
        Map plans = loadBalancer.roundRobinAssignment(hris, tmp);
        if (LoadBalancer.isTablesOnMaster((Configuration)loadBalancer.getConf())) {
            Assert.assertTrue((boolean)((List)plans.get(master)).contains(RegionInfoBuilder.FIRST_META_REGIONINFO));
            Assert.assertEquals((long)1L, (long)((List)plans.get(master)).size());
        }
        int totalRegion = 0;
        for (List regions : plans.values()) {
            totalRegion += regions.size();
        }
        Assert.assertEquals((long)hris.size(), (long)totalRegion);
        for (Object mock : (Object)this.regionsAndServersMocks) {
            LOG.debug("testBulkAssignment with " + (int)mock[0] + " regions and " + (int)mock[1] + " servers");
            List<RegionInfo> regions = this.randomRegions((int)mock[0]);
            List<ServerAndLoad> servers = this.randomServers((int)mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.roundRobinAssignment(regions, list);
            float average = (float)regions.size() / (float)servers.size();
            int min = (int)Math.floor(average);
            int max = (int)Math.ceil(average);
            if (assignments != null && !assignments.isEmpty()) {
                for (List regionList : assignments.values()) {
                    Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
                }
            }
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    @Test
    public void testRetainAssignment() throws Exception {
        List<ServerAndLoad> servers = this.randomServers(10, 10);
        List<RegionInfo> regions = this.randomRegions(100);
        TreeMap<RegionInfo, ServerName> existing = new TreeMap<RegionInfo, ServerName>(RegionInfo.COMPARATOR);
        for (int i = 0; i < regions.size(); ++i) {
            ServerName sn = servers.get(i % servers.size()).getServerName();
            ServerName snWithOldStartCode = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)(sn.getStartcode() - 10L));
            existing.put(regions.get(i), snWithOldStartCode);
        }
        List<ServerName> listOfServerNames = this.getListOfServerNames(servers);
        Map assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers2 = new ArrayList<ServerAndLoad>(servers);
        servers2.add(this.randomServer(10));
        servers2.add(this.randomServer(10));
        listOfServerNames = this.getListOfServerNames(servers2);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers3 = new ArrayList<ServerAndLoad>(servers);
        servers3.remove(0);
        servers3.remove(0);
        listOfServerNames = this.getListOfServerNames(servers3);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
    }

    @Test
    public void testRandomAssignment() throws Exception {
        for (int i = 1; i != 5; ++i) {
            LOG.info("run testRandomAssignment() with idle servers:" + i);
            this.testRandomAssignment(i);
        }
    }

    private void testRandomAssignment(int numberOfIdleServers) throws Exception {
        assert (numberOfIdleServers > 0);
        ArrayList<ServerName> idleServers = new ArrayList<ServerName>(numberOfIdleServers);
        for (int i = 0; i != numberOfIdleServers; ++i) {
            idleServers.add(ServerName.valueOf((String)("server-" + i), (int)1000, (long)1L));
        }
        ArrayList<ServerName> allServers = new ArrayList<ServerName>(idleServers.size() + 1);
        allServers.add(ServerName.valueOf((String)("server-" + numberOfIdleServers), (int)1000, (long)1L));
        allServers.addAll(idleServers);
        MockBalancer balancer = new MockBalancer(){

            public boolean shouldBeOnMaster(RegionInfo region) {
                return false;
            }
        };
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        balancer.setConf(conf);
        ServerManager sm = (ServerManager)Mockito.mock(ServerManager.class);
        Mockito.when((Object)sm.getOnlineServersListWithPredicator(allServers, BaseLoadBalancer.IDLE_SERVER_PREDICATOR)).thenReturn(idleServers);
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getServerManager()).thenReturn((Object)sm);
        balancer.setMasterServices(services);
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey("key1".getBytes()).setEndKey("key2".getBytes()).setSplit(false).setRegionId(100L).build();
        Assert.assertNull((Object)balancer.randomAssignment(hri1, Collections.EMPTY_LIST));
        Assert.assertNull((Object)balancer.randomAssignment(hri1, null));
        for (int i = 0; i != 3; ++i) {
            ServerName sn = balancer.randomAssignment(hri1, allServers);
            Assert.assertTrue((String)("actual:" + sn + ", except:" + idleServers), (boolean)idleServers.contains(sn));
        }
    }

    @Test
    public void testRegionAvailability() throws Exception {
        ArrayList<RegionInfo> list0 = new ArrayList<RegionInfo>();
        ArrayList<RegionInfo> list1 = new ArrayList<RegionInfo>();
        ArrayList<RegionInfo> list2 = new ArrayList<RegionInfo>();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey("key1".getBytes()).setEndKey("key2".getBytes()).setSplit(false).setRegionId(100L).build();
        RegionInfo hri2 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri1, (int)1);
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey("key2".getBytes()).setEndKey("key3".getBytes()).setSplit(false).setRegionId(101L).build();
        list0.add(hri1);
        list1.add(hri2);
        list2.add(hri3);
        LinkedHashMap clusterState = new LinkedHashMap();
        clusterState.put(servers[0], list0);
        clusterState.put(servers[1], list1);
        clusterState.put(servers[2], list2);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri1, servers[1]));
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri1, servers[2]) ? 1 : 0) != 0);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri2, servers[2]) ? 1 : 0) != 0);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri3, servers[1]) ? 1 : 0) != 0);
        list1.add(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri3, (int)1));
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri3, servers[1]));
        clusterState.clear();
        clusterState.put(servers[0], list0);
        clusterState.put(servers[5], list1);
        clusterState.put(servers[6], list2);
        clusterState.put(servers[10], new ArrayList());
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri1, servers[0]));
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri1, servers[6]) ? 1 : 0) != 0);
    }

    @Test
    public void testRegionAvailabilityWithRegionMoves() throws Exception {
        ArrayList<RegionInfo> list0 = new ArrayList<RegionInfo>();
        ArrayList<RegionInfo> list1 = new ArrayList<RegionInfo>();
        ArrayList<RegionInfo> list2 = new ArrayList<RegionInfo>();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey("key1".getBytes()).setEndKey("key2".getBytes()).setSplit(false).setRegionId(100L).build();
        RegionInfo hri2 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri1, (int)1);
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey("key2".getBytes()).setEndKey("key3".getBytes()).setSplit(false).setRegionId(101L).build();
        list0.add(hri1);
        list1.add(hri2);
        list2.add(hri3);
        LinkedHashMap clusterState = new LinkedHashMap();
        clusterState.put(servers[0], list0);
        clusterState.put(servers[1], list1);
        clusterState.put(servers[2], list2);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri1, servers[2]) ? 1 : 0) != 0);
        cluster.doAction((BaseLoadBalancer.Cluster.Action)new BaseLoadBalancer.Cluster.MoveRegionAction(0, 0, 2));
        Assert.assertEquals((long)2L, (long)cluster.numMaxRegionsPerTable[0]);
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri1, servers[2]));
        clusterState.clear();
        ArrayList<RegionInfo> list3 = new ArrayList<RegionInfo>();
        RegionInfo hri4 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri3, (int)1);
        list3.add(hri4);
        clusterState.put(servers[0], list0);
        clusterState.put(servers[5], list1);
        clusterState.put(servers[6], list2);
        clusterState.put(servers[12], list3);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri4, servers[0]) ? 1 : 0) != 0);
        cluster.doAction((BaseLoadBalancer.Cluster.Action)new BaseLoadBalancer.Cluster.MoveRegionAction(2, 2, 0));
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri3, servers[0]));
    }

    private List<ServerName> getListOfServerNames(List<ServerAndLoad> sals) {
        return sals.stream().map(ServerAndLoad::getServerName).collect(Collectors.toList());
    }

    private void assertRetainedAssignment(Map<RegionInfo, ServerName> existing, List<ServerName> servers, Map<ServerName, List<RegionInfo>> assignment) {
        TreeSet<ServerName> onlineServerSet = new TreeSet<ServerName>(servers);
        TreeSet<RegionInfo> assignedRegions = new TreeSet<RegionInfo>(RegionInfo.COMPARATOR);
        for (Map.Entry<ServerName, List<RegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (RegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<String> onlineHostNames = new TreeSet<String>();
        for (ServerName serverName : servers) {
            onlineHostNames.add(serverName.getHostname());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            ServerName assignedTo = (ServerName)entry.getKey();
            for (RegionInfo r : (List)entry.getValue()) {
                ServerName address = existing.get(r);
                if (address == null || !onlineHostNames.contains(address.getHostname())) continue;
                Assert.assertEquals((Object)address.getHostname(), (Object)assignedTo.getHostname());
            }
        }
    }

    @Test
    public void testClusterServersWithSameHostPort() {
        ServerName sn2;
        List<ServerName> servers = this.getListOfServerNames(this.randomServers(10, 10));
        List<RegionInfo> regions = this.randomRegions(101);
        TreeMap<ServerName, List<RegionInfo>> clusterState = new TreeMap<ServerName, List<RegionInfo>>();
        this.assignRegions(regions, servers, clusterState);
        ArrayList<ServerName> oldServers = new ArrayList<ServerName>(servers.size());
        for (ServerName sn2 : servers) {
            oldServers.add(ServerName.valueOf((String)sn2.getHostname(), (int)sn2.getPort(), (long)(sn2.getStartcode() - 10L)));
        }
        regions = this.randomRegions(9);
        this.assignRegions(regions, oldServers, clusterState);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        Assert.assertEquals((long)110L, (long)cluster.numRegions);
        Assert.assertEquals((long)10L, (long)cluster.numServers);
        sn2 = (ServerName)oldServers.get(0);
        int r0 = ArrayUtils.indexOf((Object[])cluster.regions, ((List)clusterState.get(sn2)).get(0));
        int f0 = (Integer)cluster.serversToIndex.get(sn2.getHostAndPort());
        int t0 = (Integer)cluster.serversToIndex.get(servers.get(1).getHostAndPort());
        cluster.doAction((BaseLoadBalancer.Cluster.Action)new BaseLoadBalancer.Cluster.MoveRegionAction(r0, f0, t0));
    }

    private void assignRegions(List<RegionInfo> regions, List<ServerName> servers, Map<ServerName, List<RegionInfo>> clusterState) {
        for (int i = 0; i < regions.size(); ++i) {
            ServerName sn = servers.get(i % servers.size());
            List<RegionInfo> regionsOfServer = clusterState.get(sn);
            if (regionsOfServer == null) {
                regionsOfServer = new ArrayList<RegionInfo>(10);
                clusterState.put(sn, regionsOfServer);
            }
            regionsOfServer.add(regions.get(i));
        }
    }

    @Test
    public void testClusterRegionLocations() {
        List<ServerName> servers = this.getListOfServerNames(this.randomServers(10, 10));
        List<RegionInfo> regions = this.randomRegions(101);
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        this.assignRegions(regions, servers, clusterState);
        RegionLocationFinder locationFinder = (RegionLocationFinder)Mockito.mock(RegionLocationFinder.class);
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(0))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(0)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(1))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(0), servers.get(1)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(42))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(4), servers.get(9), servers.get(5)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(43))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{ServerName.valueOf((String)"foo", (int)0, (long)0L)}));
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, locationFinder, null);
        int r0 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(0));
        int r1 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(1));
        int r10 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(10));
        int r42 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(42));
        int r43 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(43));
        int s0 = (Integer)cluster.serversToIndex.get(servers.get(0).getHostAndPort());
        int s1 = (Integer)cluster.serversToIndex.get(servers.get(1).getHostAndPort());
        int s4 = (Integer)cluster.serversToIndex.get(servers.get(4).getHostAndPort());
        int s5 = (Integer)cluster.serversToIndex.get(servers.get(5).getHostAndPort());
        int s9 = (Integer)cluster.serversToIndex.get(servers.get(9).getHostAndPort());
        Assert.assertEquals((long)1L, (long)cluster.regionLocations[r0].length);
        Assert.assertEquals((long)s0, (long)cluster.regionLocations[r0][0]);
        Assert.assertEquals((long)2L, (long)cluster.regionLocations[r1].length);
        Assert.assertEquals((long)s0, (long)cluster.regionLocations[r1][0]);
        Assert.assertEquals((long)s1, (long)cluster.regionLocations[r1][1]);
        Assert.assertEquals((long)0L, (long)cluster.regionLocations[r10].length);
        Assert.assertEquals((long)3L, (long)cluster.regionLocations[r42].length);
        Assert.assertEquals((long)s4, (long)cluster.regionLocations[r42][0]);
        Assert.assertEquals((long)s9, (long)cluster.regionLocations[r42][1]);
        Assert.assertEquals((long)s5, (long)cluster.regionLocations[r42][2]);
        Assert.assertEquals((long)1L, (long)cluster.regionLocations[r43].length);
        Assert.assertEquals((long)-1L, (long)cluster.regionLocations[r43][0]);
    }

    static {
        LOG = LoggerFactory.getLogger(TestBaseLoadBalancer.class);
        master = ServerName.valueOf((String)"fake-master", (int)0, (long)1L);
        servers = new ServerName[15];
    }

    public static class MockBalancer
    extends BaseLoadBalancer {
        public List<RegionPlan> balanceCluster(Map<ServerName, List<RegionInfo>> clusterState) {
            return null;
        }

        public List<RegionPlan> balanceCluster(TableName tableName, Map<ServerName, List<RegionInfo>> clusterState) throws HBaseIOException {
            return null;
        }
    }
}

