/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDefaultLoadBalancer
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultLoadBalancer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestDefaultLoadBalancer.class);
    private static LoadBalancer loadBalancer;
    int[][] clusterStateMocks = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {1, 1}, {0, 1}, {10, 1}, {14, 1432}, {47, 53}, {0, 1, 2}, {1, 2, 3}, {0, 2, 2}, {0, 3, 0}, {0, 4, 0}, {20, 20, 0}, {0, 1, 2, 3}, {4, 0, 0, 0}, {5, 0, 0, 0}, {6, 6, 0, 0}, {6, 2, 0, 0}, {6, 1, 0, 0}, {6, 0, 0, 0}, {4, 4, 4, 7}, {4, 4, 4, 8}, {0, 0, 0, 7}, {1, 1, 1, 1, 4}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {6, 6, 5, 6, 6, 6, 6, 6, 6, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 10}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 123}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 155}, {0, 0, 144, 1, 1, 1, 1, 1123, 133, 138, 12, 1444}, {0, 0, 144, 1, 0, 4, 1, 1123, 133, 138, 12, 1444}, {1538, 1392, 1561, 1557, 1535, 1553, 1385, 1542, 1619}};
    int[] mockUniformCluster = new int[]{5, 5, 5, 5, 5, 0};
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        conf.set("hbase.regions.slop", "0");
        loadBalancer = new SimpleLoadBalancer();
        loadBalancer.setConf(conf);
    }

    @Test
    public void testBalanceClusterOverall() throws Exception {
        TreeMap<TableName, TreeMap<ServerName, List<RegionInfo>>> clusterLoad = new TreeMap<TableName, TreeMap<ServerName, List<RegionInfo>>>();
        for (int[] mockCluster : this.clusterStateMocks) {
            TreeMap<ServerName, List<RegionInfo>> clusterServers = this.mockClusterServers(mockCluster, 50);
            List<ServerAndLoad> clusterList = this.convertToList(clusterServers);
            clusterLoad.put(TableName.valueOf((String)this.name.getMethodName()), clusterServers);
            HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> result = this.mockClusterServersWithTables(clusterServers);
            loadBalancer.setClusterLoad(clusterLoad);
            ArrayList<RegionPlan> clusterplans = new ArrayList<RegionPlan>();
            ArrayList regionAmountList = new ArrayList();
            for (TreeMap<ServerName, List<RegionInfo>> servers : result.values()) {
                List<ServerAndLoad> list = this.convertToList(servers);
                LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
                List partialplans = loadBalancer.balanceCluster(servers);
                if (partialplans != null) {
                    clusterplans.addAll(partialplans);
                }
                List<ServerAndLoad> balancedClusterPerTable = this.reconcile(list, partialplans, servers);
                LOG.info("Mock Balance : " + this.printMock(balancedClusterPerTable));
                this.assertClusterAsBalanced(balancedClusterPerTable);
                for (Map.Entry<ServerName, List<RegionInfo>> entry : servers.entrySet()) {
                    this.returnRegions(entry.getValue());
                    this.returnServer(entry.getKey());
                }
            }
            List<ServerAndLoad> balancedCluster = this.reconcile(clusterList, clusterplans, clusterServers);
            Assert.assertTrue((boolean)this.assertClusterOverallAsBalanced(balancedCluster, result.keySet().size()));
        }
    }

    @Test
    public void testImpactOfBalanceClusterOverall() throws Exception {
        this.testImpactOfBalanceClusterOverall(false);
    }

    @Test
    public void testImpactOfBalanceClusterOverallWithClusterLoadPerTable() throws Exception {
        this.testImpactOfBalanceClusterOverall(true);
    }

    private void testImpactOfBalanceClusterOverall(boolean useClusterLoadPerTable) throws Exception {
        TreeMap<TableName, TreeMap<ServerName, List<RegionInfo>>> clusterLoad = new TreeMap<TableName, TreeMap<ServerName, List<RegionInfo>>>();
        TreeMap<ServerName, List<RegionInfo>> clusterServers = this.mockUniformClusterServers(this.mockUniformCluster);
        List<ServerAndLoad> clusterList = this.convertToList(clusterServers);
        clusterLoad.put(TableName.valueOf((String)this.name.getMethodName()), clusterServers);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> clusterLoadPerTable = this.mockClusterServersWithTables(clusterServers);
        if (useClusterLoadPerTable) {
            loadBalancer.setClusterLoad(clusterLoadPerTable);
        } else {
            loadBalancer.setClusterLoad(clusterLoad);
        }
        ArrayList<RegionPlan> clusterplans1 = new ArrayList<RegionPlan>();
        ArrayList regionAmountList = new ArrayList();
        for (TreeMap<ServerName, List<RegionInfo>> servers : clusterLoadPerTable.values()) {
            List<ServerAndLoad> list = this.convertToList(servers);
            LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
            List partialplans = loadBalancer.balanceCluster(servers);
            if (partialplans != null) {
                clusterplans1.addAll(partialplans);
            }
            List<ServerAndLoad> balancedClusterPerTable = this.reconcile(list, partialplans, servers);
            LOG.info("Mock Balance : " + this.printMock(balancedClusterPerTable));
            this.assertClusterAsBalanced(balancedClusterPerTable);
            for (Map.Entry<ServerName, List<RegionInfo>> entry : servers.entrySet()) {
                this.returnRegions(entry.getValue());
                this.returnServer(entry.getKey());
            }
        }
        List<ServerAndLoad> balancedCluster1 = this.reconcile(clusterList, clusterplans1, clusterServers);
        Assert.assertTrue((boolean)this.assertClusterOverallAsBalanced(balancedCluster1, clusterLoadPerTable.keySet().size()));
    }

    @Test
    public void testBalanceClusterOverallStrictly() throws Exception {
        int[] regionNumOfTable1PerServer = new int[]{3, 3, 4, 4, 4, 4, 5, 5, 5};
        int[] regionNumOfTable2PerServer = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 1};
        TreeMap<ServerName, List<RegionInfo>> serverRegionInfo = new TreeMap<ServerName, List<RegionInfo>>();
        ArrayList<ServerAndLoad> serverAndLoads = new ArrayList<ServerAndLoad>();
        for (int i = 0; i < regionNumOfTable1PerServer.length; ++i) {
            ServerName serverName = ServerName.valueOf((String)("server" + i), (int)1000, (long)-1L);
            List<RegionInfo> regions1 = this.createRegions(regionNumOfTable1PerServer[i], TableName.valueOf((String)"table1"));
            List<RegionInfo> regions2 = this.createRegions(regionNumOfTable2PerServer[i], TableName.valueOf((String)"table2"));
            regions1.addAll(regions2);
            serverRegionInfo.put(serverName, regions1);
            ServerAndLoad serverAndLoad = new ServerAndLoad(serverName, regionNumOfTable1PerServer[i] + regionNumOfTable2PerServer[i]);
            serverAndLoads.add(serverAndLoad);
        }
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> clusterLoadPerTable = this.mockClusterServersWithTables(serverRegionInfo);
        loadBalancer.setClusterLoad(clusterLoadPerTable);
        List partialplans = loadBalancer.balanceCluster((Map)clusterLoadPerTable.get(TableName.valueOf((String)"table1")));
        List<ServerAndLoad> balancedServerLoads = this.reconcile(serverAndLoads, partialplans, serverRegionInfo);
        for (ServerAndLoad serverAndLoad : balancedServerLoads) {
            Assert.assertEquals((long)6L, (long)serverAndLoad.getLoad());
        }
    }
}

