/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import ch.cern.hbase.thirdparty.com.google.common.collect.Iterables;
import java.util.HashMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.TableQuotaSnapshotStore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestQuotaObserverChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaObserverChore.class);
    private Connection conn;
    private QuotaObserverChore chore;

    @Before
    public void setup() throws Exception {
        this.conn = (Connection)Mockito.mock(Connection.class);
        this.chore = (QuotaObserverChore)Mockito.mock(QuotaObserverChore.class);
    }

    @Test
    public void testNumRegionsForTable() {
        int i;
        TableName tn1 = TableName.valueOf((String)"t1");
        TableName tn2 = TableName.valueOf((String)"t2");
        TableName tn3 = TableName.valueOf((String)"t3");
        int numTable1Regions = 10;
        int numTable2Regions = 15;
        int numTable3Regions = 8;
        HashMap<RegionInfo, Long> regionReports = new HashMap<RegionInfo, Long>();
        for (i = 0; i < 10; ++i) {
            regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn1).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build(), 0L);
        }
        for (i = 0; i < 15; ++i) {
            regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn2).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build(), 0L);
        }
        for (i = 0; i < 8; ++i) {
            regionReports.put(RegionInfoBuilder.newBuilder((TableName)tn3).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build(), 0L);
        }
        TableQuotaSnapshotStore store = new TableQuotaSnapshotStore(this.conn, this.chore, regionReports);
        Mockito.when((Object)this.chore.getTableSnapshotStore()).thenReturn((Object)store);
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)store.filterBySubject(tn1)));
        Assert.assertEquals((long)15L, (long)Iterables.size((Iterable)store.filterBySubject(tn2)));
        Assert.assertEquals((long)8L, (long)Iterables.size((Iterable)store.filterBySubject(tn3)));
    }
}

