/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import ch.cern.hbase.thirdparty.com.google.common.collect.HashMultimap;
import ch.cern.hbase.thirdparty.com.google.common.collect.Multimap;
import ch.cern.hbase.thirdparty.com.google.protobuf.ByteString;
import ch.cern.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestQuotaTableUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaTableUtil.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Connection connection;
    private int tableNameCounter;
    @Rule
    public TestName testName = new TestName();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 2000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        this.connection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        this.tableNameCounter = 0;
    }

    @After
    public void after() throws IOException {
        this.connection.close();
    }

    @Test
    public void testDeleteSnapshots() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        try (Table t = this.connection.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setSpace(QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(7L).setViolationPolicy(QuotaProtos.SpaceViolationPolicy.NO_WRITES).build()).build();
            QuotaUtil.addTableQuota((Connection)this.connection, (TableName)tn, (QuotaProtos.Quotas)quota);
            String snapshotName = this.name.getMethodName() + "_snapshot";
            t.put(QuotaTableUtil.createPutForSnapshotSize((TableName)tn, (String)snapshotName, (long)3L));
            t.put(QuotaTableUtil.createPutForSnapshotSize((TableName)tn, (String)snapshotName, (long)5L));
            Assert.assertEquals((long)1L, (long)QuotaTableUtil.getObservedSnapshotSizes((Connection)this.connection).size());
            List deletes = QuotaTableUtil.createDeletesForExistingTableSnapshotSizes((Connection)this.connection);
            Assert.assertEquals((long)1L, (long)deletes.size());
            t.delete(deletes);
            Assert.assertEquals((long)0L, (long)QuotaTableUtil.getObservedSnapshotSizes((Connection)this.connection).size());
            String ns = this.name.getMethodName();
            t.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)ns, (long)5L));
            t.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)ns, (long)3L));
            Assert.assertEquals((long)3L, (long)QuotaTableUtil.getNamespaceSnapshotSize((Connection)this.connection, (String)ns));
            deletes = QuotaTableUtil.createDeletesForExistingNamespaceSnapshotSizes((Connection)this.connection);
            Assert.assertEquals((long)1L, (long)deletes.size());
            t.delete(deletes);
            Assert.assertEquals((long)0L, (long)QuotaTableUtil.getNamespaceSnapshotSize((Connection)this.connection, (String)ns));
            t.put(QuotaTableUtil.createPutForSnapshotSize((TableName)TableName.valueOf((String)"t1"), (String)"s1", (long)3L));
            t.put(QuotaTableUtil.createPutForSnapshotSize((TableName)TableName.valueOf((String)"t2"), (String)"s2", (long)3L));
            t.put(QuotaTableUtil.createPutForSnapshotSize((TableName)TableName.valueOf((String)"t3"), (String)"s3", (long)3L));
            t.put(QuotaTableUtil.createPutForSnapshotSize((TableName)TableName.valueOf((String)"t4"), (String)"s4", (long)3L));
            t.put(QuotaTableUtil.createPutForSnapshotSize((TableName)TableName.valueOf((String)"t1"), (String)"s5", (long)3L));
            t.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)"ns1", (long)3L));
            t.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)"ns2", (long)3L));
            t.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)"ns3", (long)3L));
            Assert.assertEquals((long)5L, (long)QuotaTableUtil.getTableSnapshots((Connection)this.connection).size());
            Assert.assertEquals((long)3L, (long)QuotaTableUtil.getNamespaceSnapshots((Connection)this.connection).size());
            HashMultimap tableSnapshotEntriesToRemove = HashMultimap.create();
            tableSnapshotEntriesToRemove.put((Object)TableName.valueOf((String)"t1"), (Object)"s1");
            tableSnapshotEntriesToRemove.put((Object)TableName.valueOf((String)"t3"), (Object)"s3");
            tableSnapshotEntriesToRemove.put((Object)TableName.valueOf((String)"t4"), (Object)"s4");
            HashSet<String> namespaceSnapshotEntriesToRemove = new HashSet<String>();
            namespaceSnapshotEntriesToRemove.add("ns2");
            namespaceSnapshotEntriesToRemove.add("ns1");
            deletes = QuotaTableUtil.createDeletesForExistingTableSnapshotSizes((Multimap)tableSnapshotEntriesToRemove);
            Assert.assertEquals((long)3L, (long)deletes.size());
            deletes = QuotaTableUtil.createDeletesForExistingNamespaceSnapshotSizes(namespaceSnapshotEntriesToRemove);
            Assert.assertEquals((long)2L, (long)deletes.size());
        }
    }

    @Test
    public void testTableQuotaUtil() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)1000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setWriteNum(ProtobufUtil.toTimedQuota((long)600L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setReadSize(ProtobufUtil.toTimedQuota((long)8192L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaUtil.addTableQuota((Connection)this.connection, (TableName)tableName, (QuotaProtos.Quotas)quota);
        QuotaProtos.Quotas resQuota = QuotaUtil.getTableQuota((Connection)this.connection, (TableName)tableName);
        Assert.assertEquals((Object)quota, (Object)resQuota);
        QuotaUtil.deleteTableQuota((Connection)this.connection, (TableName)tableName);
        resQuota = QuotaUtil.getTableQuota((Connection)this.connection, (TableName)tableName);
        Assert.assertEquals(null, (Object)resQuota);
    }

    @Test
    public void testNamespaceQuotaUtil() throws Exception {
        String namespace = "testNamespaceQuotaUtilNS";
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)1000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setWriteNum(ProtobufUtil.toTimedQuota((long)600L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setReadSize(ProtobufUtil.toTimedQuota((long)8192L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaUtil.addNamespaceQuota((Connection)this.connection, (String)"testNamespaceQuotaUtilNS", (QuotaProtos.Quotas)quota);
        QuotaProtos.Quotas resQuota = QuotaUtil.getNamespaceQuota((Connection)this.connection, (String)"testNamespaceQuotaUtilNS");
        Assert.assertEquals((Object)quota, (Object)resQuota);
        QuotaUtil.deleteNamespaceQuota((Connection)this.connection, (String)"testNamespaceQuotaUtilNS");
        resQuota = QuotaUtil.getNamespaceQuota((Connection)this.connection, (String)"testNamespaceQuotaUtilNS");
        Assert.assertEquals(null, (Object)resQuota);
    }

    @Test
    public void testUserQuotaUtil() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String namespace = "testNS";
        String user = "testUser";
        QuotaProtos.Quotas quotaNamespace = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)50000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaProtos.Quotas quotaTable = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)1000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setWriteNum(ProtobufUtil.toTimedQuota((long)600L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setReadSize(ProtobufUtil.toTimedQuota((long)10000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqSize(ProtobufUtil.toTimedQuota((long)8192L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setWriteSize(ProtobufUtil.toTimedQuota((long)4096L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setReadNum(ProtobufUtil.toTimedQuota((long)1000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaUtil.addUserQuota((Connection)this.connection, (String)"testUser", (QuotaProtos.Quotas)quota);
        QuotaProtos.Quotas resQuota = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser");
        Assert.assertEquals((Object)quota, (Object)resQuota);
        QuotaUtil.addUserQuota((Connection)this.connection, (String)"testUser", (TableName)tableName, (QuotaProtos.Quotas)quotaTable);
        QuotaProtos.Quotas resQuotaTable = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser", (TableName)tableName);
        Assert.assertEquals((Object)quotaTable, (Object)resQuotaTable);
        QuotaUtil.addUserQuota((Connection)this.connection, (String)"testUser", (String)"testNS", (QuotaProtos.Quotas)quotaNamespace);
        QuotaProtos.Quotas resQuotaNS = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser", (String)"testNS");
        Assert.assertEquals((Object)quotaNamespace, (Object)resQuotaNS);
        QuotaUtil.deleteUserQuota((Connection)this.connection, (String)"testUser");
        resQuota = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser");
        Assert.assertEquals(null, (Object)resQuota);
        QuotaUtil.deleteUserQuota((Connection)this.connection, (String)"testUser", (TableName)tableName);
        resQuotaTable = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser", (TableName)tableName);
        Assert.assertEquals(null, (Object)resQuotaTable);
        QuotaUtil.deleteUserQuota((Connection)this.connection, (String)"testUser", (String)"testNS");
        resQuotaNS = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser", (String)"testNS");
        Assert.assertEquals(null, (Object)resQuotaNS);
    }

    @Test
    public void testSerDeViolationPolicies() throws Exception {
        TableName tn1 = this.getUniqueTableName();
        SpaceQuotaSnapshot snapshot1 = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.DISABLE), 512L, 1024L);
        TableName tn2 = this.getUniqueTableName();
        SpaceQuotaSnapshot snapshot2 = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_INSERTS), 512L, 1024L);
        TableName tn3 = this.getUniqueTableName();
        SpaceQuotaSnapshot snapshot3 = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES), 512L, 1024L);
        ArrayList<Put> puts = new ArrayList<Put>();
        puts.add(QuotaTableUtil.createPutForSpaceSnapshot((TableName)tn1, (SpaceQuotaSnapshot)snapshot1));
        puts.add(QuotaTableUtil.createPutForSpaceSnapshot((TableName)tn2, (SpaceQuotaSnapshot)snapshot2));
        puts.add(QuotaTableUtil.createPutForSpaceSnapshot((TableName)tn3, (SpaceQuotaSnapshot)snapshot3));
        HashMap<TableName, SpaceQuotaSnapshot> expectedPolicies = new HashMap<TableName, SpaceQuotaSnapshot>();
        expectedPolicies.put(tn1, snapshot1);
        expectedPolicies.put(tn2, snapshot2);
        expectedPolicies.put(tn3, snapshot3);
        HashMap actualPolicies = new HashMap();
        try (Table quotaTable = this.connection.getTable(QuotaUtil.QUOTA_TABLE_NAME);){
            quotaTable.put(puts);
            ResultScanner scanner = quotaTable.getScanner(QuotaTableUtil.makeQuotaSnapshotScan());
            for (Result r : scanner) {
                QuotaTableUtil.extractQuotaSnapshot((Result)r, actualPolicies);
            }
            scanner.close();
        }
        Assert.assertEquals(expectedPolicies, actualPolicies);
    }

    @Test
    public void testSerdeTableSnapshotSizes() throws Exception {
        TableName tn1 = TableName.valueOf((String)"tn1");
        TableName tn2 = TableName.valueOf((String)"tn2");
        try (Table quotaTable = this.connection.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            Put p;
            int i;
            for (i = 0; i < 3; ++i) {
                p = QuotaTableUtil.createPutForSnapshotSize((TableName)tn1, (String)("tn1snap" + i), (long)(1024L * (long)(1 + i)));
                quotaTable.put(p);
            }
            for (i = 0; i < 3; ++i) {
                p = QuotaTableUtil.createPutForSnapshotSize((TableName)tn2, (String)("tn2snap" + i), (long)(2048L * (long)(1 + i)));
                quotaTable.put(p);
            }
            this.verifyTableSnapshotSize(quotaTable, tn1, "tn1snap0", 1024L);
            this.verifyTableSnapshotSize(quotaTable, tn1, "tn1snap1", 2048L);
            this.verifyTableSnapshotSize(quotaTable, tn1, "tn1snap2", 3072L);
            this.verifyTableSnapshotSize(quotaTable, tn2, "tn2snap0", 2048L);
            this.verifyTableSnapshotSize(quotaTable, tn2, "tn2snap1", 4096L);
            this.verifyTableSnapshotSize(quotaTable, tn2, "tn2snap2", 6144L);
            this.cleanUpSnapshotSizes();
        }
    }

    @Test
    public void testReadNamespaceSnapshotSizes() throws Exception {
        String ns1 = "ns1";
        String ns2 = "ns2";
        String defaultNs = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR;
        try (Table quotaTable = this.connection.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            quotaTable.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)ns1, (long)1024L));
            quotaTable.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)ns2, (long)2048L));
            quotaTable.put(QuotaTableUtil.createPutForNamespaceSnapshotSize((String)defaultNs, (long)8192L));
            Assert.assertEquals((long)1024L, (long)QuotaTableUtil.getNamespaceSnapshotSize((Connection)this.connection, (String)ns1));
            Assert.assertEquals((long)2048L, (long)QuotaTableUtil.getNamespaceSnapshotSize((Connection)this.connection, (String)ns2));
            Assert.assertEquals((long)8192L, (long)QuotaTableUtil.getNamespaceSnapshotSize((Connection)this.connection, (String)defaultNs));
            this.cleanUpSnapshotSizes();
        }
    }

    private TableName getUniqueTableName() {
        return TableName.valueOf((String)(this.testName.getMethodName() + "_" + this.tableNameCounter++));
    }

    private void verifyTableSnapshotSize(Table quotaTable, TableName tn, String snapshotName, long expectedSize) throws IOException {
        Result r = quotaTable.get(QuotaTableUtil.makeGetForSnapshotSize((TableName)tn, (String)snapshotName));
        CellScanner cs = r.cellScanner();
        Assert.assertTrue((boolean)cs.advance());
        Cell c = cs.current();
        Assert.assertEquals((long)expectedSize, (long)QuotaProtos.SpaceQuotaSnapshot.parseFrom((ByteString)UnsafeByteOperations.unsafeWrap((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength())).getQuotaUsage());
        Assert.assertFalse((boolean)cs.advance());
    }

    private void cleanUpSnapshotSizes() throws IOException {
        try (Table t = this.connection.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            QuotaTableUtil.createDeletesForExistingTableSnapshotSizes((Connection)this.connection);
            List deletes = QuotaTableUtil.createDeletesForExistingNamespaceSnapshotSizes((Connection)this.connection);
            deletes.addAll(QuotaTableUtil.createDeletesForExistingTableSnapshotSizes((Connection)this.connection));
            t.delete(deletes);
        }
    }
}

