/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import ch.cern.hbase.thirdparty.com.google.common.collect.Iterables;
import ch.cern.hbase.thirdparty.com.google.protobuf.ByteString;
import ch.cern.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestSpaceQuotasWithSnapshots {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotasWithSnapshots.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSpaceQuotasWithSnapshots.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private static final long FUDGE_FOR_TABLE_SIZE = 512000L;
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;
    private Connection conn;
    private Admin admin;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
        this.conn = TEST_UTIL.getConnection();
        this.admin = TEST_UTIL.getAdmin();
    }

    @Test
    public void testTablesInheritSnapshotSize() throws Exception {
        final TableName tn = this.helper.createTableWithRegions(1);
        LOG.info("Writing data");
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings);
        long initialSize = 0x200000L;
        this.helper.writeData(tn, 0x200000L);
        LOG.info("Waiting until table size reflects written data");
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= 0x200000L;
            }
        });
        this.waitForStableQuotaSize(this.conn, tn, null);
        long actualInitialSize = this.conn.getAdmin().getCurrentSpaceQuotaSnapshot(tn).getUsage();
        LOG.info("Initial table size was " + actualInitialSize);
        LOG.info("Snapshot the table");
        String snapshot1 = tn.toString() + "_snapshot1";
        this.admin.snapshot(snapshot1, tn);
        LOG.info("Write more data");
        this.helper.writeData(tn, 0x200000L);
        LOG.info("Flush the table");
        this.admin.flush(tn);
        LOG.info("Synchronously compacting the table");
        TEST_UTIL.compact(tn, true);
        long upperBound = 2609152L;
        long lowerBound = 1585152L;
        LOG.info("Waiting for the region reports to reflect the correct size, between (1585152, 2609152)");
        TEST_UTIL.waitFor(30000L, 500L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                long size = TestSpaceQuotasWithSnapshots.this.getRegionSizeReportForTable(TestSpaceQuotasWithSnapshots.this.conn, tn);
                return size < 2609152L && size > 1585152L;
            }
        });
        this.waitForStableRegionSizeReport(this.conn, tn);
        final long finalSize = this.getRegionSizeReportForTable(this.conn, tn);
        Assert.assertNotNull((String)"Did not expect to see a null size", (Object)finalSize);
        LOG.info("Last seen size: " + finalSize);
        TEST_UTIL.waitFor(20000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            public boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= finalSize;
            }
        });
        final long expectedFinalSize = actualInitialSize + finalSize;
        LOG.info("Expecting table usage to be " + actualInitialSize + " + " + finalSize + " = " + expectedFinalSize);
        TEST_UTIL.waitFor(30000L, 1000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                LOG.debug("Checking for " + expectedFinalSize + " == " + snapshot.getUsage());
                return expectedFinalSize == snapshot.getUsage();
            }
        });
        Map snapshotSizes = QuotaTableUtil.getObservedSnapshotSizes((Connection)this.conn);
        Long size = (Long)snapshotSizes.get(snapshot1);
        Assert.assertNotNull((String)"Did not observe the size of the snapshot", (Object)size);
        Assert.assertEquals((String)"The recorded size of the HBase snapshot was not the size we expected", (long)actualInitialSize, (long)size);
    }

    @Test
    public void testNamespacesInheritSnapshotSize() throws Exception {
        String ns = this.helper.createNamespace().getName();
        final TableName tn = this.helper.createTableWithRegions(ns, 1);
        LOG.info("Writing data");
        QuotaSettings settings = QuotaSettingsFactory.limitNamespaceSpace((String)ns, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings);
        long initialSize = 0x200000L;
        this.helper.writeData(tn, 0x200000L);
        this.admin.flush(tn);
        LOG.info("Waiting until namespace size reflects written data");
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, ns){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= 0x200000L;
            }
        });
        this.waitForStableQuotaSize(this.conn, null, ns);
        long actualInitialSize = this.conn.getAdmin().getCurrentSpaceQuotaSnapshot(ns).getUsage();
        LOG.info("Initial table size was " + actualInitialSize);
        LOG.info("Snapshot the table");
        String snapshot1 = tn.getQualifierAsString() + "_snapshot1";
        this.admin.snapshot(snapshot1, tn);
        LOG.info("Write more data");
        this.helper.writeData(tn, 0x200000L);
        LOG.info("Flush the table");
        this.admin.flush(tn);
        LOG.info("Synchronously compacting the table");
        TEST_UTIL.compact(tn, true);
        long upperBound = 2609152L;
        long lowerBound = 1585152L;
        LOG.info("Waiting for the region reports to reflect the correct size, between (1585152, 2609152)");
        TEST_UTIL.waitFor(30000L, 500L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map sizes = TestSpaceQuotasWithSnapshots.this.conn.getAdmin().getSpaceQuotaTableSizes();
                LOG.debug("Master observed table sizes from region size reports: " + sizes);
                Long size = (Long)sizes.get(tn);
                if (null == size) {
                    return false;
                }
                return size < 2609152L && size > 1585152L;
            }
        });
        this.waitForStableRegionSizeReport(this.conn, tn);
        final long finalSize = this.getRegionSizeReportForTable(this.conn, tn);
        Assert.assertNotNull((String)"Did not expect to see a null size", (Object)finalSize);
        LOG.info("Final observed size of table: " + finalSize);
        TEST_UTIL.waitFor(20000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, ns){

            @Override
            public boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= finalSize;
            }
        });
        final long expectedFinalSize = actualInitialSize + finalSize;
        LOG.info("Expecting namespace usage to be " + actualInitialSize + " + " + finalSize + " = " + expectedFinalSize);
        TEST_UTIL.waitFor(30000L, 1000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, ns){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                LOG.debug("Checking for " + expectedFinalSize + " == " + snapshot.getUsage());
                return expectedFinalSize == snapshot.getUsage();
            }
        });
        Map snapshotSizes = QuotaTableUtil.getObservedSnapshotSizes((Connection)this.conn);
        Long size = (Long)snapshotSizes.get(snapshot1);
        Assert.assertNotNull((String)"Did not observe the size of the snapshot", (Object)size);
        Assert.assertEquals((String)"The recorded size of the HBase snapshot was not the size we expected", (long)actualInitialSize, (long)size);
    }

    @Test
    public void testTablesWithSnapshots() throws Exception {
        final Connection conn = TEST_UTIL.getConnection();
        SpaceViolationPolicy policy = SpaceViolationPolicy.NO_INSERTS;
        final TableName tn = this.helper.createTableWithRegions(10);
        long tableLimit = 0x300000L;
        TEST_UTIL.getAdmin().setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x300000L, (SpaceViolationPolicy)policy));
        LOG.info("Writing first data set");
        this.helper.writeData(tn, 0x100000L, "q1");
        LOG.info("Creating snapshot");
        TEST_UTIL.getAdmin().snapshot(tn.toString() + "snap1", tn, SnapshotType.FLUSH);
        LOG.info("Writing second data set");
        this.helper.writeData(tn, 0x100000L, "q2");
        LOG.info("Flushing and major compacting table");
        TEST_UTIL.getAdmin().flush(tn);
        TEST_UTIL.compact(tn, true);
        LOG.info("Checking for quota violation");
        TEST_UTIL.waitFor(60000L, 1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean evaluate() throws Exception {
                Scan s = QuotaTableUtil.makeQuotaSnapshotScanForTable((TableName)tn);
                Throwable throwable = null;
                try (Table t = conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
                    boolean bl;
                    block16: {
                        ResultScanner rs = t.getScanner(s);
                        try {
                            Result r = (Result)Iterables.getOnlyElement((Iterable)rs);
                            CellScanner cs = r.cellScanner();
                            Assert.assertTrue((boolean)cs.advance());
                            Cell c = cs.current();
                            SpaceQuotaSnapshot snapshot = SpaceQuotaSnapshot.toSpaceQuotaSnapshot((QuotaProtos.SpaceQuotaSnapshot)QuotaProtos.SpaceQuotaSnapshot.parseFrom((ByteString)UnsafeByteOperations.unsafeWrap((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength())));
                            LOG.info(snapshot.getUsage() + "/" + snapshot.getLimit() + " " + snapshot.getQuotaStatus());
                            bl = snapshot.getQuotaStatus().isInViolation();
                            if (null == rs) break block16;
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (null != rs) {
                                    rs.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                        }
                        rs.close();
                    }
                    return bl;
                }
            }
        });
    }

    @Test
    public void testRematerializedTablesDoNoInheritSpace() throws Exception {
        TableName tn = this.helper.createTableWithRegions(1);
        TableName tn2 = this.helper.getNextTableName();
        LOG.info("Writing data");
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings);
        QuotaSettings settings2 = QuotaSettingsFactory.limitTableSpace((TableName)tn2, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings2);
        long initialSize = 0x200000L;
        this.helper.writeData(tn, 0x200000L);
        LOG.info("Waiting until table size reflects written data");
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= 0x200000L;
            }
        });
        this.waitForStableQuotaSize(this.conn, tn, null);
        final long actualInitialSize = this.conn.getAdmin().getCurrentSpaceQuotaSnapshot(tn).getUsage();
        LOG.info("Initial table size was " + actualInitialSize);
        LOG.info("Snapshot the table");
        String snapshot1 = tn.toString() + "_snapshot1";
        this.admin.snapshot(snapshot1, tn);
        this.admin.cloneSnapshot(snapshot1, tn2);
        this.helper.writeData(tn, 0x200000L, "q2");
        this.admin.flush(tn);
        TEST_UTIL.waitFor(30000L, 1000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= actualInitialSize * 2L;
            }
        });
        SpaceQuotaSnapshot snapshot = (SpaceQuotaSnapshot)this.conn.getAdmin().getCurrentSpaceQuotaSnapshot(tn2);
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((long)0L, (long)snapshot.getUsage());
        TEST_UTIL.compact(tn2, true);
        TEST_UTIL.waitFor(30000L, 1000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn2){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= actualInitialSize;
            }
        });
    }

    void waitForStableQuotaSize(Connection conn, TableName tn, String ns) throws Exception {
        final AtomicLong lastValue = new AtomicLong(-1L);
        final AtomicInteger counter = new AtomicInteger(0);
        TEST_UTIL.waitFor(15000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(conn, tn, ns){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                LOG.debug("Last observed size=" + lastValue.get());
                if (snapshot.getUsage() == lastValue.get()) {
                    int numMatches = counter.incrementAndGet();
                    return numMatches >= 5;
                }
                counter.set(0);
                lastValue.set(snapshot.getUsage());
                return false;
            }
        });
    }

    long getRegionSizeReportForTable(Connection conn, TableName tn) throws IOException {
        Map sizes = conn.getAdmin().getSpaceQuotaTableSizes();
        Long value = (Long)sizes.get(tn);
        if (null == value) {
            return 0L;
        }
        return value;
    }

    void waitForStableRegionSizeReport(final Connection conn, final TableName tn) throws Exception {
        final AtomicLong lastValue = new AtomicLong(-1L);
        final AtomicInteger counter = new AtomicInteger(0);
        TEST_UTIL.waitFor(15000L, 500L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                LOG.debug("Last observed size=" + lastValue.get());
                long actual = TestSpaceQuotasWithSnapshots.this.getRegionSizeReportForTable(conn, tn);
                if (actual == lastValue.get()) {
                    int numMatches = counter.incrementAndGet();
                    return numMatches >= 5;
                }
                counter.set(0);
                lastValue.set(actual);
                return false;
            }
        });
    }
}

