/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMinVersions {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMinVersions.class);
    HBaseTestingUtility hbu = new HBaseTestingUtility();
    private final byte[] T0 = Bytes.toBytes((String)"0");
    private final byte[] T1 = Bytes.toBytes((String)"1");
    private final byte[] T2 = Bytes.toBytes((String)"2");
    private final byte[] T3 = Bytes.toBytes((String)"3");
    private final byte[] T4 = Bytes.toBytes((String)"4");
    private final byte[] T5 = Bytes.toBytes((String)"5");
    private final byte[] c0 = HBaseTestingUtility.COLUMNS[0];
    @Rule
    public TestName name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetClosestBefore() throws Exception {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.c0).setMinVersions(1).setMaxVersions(1000).setTimeToLive(1).setKeepDeletedCells(KeepDeletedCells.FALSE).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(cfd).build();
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        try {
            long ts = EnvironmentEdgeManager.currentTime() - 2000L;
            Put p = new Put(this.T1, ts);
            p.addColumn(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts + 1L);
            p.addColumn(this.c0, this.c0, this.T4);
            region.put(p);
            p = new Put(this.T3, ts);
            p.addColumn(this.c0, this.c0, this.T3);
            region.put(p);
            Result r = this.hbu.getClosestRowBefore((Region)region, this.T1, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            r = this.hbu.getClosestRowBefore((Region)region, this.T2, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            region.flush(true);
            region.compact(true);
            r = this.hbu.getClosestRowBefore((Region)region, this.T1, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            r = this.hbu.getClosestRowBefore((Region)region, this.T2, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreMemStore() throws Exception {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.c0).setMinVersions(3).setMaxVersions(1000).setTimeToLive(1).setKeepDeletedCells(KeepDeletedCells.FALSE).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(cfd).build();
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 1L);
            p.addColumn(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 3L);
            p.addColumn(this.c0, this.c0, this.T0);
            region.put(p);
            region.flush(true);
            region.compact(true);
            p = new Put(this.T1, ts);
            p.addColumn(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.addColumn(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 3L);
            p.addColumn(this.c0, this.c0, this.T0);
            region.put(p);
            Get g = new Get(this.T1);
            g.setMaxVersions();
            Result r = region.get(g);
            this.checkResult(r, this.c0, this.T3, this.T2, this.T1);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, this.T3, this.T2, this.T1);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Exception {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.c0).setMinVersions(3).setMaxVersions(1000).setTimeToLive(1).setKeepDeletedCells(KeepDeletedCells.FALSE).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(cfd).build();
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 2L);
            p.addColumn(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.addColumn(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts);
            p.addColumn(this.c0, this.c0, this.T3);
            region.put(p);
            Delete d = new Delete(this.T1, ts - 1L);
            region.delete(d);
            Get g = new Get(this.T1);
            g.setMaxVersions();
            Result r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            region.flush(true);
            region.compact(true);
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemStore() throws Exception {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.c0).setMinVersions(2).setMaxVersions(1000).setTimeToLive(1).setKeepDeletedCells(KeepDeletedCells.FALSE).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(cfd).build();
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 2L);
            p.addColumn(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.addColumn(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts);
            p.addColumn(this.c0, this.c0, this.T4);
            region.put(p);
            region.flush(true);
            region.compact(true);
            p = new Put(this.T1, ts - 3L);
            p.addColumn(this.c0, this.c0, this.T1);
            region.put(p);
            Result r = region.get(new Get(this.T1));
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            Get g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, this.T4, this.T3);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, this.T4, this.T3);
            p = new Put(this.T1, ts + 1L);
            p.addColumn(this.c0, this.c0, this.T5);
            region.put(p);
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, this.T5, this.T4);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, this.T5, this.T4);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseCase() throws Exception {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.c0).setMinVersions(2).setMaxVersions(1000).setTimeToLive(1).setKeepDeletedCells(KeepDeletedCells.FALSE).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(cfd).build();
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        try {
            long ts = EnvironmentEdgeManager.currentTime() - 2000L;
            Put p = new Put(this.T1, ts - 3L);
            p.addColumn(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.addColumn(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.addColumn(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts);
            p.addColumn(this.c0, this.c0, this.T4);
            region.put(p);
            Result r = region.get(new Get(this.T1));
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            Get g = new Get(this.T1);
            g.setTimeRange(0L, ts + 1L);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            g.setTimeRange(0L, ts - 2L);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T1});
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, this.T4, this.T3);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, this.T4, this.T3);
            region.flush(true);
            g = new Get(this.T1);
            g.setTimeRange(0L, ts - 2L);
            r = region.get(g);
            Assert.assertTrue((boolean)r.isEmpty());
            region.compact(true);
            g = new Get(this.T1);
            g.setTimeRange(0L, ts + 1L);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            g.setTimeRange(0L, ts);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g.setTimeRange(0L, ts - 1L);
            r = region.get(g);
            Assert.assertTrue((boolean)r.isEmpty());
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilters() throws Exception {
        byte[] c1 = HBaseTestingUtility.COLUMNS[1];
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.c0).setMinVersions(2).setMaxVersions(1000).setTimeToLive(1).setKeepDeletedCells(KeepDeletedCells.FALSE).build();
        ColumnFamilyDescriptor cfd2 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])c1).setMinVersions(2).setMaxVersions(1000).setTimeToLive(1).setKeepDeletedCells(KeepDeletedCells.FALSE).build();
        ArrayList<ColumnFamilyDescriptor> cfdList = new ArrayList<ColumnFamilyDescriptor>();
        cfdList.add(cfd);
        cfdList.add(cfd2);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamilies(cfdList).build();
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 3L);
            p.addColumn(this.c0, this.c0, this.T0);
            p.addColumn(c1, c1, this.T0);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.addColumn(this.c0, this.c0, this.T1);
            p.addColumn(c1, c1, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.addColumn(this.c0, this.c0, this.T2);
            p.addColumn(c1, c1, this.T2);
            region.put(p);
            p = new Put(this.T1, ts);
            p.addColumn(this.c0, this.c0, this.T3);
            p.addColumn(c1, c1, this.T3);
            region.put(p);
            ArrayList<Long> tss = new ArrayList<Long>();
            tss.add(ts - 1L);
            tss.add(ts - 2L);
            Get g = new Get(this.T1);
            g.addColumn(c1, c1);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            Result r = region.get(g);
            this.checkResult(r, c1, new byte[][]{this.T2});
            g = new Get(this.T1);
            g.addColumn(this.c0, this.c0);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T2});
            region.flush(true);
            region.compact(true);
            g = new Get(this.T1);
            g.addColumn(c1, c1);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, c1, new byte[][]{this.T2});
            g = new Get(this.T1);
            g.addColumn(this.c0, this.c0);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T2});
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    @Test
    public void testMinVersionsWithKeepDeletedCellsTTL() throws Exception {
        int ttl = 4;
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.c0).setMinVersions(2).setMaxVersions(Integer.MAX_VALUE).setTimeToLive(ttl).setKeepDeletedCells(KeepDeletedCells.TTL).build();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(cfd).build();
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        long startTS = EnvironmentEdgeManager.currentTime();
        ManualEnvironmentEdge injectEdge = new ManualEnvironmentEdge();
        injectEdge.setValue(startTS);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)injectEdge);
        long ts = startTS - 2000L;
        Put p = new Put(this.T1, ts - 3L);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts - 2L);
        p.addColumn(this.c0, this.c0, this.T2);
        region.put(p);
        p = new Put(this.T1, ts - 1L);
        p.addColumn(this.c0, this.c0, this.T3);
        region.put(p);
        Get g = new Get(this.T1);
        g.readAllVersions();
        g.setTimeRange(0L, ts);
        Result r = region.get(g);
        this.checkResult(r, this.c0, this.T3, this.T2, this.T1);
        region.flush(true);
        region.compact(true);
        Assert.assertEquals((long)startTS, (long)EnvironmentEdgeManager.currentTime());
        long expiredTime = EnvironmentEdgeManager.currentTime() - ts - 3L;
        Assert.assertTrue((String)"TTL for T1 has expired", (expiredTime < (long)(ttl * 1000) ? 1 : 0) != 0);
        g = new Get(this.T1);
        g.readAllVersions();
        g.setTimeRange(0L, ts);
        r = region.get(g);
        this.checkResult(r, this.c0, this.T3, this.T2, this.T1);
        g = new Get(this.T1);
        g.readAllVersions();
        g.setTimeRange(0L, ts - 1L);
        r = region.get(g);
        this.checkResult(r, this.c0, this.T2, this.T1);
        injectEdge.incValue((long)(ttl * 1000));
        region.flush(true);
        region.compact(true);
        g = new Get(this.T1);
        g.readAllVersions();
        g.setTimeRange(0L, ts);
        r = region.get(g);
        this.checkResult(r, this.c0, this.T3, this.T2);
        g = new Get(this.T1);
        g.readAllVersions();
        g.setTimestamp(ts - 2L);
        r = region.get(g);
        this.checkResult(r, this.c0, new byte[][]{this.T2});
    }

    private void checkResult(Result r, byte[] col, byte[] ... vals) {
        Assert.assertEquals((long)vals.length, (long)r.size());
        List kvs = r.getColumnCells(col, col);
        Assert.assertEquals((long)kvs.size(), (long)vals.length);
        for (int i = 0; i < vals.length; ++i) {
            String expected = Bytes.toString((byte[])vals[i]);
            String actual = Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(i))));
            Assert.assertTrue((String)(expected + " was expected but doesn't match " + actual), (boolean)CellUtil.matchingValue((Cell)((Cell)kvs.get(i)), (byte[])vals[i]));
        }
    }
}

