/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMultiVersionConcurrencyControlBasic {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiVersionConcurrencyControlBasic.class);

    @Test
    public void testSimpleMvccOps() {
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        long readPoint = mvcc.getReadPoint();
        MultiVersionConcurrencyControl.WriteEntry writeEntry = mvcc.begin();
        mvcc.completeAndWait(writeEntry);
        Assert.assertEquals((long)(readPoint + 1L), (long)mvcc.getReadPoint());
        writeEntry = mvcc.begin();
        mvcc.complete(writeEntry);
        Assert.assertEquals((long)(readPoint + 2L), (long)mvcc.getWritePoint());
    }
}

