/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import ch.cern.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRegionInfoBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionInfoBuilder.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testBuilder() {
        TableName tn = TableName.valueOf((String)"test");
        RegionInfoBuilder builder = RegionInfoBuilder.newBuilder((TableName)tn);
        byte[] startKey = Bytes.toBytes((String)"a");
        builder.setStartKey(startKey);
        byte[] endKey = Bytes.toBytes((String)"z");
        builder.setEndKey(endKey);
        int regionId = 1;
        builder.setRegionId(1L);
        int replicaId = 2;
        builder.setReplicaId(replicaId);
        boolean offline = true;
        builder.setOffline(offline);
        boolean isSplit = true;
        builder.setSplit(isSplit);
        RegionInfo ri = builder.build();
        Assert.assertEquals((Object)tn, (Object)ri.getTable());
        Assert.assertArrayEquals((byte[])startKey, (byte[])ri.getStartKey());
        Assert.assertArrayEquals((byte[])endKey, (byte[])ri.getEndKey());
        Assert.assertEquals((long)regionId, (long)ri.getRegionId());
        Assert.assertEquals((long)replicaId, (long)ri.getReplicaId());
        Assert.assertEquals((Object)offline, (Object)ri.isOffline());
        Assert.assertEquals((Object)isSplit, (Object)ri.isSplit());
    }

    @Test
    public void testPb() throws DeserializationException {
        RegionInfo ri = RegionInfoBuilder.FIRST_META_REGIONINFO;
        byte[] bytes = RegionInfo.toByteArray((RegionInfo)ri);
        RegionInfo pbri = RegionInfo.parseFrom((byte[])bytes);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(ri, pbri) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadAndWriteRegionInfoFile() throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        RegionInfo ri = RegionInfoBuilder.FIRST_META_REGIONINFO;
        Path basedir = htu.getDataTestDir();
        FSTableDescriptors fsTableDescriptors = new FSTableDescriptors(htu.getConfiguration());
        HRegion r = HBaseTestingUtility.createRegionAndWAL((RegionInfo)this.convert(ri), basedir, htu.getConfiguration(), fsTableDescriptors.get(TableName.META_TABLE_NAME));
        long modtime = this.getModTime(r);
        HBaseTestingUtility.closeRegionAndWAL(r);
        Thread.sleep(1001L);
        r = HRegion.openHRegion((Path)basedir, (RegionInfo)this.convert(ri), (TableDescriptor)fsTableDescriptors.get(TableName.META_TABLE_NAME), null, (Configuration)htu.getConfiguration());
        long modtime2 = this.getModTime(r);
        Assert.assertEquals((long)modtime, (long)modtime2);
        RegionInfo deserializedRi = HRegionFileSystem.loadRegionInfoFileContent((FileSystem)r.getRegionFileSystem().getFileSystem(), (Path)r.getRegionFileSystem().getRegionDir());
        HBaseTestingUtility.closeRegionAndWAL(r);
    }

    long getModTime(HRegion r) throws IOException {
        FileStatus[] statuses = r.getRegionFileSystem().getFileSystem().listStatus(new Path(r.getRegionFileSystem().getRegionDir(), ".regioninfo"));
        Assert.assertTrue((statuses != null && statuses.length == 1 ? 1 : 0) != 0);
        return statuses[0].getModificationTime();
    }

    @Test
    public void testCreateRegionInfoName() throws Exception {
        String tableName = this.name.getMethodName();
        TableName tn = TableName.valueOf((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        String md5HashInHex = MD5Hash.getMD5AsHex((byte[])name);
        Assert.assertEquals((long)32L, (long)md5HashInHex.length());
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)true);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "." + md5HashInHex + "."), (Object)nameStr);
    }

    @Test
    public void testContainsRange() {
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"g")).build();
        Assert.assertTrue((boolean)ri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"a")));
        Assert.assertTrue((boolean)ri.containsRange(Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)ri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)ri.containsRange(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"c")));
        Assert.assertFalse((boolean)ri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)ri.containsRange(Bytes.toBytes((String)"g"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)ri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"z")));
        try {
            ri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"a"));
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLastRegionCompare() {
        RegionInfo ric;
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        RegionInfo rip = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(new byte[0]).build();
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(rip, ric = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaTables() {
        Assert.assertTrue((boolean)RegionInfoBuilder.FIRST_META_REGIONINFO.isMetaRegion());
    }

    @Test
    public void testComparator() {
        RegionInfo newer;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] empty = new byte[]{};
        RegionInfo older = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(empty).setEndKey(empty).setSplit(false).setRegionId(0L).build();
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(older, newer = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(empty).setEndKey(empty).setSplit(false).setRegionId(1L).build()) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(newer, older) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(older, older) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(newer, newer) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegionNameForRegionReplicas() throws Exception {
        String tableName = this.name.getMethodName();
        TableName tn = TableName.valueOf((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)0, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)1, (boolean)false);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "_" + String.format("%04X", 1)), (Object)nameStr);
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)65535, (boolean)false);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "_" + String.format("%04X", 65535)), (Object)nameStr);
    }

    @Test
    public void testParseName() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] startKey = Bytes.toBytes((String)"startKey");
        long regionId = System.currentTimeMillis();
        int replicaId = 42;
        byte[] regionName = RegionInfo.createRegionName((TableName)tableName, (byte[])startKey, (long)regionId, (boolean)false);
        byte[][] fields = RegionInfo.parseRegionName((byte[])regionName);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[0]), (byte[])tableName.getName(), (byte[])fields[0]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[1]), (byte[])startKey, (byte[])fields[1]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[2]), (byte[])Bytes.toBytes((String)Long.toString(regionId)), (byte[])fields[2]);
        Assert.assertEquals((long)3L, (long)fields.length);
        regionName = RegionInfo.createRegionName((TableName)tableName, (byte[])startKey, (long)regionId, (int)replicaId, (boolean)false);
        fields = RegionInfo.parseRegionName((byte[])regionName);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[0]), (byte[])tableName.getName(), (byte[])fields[0]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[1]), (byte[])startKey, (byte[])fields[1]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[2]), (byte[])Bytes.toBytes((String)Long.toString(regionId)), (byte[])fields[2]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[3]), (byte[])Bytes.toBytes((String)String.format("%04X", replicaId)), (byte[])fields[3]);
    }

    @Test
    public void testConvert() {
        TableName tableName = TableName.valueOf((String)("ns1:" + this.name.getMethodName()));
        byte[] startKey = Bytes.toBytes((String)"startKey");
        byte[] endKey = Bytes.toBytes((String)"endKey");
        boolean split = false;
        long regionId = System.currentTimeMillis();
        int replicaId = 42;
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).setSplit(split).setRegionId(regionId).setReplicaId(replicaId).build();
        RegionInfo convertedRi = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)ProtobufUtil.toRegionInfo((RegionInfo)ri));
        Assert.assertEquals((Object)ri, (Object)convertedRi);
        HBaseProtos.RegionInfo info = HBaseProtos.RegionInfo.newBuilder().setTableName(HBaseProtos.TableName.newBuilder().setQualifier(UnsafeByteOperations.unsafeWrap((byte[])tableName.getQualifier())).setNamespace(UnsafeByteOperations.unsafeWrap((byte[])tableName.getNamespace())).build()).setStartKey(UnsafeByteOperations.unsafeWrap((byte[])startKey)).setEndKey(UnsafeByteOperations.unsafeWrap((byte[])endKey)).setSplit(split).setRegionId(regionId).build();
        convertedRi = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)info);
        RegionInfo expectedRi = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).setSplit(split).setRegionId(regionId).setReplicaId(0).build();
        Assert.assertEquals((Object)expectedRi, (Object)convertedRi);
    }

    private HRegionInfo convert(RegionInfo ri) {
        HRegionInfo hri = new HRegionInfo(ri.getTable(), ri.getStartKey(), ri.getEndKey(), ri.isSplit(), ri.getRegionId());
        hri.setOffline(ri.isOffline());
        return hri;
    }
}

