/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;
import org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestReversibleScanners {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReversibleScanners.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReversibleScanners.class);
    HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILYNAME = Bytes.toBytes((String)"testCf");
    private static long TS = System.currentTimeMillis();
    private static int MAXMVCC = 7;
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final int ROWSIZE = 200;
    private static byte[][] ROWS = TestReversibleScanners.makeN(ROW, 200);
    private static byte[] QUAL = Bytes.toBytes((String)"testQual");
    private static final int QUALSIZE = 5;
    private static byte[][] QUALS = TestReversibleScanners.makeN(QUAL, 5);
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");
    private static final int VALUESIZE = 3;
    private static byte[][] VALUES = TestReversibleScanners.makeN(VALUE, 3);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
    }

    @Test
    public void testReversibleStoreFileScanner() throws IOException {
        FileSystem fs = this.TEST_UTIL.getTestFileSystem();
        Path hfilePath = new Path(new Path(this.TEST_UTIL.getDataTestDir("testReversibleStoreFileScanner"), "regionname"), "familyname");
        CacheConfig cacheConf = new CacheConfig(this.TEST_UTIL.getConfiguration());
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            HFileContextBuilder hcBuilder = new HFileContextBuilder();
            hcBuilder.withBlockSize(2048);
            hcBuilder.withDataBlockEncoding(encoding);
            HFileContext hFileContext = hcBuilder.build();
            StoreFileWriter writer = new StoreFileWriter.Builder(this.TEST_UTIL.getConfiguration(), cacheConf, fs).withOutputDir(hfilePath).withFileContext(hFileContext).build();
            TestReversibleScanners.writeStoreFile(writer);
            HStoreFile sf = new HStoreFile(fs, writer.getPath(), this.TEST_UTIL.getConfiguration(), cacheConf, BloomType.NONE, true);
            List scanners = StoreFileScanner.getScannersForStoreFiles(Collections.singletonList(sf), (boolean)false, (boolean)true, (boolean)false, (boolean)false, (long)Long.MAX_VALUE);
            StoreFileScanner scanner = (StoreFileScanner)scanners.get(0);
            this.seekTestOfReversibleKeyValueScanner((KeyValueScanner)scanner);
            for (int readPoint = 0; readPoint < MAXMVCC; ++readPoint) {
                LOG.info("Setting read point to " + readPoint);
                scanners = StoreFileScanner.getScannersForStoreFiles(Collections.singletonList(sf), (boolean)false, (boolean)true, (boolean)false, (boolean)false, (long)readPoint);
                this.seekTestOfReversibleKeyValueScannerWithMVCC(scanners, readPoint);
            }
        }
    }

    @Test
    public void testReversibleMemstoreScanner() throws IOException {
        DefaultMemStore memstore = new DefaultMemStore();
        TestReversibleScanners.writeMemstore((MemStore)memstore);
        List scanners = memstore.getScanners(Long.MAX_VALUE);
        this.seekTestOfReversibleKeyValueScanner((KeyValueScanner)scanners.get(0));
        for (int readPoint = 0; readPoint < MAXMVCC; ++readPoint) {
            LOG.info("Setting read point to " + readPoint);
            scanners = memstore.getScanners((long)readPoint);
            this.seekTestOfReversibleKeyValueScannerWithMVCC(scanners, readPoint);
        }
    }

    @Test
    public void testReversibleKeyValueHeap() throws IOException {
        FileSystem fs = this.TEST_UTIL.getTestFileSystem();
        Path hfilePath = new Path(new Path(this.TEST_UTIL.getDataTestDir("testReversibleKeyValueHeap"), "regionname"), "familyname");
        CacheConfig cacheConf = new CacheConfig(this.TEST_UTIL.getConfiguration());
        HFileContextBuilder hcBuilder = new HFileContextBuilder();
        hcBuilder.withBlockSize(2048);
        HFileContext hFileContext = hcBuilder.build();
        StoreFileWriter writer1 = new StoreFileWriter.Builder(this.TEST_UTIL.getConfiguration(), cacheConf, fs).withOutputDir(hfilePath).withFileContext(hFileContext).build();
        StoreFileWriter writer2 = new StoreFileWriter.Builder(this.TEST_UTIL.getConfiguration(), cacheConf, fs).withOutputDir(hfilePath).withFileContext(hFileContext).build();
        DefaultMemStore memstore = new DefaultMemStore();
        TestReversibleScanners.writeMemstoreAndStoreFiles((MemStore)memstore, new StoreFileWriter[]{writer1, writer2});
        HStoreFile sf1 = new HStoreFile(fs, writer1.getPath(), this.TEST_UTIL.getConfiguration(), cacheConf, BloomType.NONE, true);
        HStoreFile sf2 = new HStoreFile(fs, writer2.getPath(), this.TEST_UTIL.getConfiguration(), cacheConf, BloomType.NONE, true);
        int startRowNum = 100;
        ReversedKeyValueHeap kvHeap = this.getReversibleKeyValueHeap((MemStore)memstore, sf1, sf2, ROWS[startRowNum], MAXMVCC);
        this.internalTestSeekAndNextForReversibleKeyValueHeap(kvHeap, startRowNum);
        startRowNum = 199;
        kvHeap = this.getReversibleKeyValueHeap((MemStore)memstore, sf1, sf2, HConstants.EMPTY_START_ROW, MAXMVCC);
        this.internalTestSeekAndNextForReversibleKeyValueHeap(kvHeap, startRowNum);
        block0: for (int readPoint = 0; readPoint < MAXMVCC; ++readPoint) {
            LOG.info("Setting read point to " + readPoint);
            startRowNum = 199;
            kvHeap = this.getReversibleKeyValueHeap((MemStore)memstore, sf1, sf2, HConstants.EMPTY_START_ROW, readPoint);
            for (int i = startRowNum; i >= 0 && i - 2 >= 0; --i) {
                kvHeap.seekToPreviousRow((Cell)KeyValueUtil.createFirstOnRow((byte[])ROWS[(i -= 2) + 1]));
                Pair<Integer, Integer> nextReadableNum = this.getNextReadableNumWithBackwardScan(i, 0, readPoint);
                if (nextReadableNum == null) continue block0;
                KeyValue expecedKey = TestReversibleScanners.makeKV((Integer)nextReadableNum.getFirst(), (Integer)nextReadableNum.getSecond());
                Assert.assertEquals((Object)expecedKey, (Object)kvHeap.peek());
                i = (Integer)nextReadableNum.getFirst();
                int qualNum = (Integer)nextReadableNum.getSecond();
                if (qualNum + 1 < 5) {
                    kvHeap.backwardSeek((Cell)TestReversibleScanners.makeKV(i, qualNum + 1));
                    nextReadableNum = this.getNextReadableNumWithBackwardScan(i, qualNum + 1, readPoint);
                    if (nextReadableNum == null) continue block0;
                    expecedKey = TestReversibleScanners.makeKV((Integer)nextReadableNum.getFirst(), (Integer)nextReadableNum.getSecond());
                    Assert.assertEquals((Object)expecedKey, (Object)kvHeap.peek());
                    i = (Integer)nextReadableNum.getFirst();
                    qualNum = (Integer)nextReadableNum.getSecond();
                }
                kvHeap.next();
                nextReadableNum = qualNum + 1 >= 5 ? this.getNextReadableNumWithBackwardScan(i - 1, 0, readPoint) : this.getNextReadableNumWithBackwardScan(i, qualNum + 1, readPoint);
                if (nextReadableNum == null) continue block0;
                expecedKey = TestReversibleScanners.makeKV((Integer)nextReadableNum.getFirst(), (Integer)nextReadableNum.getSecond());
                Assert.assertEquals((Object)expecedKey, (Object)kvHeap.peek());
                i = (Integer)nextReadableNum.getFirst();
            }
        }
    }

    @Test
    public void testReversibleStoreScanner() throws IOException {
        FileSystem fs = this.TEST_UTIL.getTestFileSystem();
        Path hfilePath = new Path(new Path(this.TEST_UTIL.getDataTestDir("testReversibleStoreScanner"), "regionname"), "familyname");
        CacheConfig cacheConf = new CacheConfig(this.TEST_UTIL.getConfiguration());
        HFileContextBuilder hcBuilder = new HFileContextBuilder();
        hcBuilder.withBlockSize(2048);
        HFileContext hFileContext = hcBuilder.build();
        StoreFileWriter writer1 = new StoreFileWriter.Builder(this.TEST_UTIL.getConfiguration(), cacheConf, fs).withOutputDir(hfilePath).withFileContext(hFileContext).build();
        StoreFileWriter writer2 = new StoreFileWriter.Builder(this.TEST_UTIL.getConfiguration(), cacheConf, fs).withOutputDir(hfilePath).withFileContext(hFileContext).build();
        DefaultMemStore memstore = new DefaultMemStore();
        TestReversibleScanners.writeMemstoreAndStoreFiles((MemStore)memstore, new StoreFileWriter[]{writer1, writer2});
        HStoreFile sf1 = new HStoreFile(fs, writer1.getPath(), this.TEST_UTIL.getConfiguration(), cacheConf, BloomType.NONE, true);
        HStoreFile sf2 = new HStoreFile(fs, writer2.getPath(), this.TEST_UTIL.getConfiguration(), cacheConf, BloomType.NONE, true);
        ScanInfo scanInfo = new ScanInfo(this.TEST_UTIL.getConfiguration(), FAMILYNAME, 0, Integer.MAX_VALUE, Long.MAX_VALUE, KeepDeletedCells.FALSE, 65536L, 0L, (CellComparator)CellComparatorImpl.COMPARATOR, false);
        Scan scan = new Scan();
        scan.setReversed(true);
        StoreScanner storeScanner = this.getReversibleStoreScanner((MemStore)memstore, sf1, sf2, scan, scanInfo, MAXMVCC);
        this.verifyCountAndOrder((InternalScanner)storeScanner, 1000, 200, false);
        int startRowNum = 100;
        byte[] startRow = ROWS[startRowNum];
        scan.withStartRow(startRow);
        storeScanner = this.getReversibleStoreScanner((MemStore)memstore, sf1, sf2, scan, scanInfo, MAXMVCC);
        this.verifyCountAndOrder((InternalScanner)storeScanner, 5 * (startRowNum + 1), startRowNum + 1, false);
        Assert.assertTrue((boolean)true);
        scan.addColumn(FAMILYNAME, QUALS[0]);
        scan.addColumn(FAMILYNAME, QUALS[2]);
        storeScanner = this.getReversibleStoreScanner((MemStore)memstore, sf1, sf2, scan, scanInfo, MAXMVCC);
        this.verifyCountAndOrder((InternalScanner)storeScanner, 2 * (startRowNum + 1), startRowNum + 1, false);
        for (int readPoint = 0; readPoint < MAXMVCC; ++readPoint) {
            LOG.info("Setting read point to " + readPoint);
            storeScanner = this.getReversibleStoreScanner((MemStore)memstore, sf1, sf2, scan, scanInfo, readPoint);
            int expectedRowCount = 0;
            int expectedKVCount = 0;
            for (int i = startRowNum; i >= 0; --i) {
                int kvCount = 0;
                if (TestReversibleScanners.makeMVCC(i, 0) <= (long)readPoint) {
                    ++kvCount;
                }
                if (TestReversibleScanners.makeMVCC(i, 2) <= (long)readPoint) {
                    ++kvCount;
                }
                if (kvCount <= 0) continue;
                ++expectedRowCount;
                expectedKVCount += kvCount;
            }
            this.verifyCountAndOrder((InternalScanner)storeScanner, expectedKVCount, expectedRowCount, false);
        }
    }

    @Test
    public void testReversibleRegionScanner() throws IOException {
        byte[][] specifiedQualifiers;
        byte[] FAMILYNAME2 = Bytes.toBytes((String)"testCf2");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName())).addFamily(new HColumnDescriptor(FAMILYNAME)).addFamily(new HColumnDescriptor(FAMILYNAME2));
        HRegion region = this.TEST_UTIL.createLocalHRegion((TableDescriptor)htd, null, null);
        TestReversibleScanners.loadDataToRegion(region, FAMILYNAME2);
        Scan scan = new Scan();
        HRegion.RegionScannerImpl scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, 2000, 200, true);
        scan.setReversed(true);
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, 2000, 200, false);
        scan = new Scan();
        scan.setReversed(true);
        scan.addFamily(FAMILYNAME);
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, 1000, 200, false);
        for (byte[] specifiedQualifier : specifiedQualifiers = new byte[][]{QUALS[1], QUALS[2]}) {
            scan.addColumn(FAMILYNAME, specifiedQualifier);
        }
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, 400, 200, false);
        for (byte[] specifiedQualifier : specifiedQualifiers) {
            scan.addColumn(FAMILYNAME2, specifiedQualifier);
        }
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, 800, 200, false);
        int startRowNum = 150;
        scan.withStartRow(ROWS[startRowNum]);
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, (startRowNum + 1) * 2 * 2, startRowNum + 1, false);
        int stopRowNum = 50;
        scan.withStartRow(HConstants.EMPTY_BYTE_ARRAY);
        scan.withStopRow(ROWS[stopRowNum]);
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, (200 - stopRowNum - 1) * 2 * 2, 200 - stopRowNum - 1, false);
        scan.withStartRow(ROWS[startRowNum]);
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, (startRowNum - stopRowNum) * 2 * 2, startRowNum - stopRowNum, false);
        int valueNum = startRowNum % 3;
        SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILYNAME, specifiedQualifiers[0], CompareFilter.CompareOp.EQUAL, VALUES[valueNum]);
        scan.setFilter((Filter)filter);
        scanner = region.getScanner(scan);
        int unfilteredRowNum = (startRowNum - stopRowNum) / 3 + (stopRowNum / 3 == valueNum ? 0 : 1);
        this.verifyCountAndOrder((InternalScanner)scanner, unfilteredRowNum * 2 * 2, unfilteredRowNum, false);
        int pageSize = 10;
        filter = new PageFilter((long)pageSize);
        scan.setFilter((Filter)filter);
        scanner = region.getScanner(scan);
        int expectedRowNum = pageSize;
        this.verifyCountAndOrder((InternalScanner)scanner, expectedRowNum * 2 * 2, expectedRowNum, false);
        SingleColumnValueFilter scvFilter1 = new SingleColumnValueFilter(FAMILYNAME, specifiedQualifiers[0], CompareFilter.CompareOp.EQUAL, VALUES[0]);
        SingleColumnValueFilter scvFilter2 = new SingleColumnValueFilter(FAMILYNAME, specifiedQualifiers[0], CompareFilter.CompareOp.EQUAL, VALUES[1]);
        expectedRowNum = 0;
        for (int i = startRowNum; i > stopRowNum; --i) {
            if (i % 3 != 0 && i % 3 != 1) continue;
            ++expectedRowNum;
        }
        filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, new Filter[]{scvFilter1, scvFilter2});
        scan.setFilter((Filter)filter);
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, expectedRowNum * 2 * 2, expectedRowNum, false);
        filter = new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{scvFilter1, scvFilter2});
        expectedRowNum = 0;
        scan.setFilter((Filter)filter);
        scanner = region.getScanner(scan);
        this.verifyCountAndOrder((InternalScanner)scanner, expectedRowNum * 2 * 2, expectedRowNum, false);
    }

    private StoreScanner getReversibleStoreScanner(MemStore memstore, HStoreFile sf1, HStoreFile sf2, Scan scan, ScanInfo scanInfo, int readPoint) throws IOException {
        List<KeyValueScanner> scanners = this.getScanners(memstore, sf1, sf2, null, false, readPoint);
        NavigableSet columns = null;
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            columns = (NavigableSet)entry.getValue();
        }
        ReversedStoreScanner storeScanner = new ReversedStoreScanner(scan, scanInfo, columns, scanners);
        return storeScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyCountAndOrder(InternalScanner scanner, int expectedKVCount, int expectedRowCount, boolean forward) throws IOException {
        ArrayList kvList = new ArrayList();
        Result lastResult = null;
        int rowCount = 0;
        int kvCount = 0;
        try {
            while (scanner.next(kvList)) {
                if (kvList.isEmpty()) continue;
                ++rowCount;
                kvCount += kvList.size();
                if (lastResult != null) {
                    Result curResult = Result.create(kvList);
                    Assert.assertEquals((String)("LastResult:" + lastResult + "CurResult:" + curResult), (Object)forward, (Object)(Bytes.compareTo((byte[])curResult.getRow(), (byte[])lastResult.getRow()) > 0 ? 1 : 0));
                }
                lastResult = Result.create(kvList);
                kvList.clear();
            }
        }
        finally {
            scanner.close();
        }
        if (!kvList.isEmpty()) {
            ++rowCount;
            kvCount += kvList.size();
            kvList.clear();
        }
        Assert.assertEquals((long)expectedKVCount, (long)kvCount);
        Assert.assertEquals((long)expectedRowCount, (long)rowCount);
    }

    private void internalTestSeekAndNextForReversibleKeyValueHeap(ReversedKeyValueHeap kvHeap, int startRowNum) throws IOException {
        for (int i = startRowNum; i >= 0; --i) {
            if (i % 2 == 1 && i - 2 >= 0) {
                kvHeap.seekToPreviousRow((Cell)KeyValueUtil.createFirstOnRow((byte[])ROWS[(i -= 2) + 1]));
            }
            for (int j = 0; j < 5; ++j) {
                if (j % 2 == 1 && j + 1 < 5) {
                    kvHeap.backwardSeek((Cell)TestReversibleScanners.makeKV(i, ++j));
                }
                Assert.assertEquals((Object)TestReversibleScanners.makeKV(i, j), (Object)kvHeap.peek());
                kvHeap.next();
            }
        }
        Assert.assertEquals(null, (Object)kvHeap.peek());
    }

    private ReversedKeyValueHeap getReversibleKeyValueHeap(MemStore memstore, HStoreFile sf1, HStoreFile sf2, byte[] startRow, int readPoint) throws IOException {
        List<KeyValueScanner> scanners = this.getScanners(memstore, sf1, sf2, startRow, true, readPoint);
        ReversedKeyValueHeap kvHeap = new ReversedKeyValueHeap(scanners, (CellComparator)CellComparatorImpl.COMPARATOR);
        return kvHeap;
    }

    private List<KeyValueScanner> getScanners(MemStore memstore, HStoreFile sf1, HStoreFile sf2, byte[] startRow, boolean doSeek, int readPoint) throws IOException {
        ArrayList<KeyValueScanner> scanners;
        block4: {
            List fileScanners = StoreFileScanner.getScannersForStoreFiles((Collection)Lists.newArrayList((Object[])new HStoreFile[]{sf1, sf2}), (boolean)false, (boolean)true, (boolean)false, (boolean)false, (long)readPoint);
            List memScanners = memstore.getScanners((long)readPoint);
            scanners = new ArrayList<KeyValueScanner>(fileScanners.size() + 1);
            scanners.addAll(fileScanners);
            scanners.addAll(memScanners);
            if (!doSeek) break block4;
            if (Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])startRow)) {
                for (KeyValueScanner scanner : scanners) {
                    scanner.seekToLastRow();
                }
            } else {
                KeyValue startKey = KeyValueUtil.createFirstOnRow((byte[])startRow);
                for (KeyValueScanner scanner : scanners) {
                    scanner.backwardSeek((Cell)startKey);
                }
            }
        }
        return scanners;
    }

    private void seekTestOfReversibleKeyValueScanner(KeyValueScanner scanner) throws IOException {
        Assert.assertTrue((boolean)scanner.seekToLastRow());
        Assert.assertEquals((Object)TestReversibleScanners.makeKV(199, 0), (Object)scanner.peek());
        KeyValue seekKey = TestReversibleScanners.makeKV(198, 3);
        Assert.assertTrue((boolean)scanner.backwardSeek((Cell)seekKey));
        Assert.assertEquals((Object)seekKey, (Object)scanner.peek());
        int seekRowNum = 198;
        Assert.assertTrue((boolean)scanner.backwardSeek((Cell)KeyValueUtil.createLastOnRow((byte[])ROWS[seekRowNum])));
        KeyValue expectedKey = TestReversibleScanners.makeKV(seekRowNum - 1, 0);
        Assert.assertEquals((Object)expectedKey, (Object)scanner.peek());
        Assert.assertFalse((boolean)scanner.backwardSeek((Cell)KeyValueUtil.createLastOnRow((byte[])ROWS[0])));
        Assert.assertEquals(null, (Object)scanner.peek());
        seekRowNum = 196;
        Assert.assertTrue((boolean)scanner.seekToPreviousRow((Cell)KeyValueUtil.createFirstOnRow((byte[])ROWS[seekRowNum])));
        expectedKey = TestReversibleScanners.makeKV(seekRowNum - 1, 0);
        Assert.assertEquals((Object)expectedKey, (Object)scanner.peek());
        Assert.assertFalse((boolean)scanner.seekToPreviousRow((Cell)TestReversibleScanners.makeKV(0, 0)));
        Assert.assertEquals(null, (Object)scanner.peek());
    }

    private void seekTestOfReversibleKeyValueScannerWithMVCC(List<? extends KeyValueScanner> scanners, int readPoint) throws IOException {
        KeyValue expectedKey = this.getNextReadableKeyValueWithBackwardScan(199, 0, readPoint);
        boolean res = false;
        for (KeyValueScanner keyValueScanner : scanners) {
            res |= keyValueScanner.seekToLastRow();
        }
        Assert.assertEquals((Object)(expectedKey != null ? 1 : 0), (Object)res);
        res = false;
        for (KeyValueScanner keyValueScanner : scanners) {
            res |= expectedKey.equals((Object)keyValueScanner.peek());
        }
        Assert.assertTrue((boolean)res);
        expectedKey = this.getNextReadableKeyValueWithBackwardScan(198, 3, readPoint);
        res = false;
        for (KeyValueScanner keyValueScanner : scanners) {
            res |= keyValueScanner.backwardSeek((Cell)expectedKey);
        }
        Assert.assertEquals((Object)(expectedKey != null ? 1 : 0), (Object)res);
        res = false;
        for (KeyValueScanner keyValueScanner : scanners) {
            res |= expectedKey.equals((Object)keyValueScanner.peek());
        }
        Assert.assertTrue((boolean)res);
        int seekRowNum = 197;
        res = false;
        for (KeyValueScanner keyValueScanner : scanners) {
            res |= keyValueScanner.backwardSeek((Cell)expectedKey);
        }
        res = false;
        for (KeyValueScanner keyValueScanner : scanners) {
            res |= expectedKey.equals((Object)keyValueScanner.peek());
        }
        Assert.assertTrue((boolean)res);
        seekRowNum = 196;
        expectedKey = this.getNextReadableKeyValueWithBackwardScan(seekRowNum - 1, 0, readPoint);
        res = false;
        for (KeyValueScanner keyValueScanner : scanners) {
            res |= keyValueScanner.seekToPreviousRow((Cell)KeyValueUtil.createFirstOnRow((byte[])ROWS[seekRowNum]));
        }
        Assert.assertEquals((Object)(expectedKey != null ? 1 : 0), (Object)res);
        res = false;
        for (KeyValueScanner keyValueScanner : scanners) {
            res |= expectedKey.equals((Object)keyValueScanner.peek());
        }
        Assert.assertTrue((boolean)res);
    }

    private KeyValue getNextReadableKeyValueWithBackwardScan(int startRowNum, int startQualNum, int readPoint) {
        Pair<Integer, Integer> nextReadableNum = this.getNextReadableNumWithBackwardScan(startRowNum, startQualNum, readPoint);
        if (nextReadableNum == null) {
            return null;
        }
        return TestReversibleScanners.makeKV((Integer)nextReadableNum.getFirst(), (Integer)nextReadableNum.getSecond());
    }

    private Pair<Integer, Integer> getNextReadableNumWithBackwardScan(int startRowNum, int startQualNum, int readPoint) {
        Pair nextReadableNum = null;
        boolean findExpected = false;
        for (int i = startRowNum; i >= 0; --i) {
            int j;
            int n = j = i == startRowNum ? startQualNum : 0;
            while (j < 5) {
                if (TestReversibleScanners.makeMVCC(i, j) <= (long)readPoint) {
                    nextReadableNum = new Pair((Object)i, (Object)j);
                    findExpected = true;
                    break;
                }
                ++j;
            }
            if (findExpected) break;
        }
        return nextReadableNum;
    }

    private static void loadDataToRegion(HRegion region, byte[] additionalFamily) throws IOException {
        for (int i = 0; i < 200; ++i) {
            Put put = new Put(ROWS[i]);
            for (int j = 0; j < 5; ++j) {
                put.add((Cell)TestReversibleScanners.makeKV(i, j));
                put.add((Cell)TestReversibleScanners.makeKV(i, j, additionalFamily));
            }
            region.put(put);
            if (i != 66 && i != 133) continue;
            region.flush(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMemstoreAndStoreFiles(MemStore memstore, StoreFileWriter[] writers) throws IOException {
        int i;
        try {
            for (i = 0; i < 200; ++i) {
                for (int j = 0; j < 5; ++j) {
                    if (i % 2 == 0) {
                        memstore.add((Cell)TestReversibleScanners.makeKV(i, j), null);
                        continue;
                    }
                    writers[(i + j) % writers.length].append((Cell)TestReversibleScanners.makeKV(i, j));
                }
            }
        }
        finally {
            for (i = 0; i < writers.length; ++i) {
                writers[i].close();
            }
        }
    }

    private static void writeStoreFile(StoreFileWriter writer) throws IOException {
        try {
            for (int i = 0; i < 200; ++i) {
                for (int j = 0; j < 5; ++j) {
                    writer.append((Cell)TestReversibleScanners.makeKV(i, j));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    private static void writeMemstore(MemStore memstore) throws IOException {
        int j;
        int i;
        for (i = 0; i < 200; ++i) {
            for (j = 0; j < 5; ++j) {
                if ((i + j) % 2 != 0) continue;
                memstore.add((Cell)TestReversibleScanners.makeKV(i, j), null);
            }
        }
        memstore.snapshot();
        for (i = 0; i < 200; ++i) {
            for (j = 0; j < 5; ++j) {
                if ((i + j) % 2 != 1) continue;
                memstore.add((Cell)TestReversibleScanners.makeKV(i, j), null);
            }
        }
    }

    private static KeyValue makeKV(int rowNum, int cqNum) {
        return TestReversibleScanners.makeKV(rowNum, cqNum, FAMILYNAME);
    }

    private static KeyValue makeKV(int rowNum, int cqNum, byte[] familyName) {
        KeyValue kv = new KeyValue(ROWS[rowNum], familyName, QUALS[cqNum], TS, VALUES[rowNum % 3]);
        kv.setSequenceId(TestReversibleScanners.makeMVCC(rowNum, cqNum));
        return kv;
    }

    private static long makeMVCC(int rowNum, int cqNum) {
        return (rowNum + cqNum) % (MAXMVCC + 1);
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])Bytes.toBytes((String)String.format("%04d", i)));
        }
        return ret;
    }
}

