/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import ch.cern.hbase.thirdparty.io.netty.channel.Channel;
import ch.cern.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;

class CustomAsyncFSWAL
extends AsyncFSWAL {
    private Boolean syncFlag;
    private Boolean writerSyncFlag;

    public CustomAsyncFSWAL(FileSystem fs, Path rootDir, String logDir, Configuration conf, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws FailedLogCloseException, IOException {
        super(fs, rootDir, logDir, "oldWALs", conf, null, true, null, null, eventLoopGroup, channelClass);
    }

    protected WALProvider.AsyncWriter createWriterInstance(Path path) throws IOException {
        final WALProvider.AsyncWriter writer = super.createWriterInstance(path);
        return new WALProvider.AsyncWriter(){

            public void close() throws IOException {
                writer.close();
            }

            public long getLength() {
                return writer.getLength();
            }

            public CompletableFuture<Long> sync(boolean forceSync) {
                CustomAsyncFSWAL.this.writerSyncFlag = forceSync;
                return writer.sync(forceSync);
            }

            public void append(WAL.Entry entry) {
                writer.append(entry);
            }
        };
    }

    public void sync(boolean forceSync) throws IOException {
        this.syncFlag = forceSync;
        super.sync(forceSync);
    }

    public void sync(long txid, boolean forceSync) throws IOException {
        this.syncFlag = forceSync;
        super.sync(txid, forceSync);
    }

    void resetSyncFlag() {
        this.syncFlag = null;
        this.writerSyncFlag = null;
    }

    Boolean getSyncFlag() {
        return this.syncFlag;
    }

    Boolean getWriterSyncFlag() {
        return this.writerSyncFlag;
    }
}

