/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import ch.cern.hbase.thirdparty.io.netty.channel.Channel;
import ch.cern.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import ch.cern.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import ch.cern.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestWALReplay;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestAsyncWALReplay
extends AbstractTestWALReplay {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncWALReplay.class);
    private static EventLoopGroup GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        GROUP = new NioEventLoopGroup(1, Threads.newDaemonThreadFactory((String)"TestAsyncWALReplay"));
        CHANNEL_CLASS = NioSocketChannel.class;
        Configuration conf = AbstractTestWALReplay.TEST_UTIL.getConfiguration();
        conf.set("hbase.wal.provider", "asyncfs");
        AbstractTestWALReplay.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractTestWALReplay.tearDownAfterClass();
        GROUP.shutdownGracefully();
    }

    @Override
    protected WAL createWAL(Configuration c, Path hbaseRootDir, String logName) throws IOException {
        AsyncFSWAL asyncFSWAL = new AsyncFSWAL(FileSystem.get((Configuration)c), hbaseRootDir, logName, "oldWALs", c, null, true, null, null, GROUP, CHANNEL_CLASS);
        asyncFSWAL.init();
        return asyncFSWAL;
    }
}

