/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import ch.cern.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.SerialReplicationTestBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestAddToSerialReplicationPeer
extends SerialReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAddToSerialReplicationPeer.class);

    @Before
    public void setUp() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.setupWALWriter();
    }

    private void moveRegionAndArchiveOldWals(RegionInfo region, HRegionServer rs) throws Exception {
        TestAddToSerialReplicationPeer.moveRegion(region, rs);
        TestAddToSerialReplicationPeer.rollAllWALs();
    }

    private void waitUntilReplicatedToTheCurrentWALFile(final HRegionServer rs) throws Exception {
        Path path = ((AbstractFSWAL)rs.getWAL(null)).getCurrentFileName();
        final String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName((String)path.getName());
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                ReplicationSourceManager manager = ((Replication)rs.getReplicationSourceService()).getReplicationManager();
                return ((NavigableSet)((Map)manager.getWALs().get(SerialReplicationTestBase.PEER_ID)).get(logPrefix)).size() == 1;
            }

            public String explainFailure() throws Exception {
                return "Still not replicated to the current WAL file yet";
            }
        });
    }

    @Test
    public void testAddPeer() throws Exception {
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        RegionInfo region = (RegionInfo)UTIL.getAdmin().getRegions(tableName).get(0);
        HRegionServer rs = UTIL.getOtherRegionServer(UTIL.getRSForFirstRegionInTable(tableName));
        this.moveRegionAndArchiveOldWals(region, rs);
        this.addPeer(true);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.waitUntilReplicationDone(100);
        this.checkOrder(100);
    }

    @Test
    public void testChangeToSerial() throws Exception {
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey("127.0.0.1:2181:/hbase").setReplicationEndpointImpl(SerialReplicationTestBase.LocalReplicationEndpoint.class.getName()).build();
        UTIL.getAdmin().addReplicationPeer(PEER_ID, peerConfig, true);
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        RegionInfo region = (RegionInfo)UTIL.getAdmin().getRegions(tableName).get(0);
        HRegionServer srcRs = UTIL.getRSForFirstRegionInTable(tableName);
        HRegionServer rs = UTIL.getOtherRegionServer(srcRs);
        this.moveRegionAndArchiveOldWals(region, rs);
        this.waitUntilReplicationDone(100);
        this.waitUntilReplicatedToTheCurrentWALFile(srcRs);
        UTIL.getAdmin().disableReplicationPeer(PEER_ID);
        UTIL.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)peerConfig).setSerial(true).build());
        UTIL.getAdmin().enableReplicationPeer(PEER_ID);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.waitUntilReplicationDone(200);
        this.checkOrder(200);
    }

    @Test
    public void testAddToSerialPeer() throws Exception {
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey("127.0.0.1:2181:/hbase").setReplicationEndpointImpl(SerialReplicationTestBase.LocalReplicationEndpoint.class.getName()).setReplicateAllUserTables(false).setSerial(true).build();
        UTIL.getAdmin().addReplicationPeer(PEER_ID, peerConfig, true);
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        RegionInfo region = (RegionInfo)UTIL.getAdmin().getRegions(tableName).get(0);
        HRegionServer srcRs = UTIL.getRSForFirstRegionInTable(tableName);
        HRegionServer rs = UTIL.getOtherRegionServer(srcRs);
        this.moveRegionAndArchiveOldWals(region, rs);
        this.waitUntilReplicatedToTheCurrentWALFile(rs);
        UTIL.getAdmin().disableReplicationPeer(PEER_ID);
        UTIL.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)peerConfig).setTableCFsMap((Map)ImmutableMap.of((Object)tableName, Collections.emptyList())).build());
        UTIL.getAdmin().enableReplicationPeer(PEER_ID);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.waitUntilReplicationDone(100);
        this.checkOrder(100);
    }

    @Test
    public void testDisabledTable() throws Exception {
        int i;
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        UTIL.getAdmin().disableTable(tableName);
        TestAddToSerialReplicationPeer.rollAllWALs();
        this.addPeer(true);
        UTIL.getAdmin().enableTable(tableName);
        table = UTIL.getConnection().getTable(tableName);
        var3_3 = null;
        try {
            for (i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var3_3 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
        this.waitUntilReplicationDone(100);
        this.checkOrder(100);
    }

    @Test
    public void testDisablingTable() throws Exception {
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        UTIL.getAdmin().disableTable(tableName);
        TestAddToSerialReplicationPeer.rollAllWALs();
        TableStateManager tsm = UTIL.getMiniHBaseCluster().getMaster().getTableStateManager();
        tsm.setTableState(tableName, TableState.State.DISABLING);
        Thread t = new Thread(() -> {
            try {
                this.addPeer(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        t.start();
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)t.isAlive());
        tsm.setTableState(tableName, TableState.State.DISABLED);
        t.join();
        UTIL.getAdmin().enableTable(tableName);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.waitUntilReplicationDone(100);
        this.checkOrder(100);
    }

    @Test
    public void testEnablingTable() throws Exception {
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        RegionInfo region = (RegionInfo)UTIL.getAdmin().getRegions(tableName).get(0);
        HRegionServer rs = UTIL.getOtherRegionServer(UTIL.getRSForFirstRegionInTable(tableName));
        this.moveRegionAndArchiveOldWals(region, rs);
        TableStateManager tsm = UTIL.getMiniHBaseCluster().getMaster().getTableStateManager();
        tsm.setTableState(tableName, TableState.State.ENABLING);
        Thread t = new Thread(() -> {
            try {
                this.addPeer(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        t.start();
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)t.isAlive());
        tsm.setTableState(tableName, TableState.State.ENABLED);
        t.join();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.waitUntilReplicationDone(100);
        this.checkOrder(100);
    }
}

