/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import ch.cern.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.SerialReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestRemoveFromSerialReplicationPeer
extends SerialReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRemoveFromSerialReplicationPeer.class);

    @Before
    public void setUp() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.setupWALWriter();
    }

    private void waitUntilHasLastPushedSequenceId(final RegionInfo region) throws Exception {
        final ReplicationQueueStorage queueStorage = UTIL.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage();
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return queueStorage.getLastSequenceId(region.getEncodedName(), SerialReplicationTestBase.PEER_ID) > 0L;
            }

            public String explainFailure() throws Exception {
                return "Still no last pushed sequence id for " + region;
            }
        });
    }

    @Test
    public void testRemoveTable() throws Exception {
        TableName tableName = this.createTable();
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey("127.0.0.1:2181:/hbase").setReplicationEndpointImpl(SerialReplicationTestBase.LocalReplicationEndpoint.class.getName()).setReplicateAllUserTables(false).setTableCFsMap((Map)ImmutableMap.of((Object)tableName, Collections.emptyList())).setSerial(true).build();
        UTIL.getAdmin().addReplicationPeer(PEER_ID, peerConfig, true);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(tableName).get(0).getRegionInfo();
        this.waitUntilHasLastPushedSequenceId(region);
        UTIL.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)peerConfig).setTableCFsMap(Collections.emptyMap()).build());
        ReplicationQueueStorage queueStorage = UTIL.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage();
        Assert.assertEquals((long)-1L, (long)queueStorage.getLastSequenceId(region.getEncodedName(), PEER_ID));
    }

    @Test
    public void testRemoveSerialFlag() throws Exception {
        TableName tableName = this.createTable();
        this.addPeer(true);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(tableName).get(0).getRegionInfo();
        this.waitUntilHasLastPushedSequenceId(region);
        UTIL.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)UTIL.getAdmin().getReplicationPeerConfig(PEER_ID)).setSerial(false).build());
        this.waitUntilReplicationDone(100);
        ReplicationQueueStorage queueStorage = UTIL.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage();
        Assert.assertEquals((long)-1L, (long)queueStorage.getLastSequenceId(region.getEncodedName(), PEER_ID));
    }
}

