/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import ch.cern.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.util.MultiThreadedAction;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.ProcessBasedLocalHBaseCluster;
import org.apache.hadoop.hbase.util.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartMetaTest
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(RestartMetaTest.class);
    private static final int DEFAULT_NUM_RS = 2;
    private static TableName TABLE_NAME = TableName.valueOf((String)"load_test");
    private static final int SLEEP_SEC_AFTER_DATA_LOAD = 5;
    private int numRegionServers;
    private static final String OPT_NUM_RS = "num_rs";
    private static final int NUM_DATANODES = 3;

    private void loadData() throws IOException {
        long startKey = 0L;
        long endKey = 100000L;
        int minColsPerKey = 5;
        int maxColsPerKey = 15;
        int minColDataSize = 256;
        int maxColDataSize = 768;
        int numThreads = 10;
        System.out.printf("Key range %d .. %d\n", startKey, endKey);
        System.out.printf("Number of Columns/Key: %d..%d\n", minColsPerKey, maxColsPerKey);
        System.out.printf("Data Size/Column: %d..%d bytes\n", minColDataSize, maxColDataSize);
        System.out.printf("Client Threads: %d\n", numThreads);
        MultiThreadedAction.DefaultDataGenerator dataGen = new MultiThreadedAction.DefaultDataGenerator(minColDataSize, maxColDataSize, minColsPerKey, maxColsPerKey, (byte[][])new byte[][]{HFileTestUtil.DEFAULT_COLUMN_FAMILY});
        MultiThreadedWriter writer = new MultiThreadedWriter(dataGen, this.conf, TABLE_NAME);
        writer.setMultiPut(true);
        writer.start(startKey, endKey, numThreads);
        System.out.printf("Started loading data...", new Object[0]);
        writer.waitForFinish();
        System.out.printf("Finished loading data...", new Object[0]);
    }

    protected int doWork() throws Exception {
        Result result;
        ProcessBasedLocalHBaseCluster hbaseCluster = new ProcessBasedLocalHBaseCluster(this.conf, 3, this.numRegionServers);
        hbaseCluster.startMiniDFS();
        hbaseCluster.startHBase();
        HBaseTestingUtility.createPreSplitLoadTestTable(this.conf, TABLE_NAME, HFileTestUtil.DEFAULT_COLUMN_FAMILY, Compression.Algorithm.NONE, DataBlockEncoding.NONE);
        LOG.debug("Loading data....\n\n");
        this.loadData();
        LOG.debug("Sleeping for 5 seconds....\n\n");
        Threads.sleep((long)25L);
        Connection connection = ConnectionFactory.createConnection((Configuration)this.conf);
        int metaRSPort = HBaseTestingUtility.getMetaRSPort(connection);
        LOG.debug("Killing hbase:meta region server running on port " + metaRSPort);
        hbaseCluster.killRegionServer(metaRSPort);
        Threads.sleep((long)2000L);
        LOG.debug("Restarting region server running on port metaRSPort");
        hbaseCluster.startRegionServer(metaRSPort);
        Threads.sleep((long)2000L);
        LOG.debug("Trying to scan meta");
        Table metaTable = connection.getTable(TableName.META_TABLE_NAME);
        ResultScanner scanner = metaTable.getScanner(new Scan());
        while ((result = scanner.next()) != null) {
            LOG.info("Region assignment from META: " + Bytes.toStringBinary((byte[])result.getRow()) + " => " + Bytes.toStringBinary((byte[])((byte[])result.getFamilyMap(HConstants.CATALOG_FAMILY).get(HConstants.SERVER_QUALIFIER))));
        }
        metaTable.close();
        connection.close();
        return 0;
    }

    protected void addOptions() {
        this.addOptWithArg(OPT_NUM_RS, "Number of Region Servers");
        this.addOptWithArg(HFileTestUtil.OPT_DATA_BLOCK_ENCODING, HFileTestUtil.OPT_DATA_BLOCK_ENCODING_USAGE);
    }

    protected void processOptions(CommandLine cmd) {
        this.numRegionServers = Integer.parseInt(cmd.getOptionValue(OPT_NUM_RS, String.valueOf(2)));
    }

    public static void main(String[] args) {
        new RestartMetaTest().doStaticMain(args);
    }
}

