/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import ch.cern.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestHBaseFsckCleanReplicationBarriers {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseFsckCleanReplicationBarriers.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static String PEER_1 = "1";
    private static String PEER_2 = "2";
    private static ReplicationQueueStorage QUEUE_STORAGE;
    private static String WAL_FILE_NAME;
    private static String TABLE_NAME;
    private static String COLUMN_FAMILY;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        QUEUE_STORAGE = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)UTIL.getZooKeeperWatcher(), (Configuration)UTIL.getConfiguration());
        TestHBaseFsckCleanReplicationBarriers.createPeer();
        QUEUE_STORAGE.addWAL(UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName(), PEER_1, WAL_FILE_NAME);
        QUEUE_STORAGE.addWAL(UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName(), PEER_2, WAL_FILE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCleanReplicationBarrierWithNonExistTable() throws ClassNotFoundException, IOException {
        TableName tableName = TableName.valueOf((String)(TABLE_NAME + "_non"));
        boolean cleaned = HbckTestingUtil.cleanReplicationBarrier(UTIL.getConfiguration(), tableName);
        Assert.assertFalse((boolean)cleaned);
    }

    @Test
    public void testCleanReplicationBarrierWithDeletedTable() throws Exception {
        TableName tableName = TableName.valueOf((String)(TABLE_NAME + "_deleted"));
        ArrayList<RegionInfo> regionInfos = new ArrayList<RegionInfo>();
        for (int i = 0; i < 110; ++i) {
            RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build();
            regionInfos.add(regionInfo);
            this.addStateAndBarrier(regionInfo, RegionState.State.OPEN, 10L, 100L);
            this.updatePushedSeqId(regionInfo, 10L);
            Assert.assertEquals((String)"check if there is lastPushedId", (long)10L, (long)QUEUE_STORAGE.getLastSequenceId(regionInfo.getEncodedName(), PEER_1));
            Assert.assertEquals((String)"check if there is lastPushedId", (long)10L, (long)QUEUE_STORAGE.getLastSequenceId(regionInfo.getEncodedName(), PEER_2));
        }
        Scan barrierScan = new Scan();
        barrierScan.setCaching(100);
        barrierScan.addFamily(HConstants.REPLICATION_BARRIER_FAMILY);
        barrierScan.withStartRow(MetaTableAccessor.getTableStartRowForMeta((TableName)tableName, (MetaTableAccessor.QueryType)MetaTableAccessor.QueryType.REGION)).withStopRow(MetaTableAccessor.getTableStopRowForMeta((TableName)tableName, (MetaTableAccessor.QueryType)MetaTableAccessor.QueryType.REGION));
        ResultScanner scanner = MetaTableAccessor.getMetaHTable((Connection)UTIL.getConnection()).getScanner(barrierScan);
        Iterator iterator = null;
        try {
            Result result;
            while ((result = scanner.next()) != null) {
                Assert.assertTrue((MetaTableAccessor.getReplicationBarriers((Result)result).length > 0 ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (iterator != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        boolean cleaned = HbckTestingUtil.cleanReplicationBarrier(UTIL.getConfiguration(), tableName);
        Assert.assertTrue((boolean)cleaned);
        for (RegionInfo regionInfo : regionInfos) {
            Assert.assertEquals((String)"check if there is lastPushedId", (long)-1L, (long)QUEUE_STORAGE.getLastSequenceId(regionInfo.getEncodedName(), PEER_1));
            Assert.assertEquals((String)"check if there is lastPushedId", (long)-1L, (long)QUEUE_STORAGE.getLastSequenceId(regionInfo.getEncodedName(), PEER_2));
        }
        cleaned = HbckTestingUtil.cleanReplicationBarrier(UTIL.getConfiguration(), tableName);
        Assert.assertFalse((boolean)cleaned);
        for (RegionInfo region : regionInfos) {
            Assert.assertEquals((long)0L, (long)MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region.getRegionName()).length);
        }
    }

    @Test
    public void testCleanReplicationBarrierWithExistTable() throws Exception {
        TableName tableName = TableName.valueOf((String)TABLE_NAME);
        String cf = COLUMN_FAMILY;
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)cf)).build()).setReplicationScope(0).build();
        UTIL.createTable(tableDescriptor, Bytes.split((byte[])Bytes.toBytes((int)1), (byte[])Bytes.toBytes((int)256), (int)123));
        Assert.assertTrue((UTIL.getAdmin().getRegions(tableName).size() > 0 ? 1 : 0) != 0);
        for (RegionInfo region : UTIL.getAdmin().getRegions(tableName)) {
            this.addStateAndBarrier(region, RegionState.State.OFFLINE, 10L, 100L);
            this.updatePushedSeqId(region, 10L);
            Assert.assertEquals((String)"check if there is lastPushedId", (long)10L, (long)QUEUE_STORAGE.getLastSequenceId(region.getEncodedName(), PEER_1));
            Assert.assertEquals((String)"check if there is lastPushedId", (long)10L, (long)QUEUE_STORAGE.getLastSequenceId(region.getEncodedName(), PEER_2));
        }
        boolean cleaned = HbckTestingUtil.cleanReplicationBarrier(UTIL.getConfiguration(), tableName);
        Assert.assertTrue((boolean)cleaned);
        for (RegionInfo region : UTIL.getAdmin().getRegions(tableName)) {
            Assert.assertEquals((String)"check if there is lastPushedId", (long)-1L, (long)QUEUE_STORAGE.getLastSequenceId(region.getEncodedName(), PEER_1));
            Assert.assertEquals((String)"check if there is lastPushedId", (long)-1L, (long)QUEUE_STORAGE.getLastSequenceId(region.getEncodedName(), PEER_2));
        }
        cleaned = HbckTestingUtil.cleanReplicationBarrier(UTIL.getConfiguration(), tableName);
        Assert.assertFalse((boolean)cleaned);
        for (RegionInfo region : UTIL.getAdmin().getRegions(tableName)) {
            Assert.assertEquals((long)0L, (long)MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region.getRegionName()).length);
        }
    }

    public static void createPeer() throws IOException {
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getClusterKey()).setSerial(true).build();
        UTIL.getAdmin().addReplicationPeer(PEER_1, rpc);
        UTIL.getAdmin().addReplicationPeer(PEER_2, rpc);
    }

    private void addStateAndBarrier(RegionInfo region, RegionState.State state, long ... barriers) throws IOException {
        Put put = new Put(region.getRegionName(), EnvironmentEdgeManager.currentTime());
        if (state != null) {
            put.addColumn(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes((String)state.name()));
        }
        for (int i = 0; i < barriers.length; ++i) {
            put.addColumn(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER, put.getTimeStamp() - (long)barriers.length + (long)i, Bytes.toBytes((long)barriers[i]));
        }
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
    }

    private void updatePushedSeqId(RegionInfo region, long seqId) throws ReplicationException {
        QUEUE_STORAGE.setWALPosition(UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName(), PEER_1, WAL_FILE_NAME, 10L, (Map)ImmutableMap.of((Object)region.getEncodedName(), (Object)seqId));
        QUEUE_STORAGE.setWALPosition(UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName(), PEER_2, WAL_FILE_NAME, 10L, (Map)ImmutableMap.of((Object)region.getEncodedName(), (Object)seqId));
    }

    static {
        WAL_FILE_NAME = "test.wal";
        TABLE_NAME = "test";
        COLUMN_FAMILY = "info";
    }
}

