/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import ch.cern.hbase.thirdparty.io.netty.channel.Channel;
import ch.cern.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.NettyAsyncFSWALConfigHelper;
import org.apache.hadoop.hbase.wal.WALCorruptionDueToDanglingByteBufferTestBase;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestAsyncFSWALCorruptionDueToDanglingByteBuffer
extends WALCorruptionDueToDanglingByteBufferTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncFSWALCorruptionDueToDanglingByteBuffer.class);

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.wal.provider", PauseWALProvider.class, WALProvider.class);
        UTIL.startMiniCluster(1);
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    public static final class PauseWALProvider
    extends AbstractFSWALProvider<PauseWAL> {
        private EventLoopGroup eventLoopGroup;
        private Class<? extends Channel> channelClass;

        protected PauseWAL createWAL() throws IOException {
            return new PauseWAL(CommonFSUtils.getWALFileSystem((Configuration)this.conf), CommonFSUtils.getWALRootDir((Configuration)this.conf), PauseWALProvider.getWALDirectoryName((String)this.factory.factoryId), PauseWALProvider.getWALArchiveDirectoryName((Configuration)this.conf, (String)this.factory.factoryId), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? ".meta" : null, this.eventLoopGroup, this.channelClass);
        }

        protected void doInit(Configuration conf) throws IOException {
            Pair eventLoopGroupAndChannelClass = NettyAsyncFSWALConfigHelper.getEventLoopConfig((Configuration)conf);
            this.eventLoopGroup = (EventLoopGroup)eventLoopGroupAndChannelClass.getFirst();
            this.channelClass = (Class)eventLoopGroupAndChannelClass.getSecond();
        }
    }

    public static final class PauseWAL
    extends AsyncFSWAL {
        public PauseWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws FailedLogCloseException, IOException {
            super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, eventLoopGroup, channelClass);
        }

        protected void atHeadOfRingBufferEventHandlerAppend() {
            if (WALCorruptionDueToDanglingByteBufferTestBase.ARRIVE != null) {
                WALCorruptionDueToDanglingByteBufferTestBase.ARRIVE.countDown();
                try {
                    WALCorruptionDueToDanglingByteBufferTestBase.RESUME.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

