/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface SplitLogManagerCoordination {
    public void setDetails(SplitLogManagerDetails var1);

    public SplitLogManagerDetails getDetails();

    public String prepareTask(String var1);

    public void checkTasks();

    public int remainingTasksInCoordination();

    public void checkTaskStillAvailable(String var1);

    public boolean resubmitTask(String var1, SplitLogManager.Task var2, SplitLogManager.ResubmitDirective var3);

    public void submitTask(String var1);

    public void deleteTask(String var1);

    @VisibleForTesting
    public void init() throws IOException;

    public static class SplitLogManagerDetails {
        private final ConcurrentMap<String, SplitLogManager.Task> tasks;
        private final MasterServices master;
        private final Set<String> failedDeletions;

        public SplitLogManagerDetails(ConcurrentMap<String, SplitLogManager.Task> tasks, MasterServices master, Set<String> failedDeletions) {
            this.tasks = tasks;
            this.master = master;
            this.failedDeletions = failedDeletions;
        }

        public MasterServices getMaster() {
            return this.master;
        }

        public ConcurrentMap<String, SplitLogManager.Task> getTasks() {
            return this.tasks;
        }

        public Set<String> getFailedDeletions() {
            return this.failedDeletions;
        }

        public ServerName getServerName() {
            return this.master.getServerName();
        }
    }
}

