/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import ch.cern.hbase.thirdparty.io.netty.buffer.ByteBuf;
import ch.cern.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import ch.cern.hbase.thirdparty.io.netty.channel.ChannelInboundHandlerAdapter;
import ch.cern.hbase.thirdparty.io.netty.channel.group.ChannelGroup;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerRequestDecoder
extends ChannelInboundHandlerAdapter {
    private final ChannelGroup allChannels;
    private final MetricsHBaseServer metrics;
    private NettyServerRpcConnection connection;

    public NettyRpcServerRequestDecoder(ChannelGroup allChannels, MetricsHBaseServer metrics) {
        this.allChannels = allChannels;
        this.metrics = metrics;
    }

    void setConnection(NettyServerRpcConnection connection) {
        this.connection = connection;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.add((Object)ctx.channel());
        NettyRpcServer.LOG.trace("Connection {}; # active connections={}", (Object)ctx.channel().remoteAddress(), (Object)(this.allChannels.size() - 1));
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf input = (ByteBuf)msg;
        this.metrics.receivedBytes(input.readableBytes() + 4);
        this.connection.process(input);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.remove((Object)ctx.channel());
        NettyRpcServer.LOG.trace("Disconnection {}; # active connections={}", (Object)ctx.channel().remoteAddress(), (Object)(this.allChannels.size() - 1));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        this.allChannels.remove((Object)ctx.channel());
        NettyRpcServer.LOG.trace("Connection {}; caught unexpected downstream exception.", (Object)ctx.channel().remoteAddress(), (Object)e.getCause());
        ctx.channel().close();
    }
}

