/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import ch.cern.hbase.thirdparty.com.google.protobuf.RpcController;
import ch.cern.hbase.thirdparty.com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class AssignmentManagerUtil {
    private static final int DEFAULT_REGION_REPLICA = 1;

    private AssignmentManagerUtil() {
    }

    static AdminProtos.GetRegionInfoResponse getRegionInfoResponse(MasterProcedureEnv env, ServerName regionLocation, RegionInfo hri) throws IOException {
        return AssignmentManagerUtil.getRegionInfoResponse(env, regionLocation, hri, false);
    }

    static AdminProtos.GetRegionInfoResponse getRegionInfoResponse(MasterProcedureEnv env, ServerName regionLocation, RegionInfo hri, boolean includeBestSplitRow) throws IOException {
        HBaseRpcController controller = env.getMasterServices().getClusterConnection().getRpcControllerFactory().newController();
        AdminProtos.AdminService.BlockingInterface admin = env.getMasterServices().getClusterConnection().getAdmin(regionLocation);
        AdminProtos.GetRegionInfoRequest request = null;
        request = includeBestSplitRow ? RequestConverter.buildGetRegionInfoRequest((byte[])hri.getRegionName(), (boolean)false, (boolean)true) : RequestConverter.buildGetRegionInfoRequest((byte[])hri.getRegionName());
        try {
            return admin.getRegionInfo((RpcController)controller, request);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    private static void lock(List<RegionStateNode> regionNodes) {
        regionNodes.iterator().forEachRemaining(RegionStateNode::lock);
    }

    private static void unlock(List<RegionStateNode> regionNodes) {
        ListIterator<RegionStateNode> iter = regionNodes.listIterator(regionNodes.size());
        while (iter.hasPrevious()) {
            iter.previous().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TransitRegionStateProcedure[] createUnassignProceduresForSplitOrMerge(MasterProcedureEnv env, Stream<RegionInfo> regions, int regionReplication) throws IOException {
        RegionStateNode regionNode;
        int i;
        List<RegionStateNode> regionNodes = regions.flatMap(hri -> IntStream.range(0, regionReplication).mapToObj(i -> RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)i))).map(env.getAssignmentManager().getRegionStates()::getOrCreateRegionStateNode).collect(Collectors.toList());
        TransitRegionStateProcedure[] procs = new TransitRegionStateProcedure[regionNodes.size()];
        boolean rollback = true;
        AssignmentManagerUtil.lock(regionNodes);
        try {
            for (i = 0; i < procs.length; ++i) {
                regionNode = regionNodes.get(i);
                TransitRegionStateProcedure proc = TransitRegionStateProcedure.unassign(env, regionNode.getRegionInfo());
                if (regionNode.getProcedure() != null) {
                    throw new HBaseIOException("The parent region " + regionNode + " is currently in transition, give up");
                }
                regionNode.setProcedure(proc);
                procs[i] = proc;
            }
            rollback = false;
        }
        finally {
            if (rollback) {
                while (--i >= 0) {
                    regionNode = regionNodes.get(i);
                    regionNode.unsetProcedure(procs[i]);
                }
            }
            AssignmentManagerUtil.unlock(regionNodes);
        }
        return procs;
    }

    private static TransitRegionStateProcedure[] createAssignProcedures(MasterProcedureEnv env, List<RegionInfo> regions, int regionReplication, ServerName targetServer, boolean ignoreIfInTransition) {
        Object[] primaryRegionProcs = (TransitRegionStateProcedure[])regions.stream().map(env.getAssignmentManager().getRegionStates()::getOrCreateRegionStateNode).map(regionNode -> {
            TransitRegionStateProcedure proc = TransitRegionStateProcedure.assign(env, regionNode.getRegionInfo(), targetServer);
            regionNode.lock();
            try {
                if (ignoreIfInTransition) {
                    if (regionNode.isInTransition()) {
                        TransitRegionStateProcedure transitRegionStateProcedure = null;
                        return transitRegionStateProcedure;
                    }
                } else assert (!regionNode.isInTransition());
                regionNode.setProcedure(proc);
            }
            finally {
                regionNode.unlock();
            }
            return proc;
        }).filter(p -> p != null).toArray(TransitRegionStateProcedure[]::new);
        if (regionReplication == 1) {
            return primaryRegionProcs;
        }
        ArrayList<RegionInfo> replicaRegionInfos = new ArrayList<RegionInfo>(regions.size() * (regionReplication - 1));
        for (RegionInfo hri : regions) {
            for (int i = 1; i < regionReplication; ++i) {
                replicaRegionInfos.add(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)i));
            }
        }
        Object[] replicaRegionAssignProcs = env.getAssignmentManager().createRoundRobinAssignProcedures(replicaRegionInfos, Collections.singletonList(targetServer));
        return (TransitRegionStateProcedure[])ArrayUtils.addAll((Object[])primaryRegionProcs, (Object[])replicaRegionAssignProcs);
    }

    static TransitRegionStateProcedure[] createAssignProceduresForOpeningNewRegions(MasterProcedureEnv env, List<RegionInfo> regions, int regionReplication, ServerName targetServer) {
        return AssignmentManagerUtil.createAssignProcedures(env, regions, regionReplication, targetServer, false);
    }

    static void reopenRegionsForRollback(MasterProcedureEnv env, List<RegionInfo> regions, int regionReplication, ServerName targetServer) {
        TransitRegionStateProcedure[] procs = AssignmentManagerUtil.createAssignProcedures(env, regions, regionReplication, targetServer, true);
        if (procs.length > 0) {
            env.getMasterServices().getMasterProcedureExecutor().submitProcedures((Procedure[])procs);
        }
    }

    static void removeNonDefaultReplicas(MasterProcedureEnv env, Stream<RegionInfo> regions, int regionReplication) {
        regions.flatMap(hri -> IntStream.range(1, regionReplication).mapToObj(i -> RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)i))).forEach(hri -> {
            env.getAssignmentManager().getRegionStates().deleteRegion((RegionInfo)hri);
            env.getMasterServices().getServerManager().removeRegion((RegionInfo)hri);
            FavoredNodesManager fnm = env.getMasterServices().getFavoredNodesManager();
            if (fnm != null) {
                fnm.deleteFavoredNodesForRegions(Collections.singletonList(hri));
            }
        });
    }

    static void checkClosedRegion(MasterProcedureEnv env, RegionInfo regionInfo) throws IOException {
        if (WALSplitUtil.hasRecoveredEdits(env.getMasterConfiguration(), regionInfo)) {
            throw new IOException("Recovered.edits are found in Region: " + regionInfo + ", abort split/merge to prevent data loss");
        }
    }
}

