/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.yetus.audience.InterfaceAudience;

@Deprecated
@InterfaceAudience.Private
public abstract class RegionTransitionProcedure
extends Procedure<MasterProcedureEnv>
implements TableProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    protected final AtomicBoolean aborted = new AtomicBoolean(false);
    private MasterProcedureProtos.RegionTransitionState transitionState = MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_QUEUE;
    private RegionInfo regionInfo;
    private int attempt;

    public RegionTransitionProcedure() {
    }

    public RegionTransitionProcedure(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    @VisibleForTesting
    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    protected void setRegionInfo(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    protected void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    protected int getAttempt() {
        return this.attempt;
    }

    @Override
    public TableName getTableName() {
        RegionInfo hri = this.getRegionInfo();
        return hri != null ? hri.getTable() : null;
    }

    public boolean isMeta() {
        return TableName.isMetaTableName((TableName)this.getTableName());
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", region=");
        sb.append(this.getRegionInfo() == null ? null : this.getRegionInfo().getEncodedName());
    }

    public RegionStateNode getRegionState(MasterProcedureEnv env) {
        return env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegionInfo());
    }

    void setTransitionState(MasterProcedureProtos.RegionTransitionState state) {
        this.transitionState = state;
    }

    MasterProcedureProtos.RegionTransitionState getTransitionState() {
        return this.transitionState;
    }

    protected abstract boolean startTransition(MasterProcedureEnv var1, RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract boolean updateTransition(MasterProcedureEnv var1, RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract void finishTransition(MasterProcedureEnv var1, RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract void reportTransition(MasterProcedureEnv var1, RegionStateNode var2, RegionServerStatusProtos.RegionStateTransition.TransitionCode var3, long var4) throws UnexpectedStateException;

    public abstract Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv var1, ServerName var2);

    protected abstract boolean remoteCallFailed(MasterProcedureEnv var1, RegionStateNode var2, IOException var3);

    public synchronized void remoteCallFailed(MasterProcedureEnv env, ServerName serverName, IOException exception) {
    }

    protected void toStringState(StringBuilder builder) {
        super.toStringState(builder);
        MasterProcedureProtos.RegionTransitionState ts = this.transitionState;
        if (!this.isFinished() && ts != null) {
            builder.append(":").append(ts);
        }
    }

    protected Procedure[] execute(MasterProcedureEnv env) {
        return null;
    }

    protected void rollback(MasterProcedureEnv env) {
    }

    protected abstract boolean isRollbackSupported(MasterProcedureProtos.RegionTransitionState var1);

    protected boolean abort(MasterProcedureEnv env) {
        if (this.isRollbackSupported(this.transitionState)) {
            this.aborted.set(true);
            return true;
        }
        return false;
    }

    public void remoteOperationCompleted(MasterProcedureEnv env) {
        throw new UnsupportedOperationException();
    }

    public void remoteOperationFailed(MasterProcedureEnv env, RemoteProcedureException error) {
        throw new UnsupportedOperationException();
    }
}

