/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import ch.cern.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractStateMachineRegionProcedure<TState>
extends AbstractStateMachineTableProcedure<TState> {
    private RegionInfo hri;

    protected AbstractStateMachineRegionProcedure(MasterProcedureEnv env, RegionInfo hri) {
        super(env);
        this.hri = hri;
    }

    protected AbstractStateMachineRegionProcedure() {
    }

    public RegionInfo getRegion() {
        return this.hri;
    }

    protected void setRegion(RegionInfo hri) {
        this.hri = hri;
    }

    @Override
    public TableName getTableName() {
        return this.getRegion().getTable();
    }

    @Override
    public abstract TableProcedureInterface.TableOperationType getTableOperationType();

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        super.toStringClassDetails(sb);
        sb.append(", region=").append(this.getRegion().getShortNameToLog());
    }

    @Override
    protected void checkTableModifiable(MasterProcedureEnv env) throws IOException {
        if (!MetaTableAccessor.tableExists((Connection)env.getMasterServices().getConnection(), (TableName)this.getTableName())) {
            throw new TableNotFoundException(this.getTableName());
        }
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitRegions((Procedure<?>)this, this.getTableName(), this.getRegion())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeRegions((Procedure<?>)this, this.getTableName(), this.getRegion());
    }

    protected void setFailure(Throwable cause) {
        super.setFailure(this.getClass().getSimpleName(), cause);
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)ProtobufUtil.toRegionInfo((RegionInfo)this.getRegion()));
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        this.hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)((HBaseProtos.RegionInfo)serializer.deserialize(HBaseProtos.RegionInfo.class)));
    }
}

