/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SnapshotFileCache
implements Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotFileCache.class);
    private volatile boolean stop = false;
    private final FileSystem fs;
    private final SnapshotFileInspector fileInspector;
    private final Path snapshotDir;
    private final Set<String> cache = new HashSet<String>();
    private final Map<String, SnapshotDirectoryInfo> snapshots = new HashMap<String, SnapshotDirectoryInfo>();
    private final Timer refreshTimer;

    public SnapshotFileCache(Configuration conf, long cacheRefreshPeriod, String refreshThreadName, SnapshotFileInspector inspectSnapshotFiles) throws IOException {
        this(FSUtils.getCurrentFileSystem((Configuration)conf), FSUtils.getRootDir((Configuration)conf), 0L, cacheRefreshPeriod, refreshThreadName, inspectSnapshotFiles);
    }

    public SnapshotFileCache(FileSystem fs, Path rootDir, long cacheRefreshPeriod, long cacheRefreshDelay, String refreshThreadName, SnapshotFileInspector inspectSnapshotFiles) {
        this.fs = fs;
        this.fileInspector = inspectSnapshotFiles;
        this.snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(rootDir);
        this.refreshTimer = new Timer(refreshThreadName, true);
        this.refreshTimer.scheduleAtFixedRate((TimerTask)new RefreshCacheTask(), cacheRefreshDelay, cacheRefreshPeriod);
    }

    public synchronized void triggerCacheRefreshForTesting() {
        try {
            this.refreshCache();
        }
        catch (IOException e) {
            LOG.warn("Failed to refresh snapshot hfile cache!", (Throwable)e);
        }
        LOG.debug("Current cache:" + this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Iterable<FileStatus> getUnreferencedFiles(Iterable<FileStatus> files, SnapshotManager snapshotManager) throws IOException {
        ArrayList unReferencedFiles = Lists.newArrayList();
        boolean refreshed = false;
        Lock lock = null;
        if (snapshotManager != null) {
            lock = snapshotManager.getTakingSnapshotLock().writeLock();
        }
        if (lock == null || lock.tryLock()) {
            try {
                if (snapshotManager != null && snapshotManager.isTakingAnySnapshot()) {
                    LOG.warn("Not checking unreferenced files since snapshot is running, it will skip to clean the HFiles this time");
                    ArrayList arrayList = unReferencedFiles;
                    return arrayList;
                }
                for (FileStatus file : files) {
                    String fileName = file.getPath().getName();
                    if (!refreshed && !this.cache.contains(fileName)) {
                        this.refreshCache();
                        refreshed = true;
                    }
                    if (this.cache.contains(fileName)) continue;
                    unReferencedFiles.add(file);
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        return unReferencedFiles;
    }

    private void refreshCache() throws IOException {
        Object[] snapshotDirs = FSUtils.listStatus((FileSystem)this.fs, (Path)this.snapshotDir, p -> !p.getName().equals(".tmp"));
        this.cache.clear();
        if (ArrayUtils.isEmpty((Object[])snapshotDirs)) {
            if (LOG.isDebugEnabled() && this.snapshots.size() > 0) {
                LOG.debug("No snapshots on-disk, clear cache");
            }
            this.snapshots.clear();
            return;
        }
        HashMap<String, SnapshotDirectoryInfo> newSnapshots = new HashMap<String, SnapshotDirectoryInfo>();
        for (Object snapshotDir : snapshotDirs) {
            String name = snapshotDir.getPath().getName();
            SnapshotDirectoryInfo files = this.snapshots.remove(name);
            if (files == null || files.hasBeenModified(snapshotDir.getModificationTime())) {
                Collection<String> storedFiles = this.fileInspector.filesUnderSnapshot(snapshotDir.getPath());
                files = new SnapshotDirectoryInfo(snapshotDir.getModificationTime(), storedFiles);
            }
            this.cache.addAll(files.getFiles());
            newSnapshots.put(name, files);
        }
        this.snapshots.clear();
        this.snapshots.putAll(newSnapshots);
    }

    public void stop(String why) {
        if (!this.stop) {
            this.stop = true;
            this.refreshTimer.cancel();
        }
    }

    public boolean isStopped() {
        return this.stop;
    }

    private static class SnapshotDirectoryInfo {
        long lastModified;
        Collection<String> files;

        public SnapshotDirectoryInfo(long mtime, Collection<String> files) {
            this.lastModified = mtime;
            this.files = files;
        }

        public Collection<String> getFiles() {
            return this.files;
        }

        public boolean hasBeenModified(long mtime) {
            return this.lastModified < mtime;
        }
    }

    public class RefreshCacheTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SnapshotFileCache snapshotFileCache = SnapshotFileCache.this;
            synchronized (snapshotFileCache) {
                try {
                    SnapshotFileCache.this.refreshCache();
                }
                catch (IOException e) {
                    LOG.warn("Failed to refresh snapshot hfile cache!", (Throwable)e);
                    SnapshotFileCache.this.cache.clear();
                    SnapshotFileCache.this.snapshots.clear();
                }
            }
        }
    }

    static interface SnapshotFileInspector {
        public Collection<String> filesUnderSnapshot(Path var1) throws IOException;
    }
}

