/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import ch.cern.hbase.thirdparty.com.google.common.base.Charsets;
import ch.cern.hbase.thirdparty.com.google.common.base.Preconditions;
import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MemoryBoundedLogMessageBuffer {
    private final long maxSizeBytes;
    private long usage = 0L;
    private LinkedList<LogMessage> messages;

    public MemoryBoundedLogMessageBuffer(long maxSizeBytes) {
        Preconditions.checkArgument((maxSizeBytes > 0L ? 1 : 0) != 0);
        this.maxSizeBytes = maxSizeBytes;
        this.messages = Lists.newLinkedList();
    }

    public synchronized void add(String messageText) {
        LogMessage message = new LogMessage(messageText, System.currentTimeMillis());
        this.usage += message.estimateHeapUsage();
        this.messages.add(message);
        while (this.usage > this.maxSizeBytes) {
            LogMessage removed = this.messages.remove();
            this.usage -= removed.estimateHeapUsage();
            assert (this.usage >= 0L);
        }
    }

    public synchronized void dumpTo(PrintWriter out) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        for (LogMessage msg : this.messages) {
            out.write(df.format(new Date(msg.timestamp)));
            out.write(" ");
            out.println(new String(msg.message, Charsets.UTF_8));
        }
    }

    synchronized List<LogMessage> getMessages() {
        return Lists.newArrayList(this.messages);
    }

    synchronized long estimateHeapUsage() {
        return this.usage;
    }

    private static class LogMessage {
        public final byte[] message;
        public final long timestamp;
        private static final long BASE_USAGE = 100L;

        public LogMessage(String message, long timestamp) {
            this.message = message.getBytes(Charsets.UTF_8);
            this.timestamp = timestamp;
        }

        public long estimateHeapUsage() {
            return (long)this.message.length + 100L;
        }
    }
}

