/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import ch.cern.hbase.thirdparty.com.google.common.collect.MapMaker;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.procedure.SubprocedureFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProcedureMember
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureMember.class);
    static final long KEEP_ALIVE_MILLIS_DEFAULT = 5000L;
    private final SubprocedureFactory builder;
    private final ProcedureMemberRpcs rpcs;
    private final ConcurrentMap<String, Subprocedure> subprocs = new MapMaker().concurrencyLevel(4).weakValues().makeMap();
    private final ExecutorService pool;

    public ProcedureMember(ProcedureMemberRpcs rpcs, ThreadPoolExecutor pool, SubprocedureFactory factory) {
        this.pool = pool;
        this.rpcs = rpcs;
        this.builder = factory;
    }

    public static ThreadPoolExecutor defaultPool(String memberName, int procThreads) {
        return ProcedureMember.defaultPool(memberName, procThreads, 5000L);
    }

    public static ThreadPoolExecutor defaultPool(String memberName, int procThreads, long keepAliveMillis) {
        return new ThreadPoolExecutor(1, procThreads, keepAliveMillis, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("member: '" + memberName + "' subprocedure-pool"));
    }

    ProcedureMemberRpcs getRpcs() {
        return this.rpcs;
    }

    public Subprocedure createSubprocedure(String opName, byte[] data) {
        return this.builder.buildSubprocedure(opName, data);
    }

    public boolean submitSubprocedure(Subprocedure subproc) {
        if (subproc == null) {
            LOG.warn("Submitted null subprocedure, nothing to run here.");
            return false;
        }
        String procName = subproc.getName();
        if (procName == null || procName.length() == 0) {
            LOG.error("Subproc name cannot be null or the empty string");
            return false;
        }
        Subprocedure rsub = (Subprocedure)this.subprocs.get(procName);
        if (rsub != null) {
            if (!rsub.isComplete()) {
                LOG.error("Subproc '" + procName + "' is already running. Bailing out");
                return false;
            }
            LOG.warn("A completed old subproc " + procName + " is still present, removing");
            if (!this.subprocs.remove(procName, rsub)) {
                LOG.error("Another thread has replaced existing subproc '" + procName + "'. Bailing out");
                return false;
            }
        }
        LOG.debug("Submitting new Subprocedure:" + procName);
        try {
            if (this.subprocs.putIfAbsent(procName, subproc) == null) {
                this.pool.submit(subproc);
                return true;
            }
            LOG.error("Another thread has submitted subproc '" + procName + "'. Bailing out");
            return false;
        }
        catch (RejectedExecutionException e) {
            this.subprocs.remove(procName, subproc);
            String msg = "Subprocedure pool is full!";
            subproc.cancel(msg, e.getCause());
            LOG.error("Failed to start subprocedure '" + procName + "'");
            return false;
        }
    }

    public void receivedReachedGlobalBarrier(String procName) {
        Subprocedure subproc = (Subprocedure)this.subprocs.get(procName);
        if (subproc == null) {
            LOG.warn("Unexpected reached globa barrier message for Sub-Procedure '" + procName + "'");
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("reached global barrier message for Sub-Procedure '" + procName + "'");
        }
        subproc.receiveReachedGlobalBarrier();
    }

    @Override
    public void close() throws IOException {
        this.pool.shutdownNow();
    }

    boolean closeAndWait(long timeoutMs) throws InterruptedException {
        this.pool.shutdown();
        return this.pool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void controllerConnectionFailure(String message, Throwable cause, String procName) {
        LOG.error(message, cause);
        if (procName == null) {
            return;
        }
        Subprocedure toNotify = (Subprocedure)this.subprocs.get(procName);
        if (toNotify != null) {
            toNotify.cancel(message, cause);
        }
    }

    public void receiveAbortProcedure(String procName, ForeignException ee) {
        LOG.debug("Request received to abort procedure " + procName, (Throwable)ee);
        Subprocedure sub = (Subprocedure)this.subprocs.get(procName);
        if (sub == null) {
            LOG.info("Received abort on procedure with no local subprocedure " + procName + ", ignoring it.", (Throwable)ee);
            return;
        }
        String msg = "Propagating foreign exception to subprocedure " + sub.getName();
        LOG.error(msg, (Throwable)ee);
        sub.cancel(msg, ee);
    }
}

