/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import ch.cern.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServicesForStores {
    private final HRegion region;
    private final RegionServerServices rsServices;
    private int inMemoryPoolSize;
    private static ThreadPoolExecutor INMEMORY_COMPACTION_POOL_FOR_TEST;

    public RegionServicesForStores(HRegion region, RegionServerServices rsServices) {
        this.region = region;
        this.rsServices = rsServices;
        if (this.rsServices != null) {
            this.inMemoryPoolSize = rsServices.getConfiguration().getInt("hbase.regionserver.inmemory.compaction.pool.size", 10);
        }
    }

    public void addMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta, int cellsCountDelta) {
        this.region.incMemStoreSize(dataSizeDelta, heapSizeDelta, offHeapSizeDelta, cellsCountDelta);
    }

    public RegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    public WAL getWAL() {
        return this.region.getWAL();
    }

    private static synchronized ThreadPoolExecutor getInMemoryCompactionPoolForTest() {
        if (INMEMORY_COMPACTION_POOL_FOR_TEST == null) {
            INMEMORY_COMPACTION_POOL_FOR_TEST = new ThreadPoolExecutor(10, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("InMemoryCompactionsForTest-%d").build());
        }
        return INMEMORY_COMPACTION_POOL_FOR_TEST;
    }

    ThreadPoolExecutor getInMemoryCompactionPool() {
        if (this.rsServices != null) {
            return this.rsServices.getExecutorService().getExecutorLazily(ExecutorType.RS_IN_MEMORY_COMPACTION, this.inMemoryPoolSize);
        }
        return RegionServicesForStores.getInMemoryCompactionPoolForTest();
    }

    public long getMemStoreFlushSize() {
        return this.region.getMemStoreFlushSize();
    }

    public int getNumStores() {
        return this.region.getTableDescriptor().getColumnFamilyCount();
    }

    @VisibleForTesting
    long getMemStoreSize() {
        return this.region.getMemStoreDataSize();
    }
}

