/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import ch.cern.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.procedure2.RSProcedureCallable;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitWALCallable
implements RSProcedureCallable {
    private static final Logger LOG = LoggerFactory.getLogger(SplitWALCallable.class);
    private String walPath;
    private Exception initError;
    private HRegionServer rs;
    private final KeyLocker<String> splitWALLocks = new KeyLocker();
    private volatile Lock splitWALLock = null;

    @Override
    public void init(byte[] parameter, HRegionServer rs) {
        try {
            this.rs = rs;
            MasterProcedureProtos.SplitWALParameter param = MasterProcedureProtos.SplitWALParameter.parseFrom((byte[])parameter);
            this.walPath = param.getWalPath();
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("parse proto buffer of split WAL request failed ", (Throwable)e);
            this.initError = e;
        }
    }

    @Override
    public EventType getEventType() {
        return EventType.RS_LOG_REPLAY;
    }

    @Override
    public Void call() throws Exception {
        if (this.initError != null) {
            throw this.initError;
        }
        this.splitWALLock = this.splitWALLocks.acquireLock((Object)this.walPath);
        try {
            this.splitWal();
            LOG.info("split WAL {} succeed.", (Object)this.walPath);
        }
        catch (IOException e) {
            LOG.warn("failed to split WAL {}.", (Object)this.walPath, (Object)e);
            throw e;
        }
        finally {
            this.splitWALLock.unlock();
        }
        return null;
    }

    public String getWalPath() {
        return this.walPath;
    }

    private void splitWal() throws IOException {
        SplitLogWorker.TaskExecutor.Status status = SplitLogWorker.splitLog(this.walPath, null, this.rs.getConfiguration(), this.rs, this.rs, this.rs.walFactory);
        if (status != SplitLogWorker.TaskExecutor.Status.DONE) {
            throw new IOException("Split WAL " + this.walPath + " failed at server ");
        }
    }
}

