/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Phoenix"})
@InterfaceStability.Evolving
public class StoreFileReader {
    private static final Logger LOG = LoggerFactory.getLogger((String)StoreFileReader.class.getName());
    protected BloomFilter generalBloomFilter = null;
    protected BloomFilter deleteFamilyBloomFilter = null;
    protected BloomType bloomFilterType;
    private final HFile.Reader reader;
    protected long sequenceID = -1L;
    protected TimeRange timeRange = null;
    private byte[] lastBloomKey;
    private long deleteFamilyCnt = -1L;
    private boolean bulkLoadResult = false;
    private KeyValue.KeyOnlyKeyValue lastBloomKeyOnlyKV = null;
    private boolean skipResetSeqId = true;
    private int prefixLength = -1;
    private final AtomicInteger refCount;
    @VisibleForTesting
    final boolean shared;

    private StoreFileReader(HFile.Reader reader, AtomicInteger refCount, boolean shared) {
        this.reader = reader;
        this.bloomFilterType = BloomType.NONE;
        this.refCount = refCount;
        this.shared = shared;
    }

    public StoreFileReader(FileSystem fs, Path path, CacheConfig cacheConf, boolean primaryReplicaStoreFile, AtomicInteger refCount, boolean shared, Configuration conf) throws IOException {
        this(HFile.createReader(fs, path, cacheConf, primaryReplicaStoreFile, conf), refCount, shared);
    }

    public StoreFileReader(FileSystem fs, Path path, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, boolean primaryReplicaStoreFile, AtomicInteger refCount, boolean shared, Configuration conf) throws IOException {
        this(HFile.createReader(fs, path, in, size, cacheConf, primaryReplicaStoreFile, conf), refCount, shared);
    }

    void copyFields(StoreFileReader reader) {
        this.generalBloomFilter = reader.generalBloomFilter;
        this.deleteFamilyBloomFilter = reader.deleteFamilyBloomFilter;
        this.bloomFilterType = reader.bloomFilterType;
        this.sequenceID = reader.sequenceID;
        this.timeRange = reader.timeRange;
        this.lastBloomKey = reader.lastBloomKey;
        this.bulkLoadResult = reader.bulkLoadResult;
        this.lastBloomKeyOnlyKV = reader.lastBloomKeyOnlyKV;
        this.skipResetSeqId = reader.skipResetSeqId;
        this.prefixLength = reader.prefixLength;
    }

    public boolean isPrimaryReplicaReader() {
        return this.reader.isPrimaryReplicaReader();
    }

    @VisibleForTesting
    StoreFileReader() {
        this.refCount = new AtomicInteger(0);
        this.reader = null;
        this.shared = false;
    }

    public CellComparator getComparator() {
        return this.reader.getComparator();
    }

    public StoreFileScanner getStoreFileScanner(boolean cacheBlocks, boolean pread, boolean isCompaction, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) {
        return new StoreFileScanner(this, this.getScanner(cacheBlocks, pread, isCompaction), !isCompaction, this.reader.hasMVCCInfo(), readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    int getRefCount() {
        return this.refCount.get();
    }

    void incrementRefCount() {
        this.refCount.incrementAndGet();
    }

    void readCompleted() {
        this.refCount.decrementAndGet();
        if (!this.shared) {
            try {
                this.reader.close(false);
            }
            catch (IOException e) {
                LOG.warn("failed to close stream reader", (Throwable)e);
            }
        }
    }

    @Deprecated
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread) {
        return this.getScanner(cacheBlocks, pread, false);
    }

    @Deprecated
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
        return this.reader.getScanner(cacheBlocks, pread, isCompaction);
    }

    public void close(boolean evictOnClose) throws IOException {
        this.reader.close(evictOnClose);
    }

    boolean passesTimerangeFilter(TimeRange tr, long oldestUnexpiredTS) {
        return this.timeRange == null ? true : this.timeRange.includesTimeRange(tr) && this.timeRange.getMax() >= oldestUnexpiredTS;
    }

    boolean passesBloomFilter(Scan scan, SortedSet<byte[]> columns) {
        byte[] row = scan.getStartRow();
        switch (this.bloomFilterType) {
            case ROW: {
                if (!scan.isGetScan()) {
                    return true;
                }
                return this.passesGeneralRowBloomFilter(row, 0, row.length);
            }
            case ROWCOL: {
                if (!scan.isGetScan()) {
                    return true;
                }
                if (columns != null && columns.size() == 1) {
                    byte[] column = columns.first();
                    Cell kvKey = PrivateCellUtil.createFirstOnRow((byte[])row, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])column);
                    return this.passesGeneralRowColBloomFilter(kvKey);
                }
                return true;
            }
            case ROWPREFIX_FIXED_LENGTH: {
                return this.passesGeneralRowPrefixBloomFilter(scan);
            }
        }
        return true;
    }

    public boolean passesDeleteFamilyBloomFilter(byte[] row, int rowOffset, int rowLen) {
        BloomFilter bloomFilter = this.deleteFamilyBloomFilter;
        if (this.reader.getTrailer().getEntryCount() == 0L || this.deleteFamilyCnt == 0L) {
            return false;
        }
        if (bloomFilter == null) {
            return true;
        }
        try {
            if (!bloomFilter.supportsAutoLoading()) {
                return true;
            }
            return bloomFilter.contains(row, rowOffset, rowLen, null);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Bad Delete Family bloom filter data -- proceeding without", (Throwable)e);
            this.setDeleteFamilyBloomFilterFaulty();
            return true;
        }
    }

    private boolean passesGeneralRowBloomFilter(byte[] row, int rowOffset, int rowLen) {
        BloomFilter bloomFilter = this.generalBloomFilter;
        if (bloomFilter == null) {
            return true;
        }
        byte[] key = null;
        if (rowOffset != 0 || rowLen != row.length) {
            throw new AssertionError((Object)"For row-only Bloom filters the row must occupy the whole array");
        }
        key = row;
        return this.checkGeneralBloomFilter(key, null, bloomFilter);
    }

    public boolean passesGeneralRowColBloomFilter(Cell cell) {
        BloomFilter bloomFilter = this.generalBloomFilter;
        if (bloomFilter == null) {
            return true;
        }
        Cell kvKey = null;
        kvKey = cell.getTypeByte() == KeyValue.Type.Maximum.getCode() && cell.getFamilyLength() == 0 ? cell : PrivateCellUtil.createFirstOnRowCol((Cell)cell);
        return this.checkGeneralBloomFilter(null, kvKey, bloomFilter);
    }

    private boolean passesGeneralRowPrefixBloomFilter(Scan scan) {
        byte[] rowPrefix;
        BloomFilter bloomFilter = this.generalBloomFilter;
        if (bloomFilter == null) {
            return true;
        }
        byte[] row = scan.getStartRow();
        if (scan.isGetScan()) {
            rowPrefix = Bytes.copy((byte[])row, (int)0, (int)Math.min(this.prefixLength, row.length));
        } else {
            int commonLength = Bytes.findCommonPrefix((byte[])scan.getStartRow(), (byte[])scan.getStopRow(), (int)scan.getStartRow().length, (int)scan.getStopRow().length, (int)0, (int)0);
            if (commonLength <= 0 || commonLength < this.prefixLength) {
                return true;
            }
            rowPrefix = Bytes.copy((byte[])row, (int)0, (int)this.prefixLength);
        }
        return this.checkGeneralBloomFilter(rowPrefix, null, bloomFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkGeneralBloomFilter(byte[] key, Cell kvKey, BloomFilter bloomFilter) {
        HFileBlock bloomBlock;
        block14: {
            boolean bl;
            if (this.reader.getTrailer().getEntryCount() == 0L) {
                return false;
            }
            bloomBlock = null;
            try {
                boolean exists;
                boolean keyIsAfterLast;
                boolean shouldCheckBloom;
                ByteBuff bloom;
                if (bloomFilter.supportsAutoLoading()) {
                    bloom = null;
                    shouldCheckBloom = true;
                } else {
                    bloomBlock = this.reader.getMetaBlock("BLOOM_FILTER_DATA", true);
                    bloom = bloomBlock.getBufferWithoutHeader();
                    boolean bl2 = shouldCheckBloom = bloom != null;
                }
                if (!shouldCheckBloom) break block14;
                boolean bl3 = keyIsAfterLast = this.lastBloomKey != null;
                if (keyIsAfterLast) {
                    if (this.bloomFilterType == BloomType.ROWCOL) {
                        keyIsAfterLast = CellComparator.getInstance().compare(kvKey, (Cell)this.lastBloomKeyOnlyKV) > 0;
                    } else {
                        boolean bl4 = keyIsAfterLast = Bytes.BYTES_RAWCOMPARATOR.compare((Object)key, (Object)this.lastBloomKey) > 0;
                    }
                }
                if (this.bloomFilterType == BloomType.ROWCOL) {
                    Cell rowBloomKey = PrivateCellUtil.createFirstOnRow((Cell)kvKey);
                    exists = keyIsAfterLast && CellComparator.getInstance().compare(rowBloomKey, (Cell)this.lastBloomKeyOnlyKV) > 0 ? false : bloomFilter.contains(kvKey, bloom, BloomType.ROWCOL) || bloomFilter.contains(rowBloomKey, bloom, BloomType.ROWCOL);
                } else {
                    exists = !keyIsAfterLast && bloomFilter.contains(key, 0, key.length, bloom);
                }
                bl = exists;
            }
            catch (IOException e) {
                LOG.error("Error reading bloom filter data -- proceeding without", (Throwable)e);
                this.setGeneralBloomFilterFaulty();
                this.reader.returnBlock(bloomBlock);
            }
            catch (IllegalArgumentException e2) {
                LOG.error("Bad bloom filter data -- proceeding without", (Throwable)e2);
                this.setGeneralBloomFilterFaulty();
                {
                    catch (Throwable throwable) {
                        this.reader.returnBlock(bloomBlock);
                        throw throwable;
                    }
                }
                this.reader.returnBlock(bloomBlock);
            }
            this.reader.returnBlock(bloomBlock);
            return bl;
        }
        this.reader.returnBlock(bloomBlock);
        return true;
    }

    public boolean passesKeyRangeFilter(Scan scan) {
        byte[] largestScanRow;
        Optional<Cell> firstKeyKV = this.getFirstKey();
        Optional<Cell> lastKeyKV = this.getLastKey();
        if (!firstKeyKV.isPresent() || !lastKeyKV.isPresent()) {
            return false;
        }
        if (Bytes.equals((byte[])scan.getStartRow(), (byte[])HConstants.EMPTY_START_ROW) && Bytes.equals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW)) {
            return true;
        }
        byte[] smallestScanRow = scan.isReversed() ? scan.getStopRow() : scan.getStartRow();
        byte[] byArray = largestScanRow = scan.isReversed() ? scan.getStartRow() : scan.getStopRow();
        boolean nonOverLapping = this.getComparator().compareRows(firstKeyKV.get(), largestScanRow, 0, largestScanRow.length) > 0 && !Bytes.equals((byte[])(scan.isReversed() ? scan.getStartRow() : scan.getStopRow()), (byte[])HConstants.EMPTY_END_ROW) || this.getComparator().compareRows(lastKeyKV.get(), smallestScanRow, 0, smallestScanRow.length) < 0;
        return !nonOverLapping;
    }

    public Map<byte[], byte[]> loadFileInfo() throws IOException {
        byte[] cnt;
        Map<byte[], byte[]> fi = this.reader.loadFileInfo();
        byte[] b = fi.get(HStoreFile.BLOOM_FILTER_TYPE_KEY);
        if (b != null) {
            this.bloomFilterType = BloomType.valueOf((String)Bytes.toString((byte[])b));
        }
        byte[] p = fi.get(HStoreFile.BLOOM_FILTER_PARAM_KEY);
        if (this.bloomFilterType == BloomType.ROWPREFIX_FIXED_LENGTH) {
            this.prefixLength = Bytes.toInt((byte[])p);
        }
        this.lastBloomKey = fi.get(HStoreFile.LAST_BLOOM_KEY);
        if (this.bloomFilterType == BloomType.ROWCOL) {
            this.lastBloomKeyOnlyKV = new KeyValue.KeyOnlyKeyValue(this.lastBloomKey, 0, this.lastBloomKey.length);
        }
        if ((cnt = fi.get(HStoreFile.DELETE_FAMILY_COUNT)) != null) {
            this.deleteFamilyCnt = Bytes.toLong((byte[])cnt);
        }
        return fi;
    }

    public void loadBloomfilter() {
        this.loadBloomfilter(BlockType.GENERAL_BLOOM_META);
        this.loadBloomfilter(BlockType.DELETE_FAMILY_BLOOM_META);
    }

    public void loadBloomfilter(BlockType blockType) {
        block11: {
            try {
                if (blockType == BlockType.GENERAL_BLOOM_META) {
                    if (this.generalBloomFilter != null) {
                        return;
                    }
                    DataInput bloomMeta = this.reader.getGeneralBloomFilterMetadata();
                    if (bloomMeta != null) {
                        if (this.bloomFilterType == BloomType.NONE) {
                            throw new IOException("valid bloom filter type not found in FileInfo");
                        }
                        this.generalBloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, this.reader);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Loaded " + this.bloomFilterType.toString() + " " + this.generalBloomFilter.getClass().getSimpleName() + " metadata for " + this.reader.getName());
                        }
                    }
                    break block11;
                }
                if (blockType == BlockType.DELETE_FAMILY_BLOOM_META) {
                    if (this.deleteFamilyBloomFilter != null) {
                        return;
                    }
                    DataInput bloomMeta = this.reader.getDeleteBloomFilterMetadata();
                    if (bloomMeta != null) {
                        this.deleteFamilyBloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, this.reader);
                        LOG.info("Loaded Delete Family Bloom (" + this.deleteFamilyBloomFilter.getClass().getSimpleName() + ") metadata for " + this.reader.getName());
                    }
                    break block11;
                }
                throw new RuntimeException("Block Type: " + blockType.toString() + "is not supported for Bloom filter");
            }
            catch (IOException e) {
                LOG.error("Error reading bloom filter meta for " + blockType + " -- proceeding without", (Throwable)e);
                this.setBloomFilterFaulty(blockType);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Bad bloom filter meta " + blockType + " -- proceeding without", (Throwable)e);
                this.setBloomFilterFaulty(blockType);
            }
        }
    }

    private void setBloomFilterFaulty(BlockType blockType) {
        if (blockType == BlockType.GENERAL_BLOOM_META) {
            this.setGeneralBloomFilterFaulty();
        } else if (blockType == BlockType.DELETE_FAMILY_BLOOM_META) {
            this.setDeleteFamilyBloomFilterFaulty();
        }
    }

    public long getFilterEntries() {
        return this.generalBloomFilter != null ? this.generalBloomFilter.getKeyCount() : this.reader.getEntries();
    }

    public void setGeneralBloomFilterFaulty() {
        this.generalBloomFilter = null;
    }

    public void setDeleteFamilyBloomFilterFaulty() {
        this.deleteFamilyBloomFilter = null;
    }

    public Optional<Cell> getLastKey() {
        return this.reader.getLastKey();
    }

    public Optional<byte[]> getLastRowKey() {
        return this.reader.getLastRowKey();
    }

    public Optional<Cell> midKey() throws IOException {
        return this.reader.midKey();
    }

    public long length() {
        return this.reader.length();
    }

    public long getTotalUncompressedBytes() {
        return this.reader.getTrailer().getTotalUncompressedBytes();
    }

    public long getEntries() {
        return this.reader.getEntries();
    }

    public long getDeleteFamilyCnt() {
        return this.deleteFamilyCnt;
    }

    public Optional<Cell> getFirstKey() {
        return this.reader.getFirstKey();
    }

    public long indexSize() {
        return this.reader.indexSize();
    }

    public BloomType getBloomFilterType() {
        return this.bloomFilterType;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    public void setSequenceID(long sequenceID) {
        this.sequenceID = sequenceID;
    }

    public void setBulkLoaded(boolean bulkLoadResult) {
        this.bulkLoadResult = bulkLoadResult;
    }

    public boolean isBulkLoaded() {
        return this.bulkLoadResult;
    }

    BloomFilter getGeneralBloomFilter() {
        return this.generalBloomFilter;
    }

    long getUncompressedDataIndexSize() {
        return this.reader.getTrailer().getUncompressedDataIndexSize();
    }

    public long getTotalBloomSize() {
        if (this.generalBloomFilter == null) {
            return 0L;
        }
        return this.generalBloomFilter.getByteSize();
    }

    public int getHFileVersion() {
        return this.reader.getTrailer().getMajorVersion();
    }

    public int getHFileMinorVersion() {
        return this.reader.getTrailer().getMinorVersion();
    }

    public HFile.Reader getHFileReader() {
        return this.reader;
    }

    void disableBloomFilterForTesting() {
        this.generalBloomFilter = null;
        this.deleteFamilyBloomFilter = null;
    }

    public long getMaxTimestamp() {
        return this.timeRange == null ? Long.MAX_VALUE : this.timeRange.getMax();
    }

    boolean isSkipResetSeqId() {
        return this.skipResetSeqId;
    }

    void setSkipResetSeqId(boolean skipResetSeqId) {
        this.skipResetSeqId = skipResetSeqId;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }
}

