/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultCompactor
extends Compactor<StoreFileWriter> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompactor.class);
    private final Compactor.CellSinkFactory<StoreFileWriter> writerFactory = new Compactor.CellSinkFactory<StoreFileWriter>(){

        @Override
        public StoreFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
            return DefaultCompactor.this.createTmpWriter(fd, shouldDropBehind);
        }
    };

    public DefaultCompactor(Configuration conf, HStore store) {
        super(conf, store);
    }

    public List<Path> compact(CompactionRequestImpl request, ThroughputController throughputController, User user) throws IOException {
        return this.compact(request, this.defaultScannerFactory, this.writerFactory, throughputController, user);
    }

    public List<Path> compactForTesting(Collection<HStoreFile> filesToCompact, boolean isMajor) throws IOException {
        CompactionRequestImpl cr = new CompactionRequestImpl(filesToCompact);
        cr.setIsMajor(isMajor, isMajor);
        return this.compact(cr, NoLimitThroughputController.INSTANCE, null);
    }

    @Override
    protected List<Path> commitWriter(StoreFileWriter writer, Compactor.FileDetails fd, CompactionRequestImpl request) throws IOException {
        ArrayList newFiles = Lists.newArrayList((Object[])new Path[]{writer.getPath()});
        writer.appendMetadata(fd.maxSeqId, request.isAllFiles(), request.getFiles());
        writer.close();
        return newFiles;
    }

    @Override
    protected void abortWriter(StoreFileWriter writer) throws IOException {
        Path leftoverFile = writer.getPath();
        try {
            writer.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close the writer after an unfinished compaction.", (Throwable)e);
        }
        try {
            this.store.getFileSystem().delete(leftoverFile, false);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete the leftover file " + leftoverFile + " after an unfinished compaction.", (Throwable)e);
        }
    }
}

