/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsWAL
implements WALActionsListener {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsWAL.class);
    private final MetricsWALSource source;

    public MetricsWAL() {
        this((MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class));
    }

    @VisibleForTesting
    MetricsWAL(MetricsWALSource s) {
        this.source = s;
    }

    @Override
    public void postSync(long timeInNanos, int handlerSyncs) {
        this.source.incrementSyncTime(timeInNanos / 1000000L);
    }

    @Override
    public void postAppend(long size, long time, WALKey logkey, WALEdit logEdit) throws IOException {
        this.source.incrementAppendCount();
        this.source.incrementAppendTime(time);
        this.source.incrementAppendSize(size);
        this.source.incrementWrittenBytes(size);
        if (time > 1000L) {
            this.source.incrementSlowAppendCount();
            LOG.warn(String.format("%s took %d ms appending an edit to wal; len~=%s", Thread.currentThread().getName(), time, StringUtils.humanReadableInt((long)size)));
        }
    }

    @Override
    public void logRollRequested(boolean underReplicated) {
        this.source.incrementLogRollRequested();
        if (underReplicated) {
            this.source.incrementLowReplicationLogRoll();
        }
    }
}

