/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import ch.cern.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import java.util.Arrays;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CreateSnapshot
extends AbstractHBaseTool {
    private SnapshotType snapshotType = SnapshotType.FLUSH;
    private TableName tableName = null;
    private String snapshotName = null;

    public static void main(String[] args) {
        new CreateSnapshot().doStaticMain(args);
    }

    protected void addOptions() {
        this.addRequiredOptWithArg("t", "table", "The name of the table");
        this.addRequiredOptWithArg("n", "name", "The name of the created snapshot");
        this.addOptWithArg("s", "snapshot_type", "Snapshot Type. FLUSH is default. Posible values are " + Arrays.toString(SnapshotType.values()));
    }

    protected void processOptions(CommandLine cmd) {
        this.tableName = TableName.valueOf((String)cmd.getOptionValue('t'));
        this.snapshotName = cmd.getOptionValue('n');
        String snapshotTypeName = cmd.getOptionValue('s');
        if (snapshotTypeName != null) {
            snapshotTypeName = snapshotTypeName.toUpperCase(Locale.ROOT);
            this.snapshotType = SnapshotType.valueOf((String)snapshotTypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doWork() throws Exception {
        Connection connection = null;
        Admin admin = null;
        try {
            connection = ConnectionFactory.createConnection((Configuration)this.getConf());
            admin = connection.getAdmin();
            admin.snapshot(new SnapshotDescription(this.snapshotName, this.tableName, this.snapshotType));
        }
        catch (Exception e) {
            System.err.println("failed to take the snapshot: " + e.getMessage());
            int n = -1;
            return n;
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return 0;
    }
}

