/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import ch.cern.hbase.thirdparty.com.google.common.collect.Maps;
import ch.cern.hbase.thirdparty.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.compaction.MajorCompactionRequest;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ClusterCompactionQueues {
    private final Map<ServerName, List<MajorCompactionRequest>> compactionQueues;
    private final Set<ServerName> compactingServers;
    private final ReadWriteLock lock;
    private final int concurrentServers;

    ClusterCompactionQueues(int concurrentServers) {
        this.concurrentServers = concurrentServers;
        this.compactionQueues = Maps.newHashMap();
        this.lock = new ReentrantReadWriteLock();
        this.compactingServers = Sets.newHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCompactionQueue(ServerName serverName, MajorCompactionRequest info) {
        this.lock.writeLock().lock();
        try {
            ArrayList result = this.compactionQueues.get(serverName);
            if (result == null) {
                result = Lists.newArrayList();
                this.compactionQueues.put(serverName, result);
            }
            result.add(info);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean hasWorkItems() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.compactionQueues.values().stream().allMatch(List::isEmpty);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCompactionRequestsLeftToFinish() {
        this.lock.readLock().lock();
        try {
            int size = 0;
            for (List<MajorCompactionRequest> queue : this.compactionQueues.values()) {
                size += queue.size();
            }
            int n = size;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    List<MajorCompactionRequest> getQueue(ServerName serverName) {
        this.lock.readLock().lock();
        try {
            List<MajorCompactionRequest> list = this.compactionQueues.get(serverName);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    MajorCompactionRequest reserveForCompaction(ServerName serverName) {
        this.lock.writeLock().lock();
        try {
            if (!this.compactionQueues.get(serverName).isEmpty()) {
                this.compactingServers.add(serverName);
                MajorCompactionRequest majorCompactionRequest = this.compactionQueues.get(serverName).remove(0);
                return majorCompactionRequest;
            }
            MajorCompactionRequest majorCompactionRequest = null;
            return majorCompactionRequest;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void releaseCompaction(ServerName serverName) {
        this.lock.writeLock().lock();
        try {
            this.compactingServers.remove(serverName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean atCapacity() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.compactingServers.size() >= this.concurrentServers;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    Optional<ServerName> getLargestQueueFromServersNotCompacting() {
        this.lock.readLock().lock();
        try {
            Optional<ServerName> optional = this.compactionQueues.entrySet().stream().filter(entry -> !this.compactingServers.contains(entry.getKey())).max(Map.Entry.comparingByValue((o1, o2) -> Integer.compare(o1.size(), o2.size()))).map(Map.Entry::getKey);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

