/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import ch.cern.hbase.thirdparty.com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MajorCompactionRequest {
    private static final Logger LOG = LoggerFactory.getLogger(MajorCompactionRequest.class);
    private final Configuration configuration;
    private final RegionInfo region;
    private Set<String> stores;
    private final long timestamp;

    @VisibleForTesting
    MajorCompactionRequest(Configuration configuration, RegionInfo region, Set<String> stores, long timestamp) {
        this.configuration = configuration;
        this.region = region;
        this.stores = stores;
        this.timestamp = timestamp;
    }

    static Optional<MajorCompactionRequest> newRequest(Configuration configuration, RegionInfo info, Set<String> stores, long timestamp) throws IOException {
        MajorCompactionRequest request = new MajorCompactionRequest(configuration, info, stores, timestamp);
        return request.createRequest(configuration, stores);
    }

    RegionInfo getRegion() {
        return this.region;
    }

    Set<String> getStores() {
        return this.stores;
    }

    void setStores(Set<String> stores) {
        this.stores = stores;
    }

    @VisibleForTesting
    Optional<MajorCompactionRequest> createRequest(Configuration configuration, Set<String> stores) throws IOException {
        Set<String> familiesToCompact = this.getStoresRequiringCompaction(stores);
        MajorCompactionRequest request = null;
        if (!familiesToCompact.isEmpty()) {
            request = new MajorCompactionRequest(configuration, this.region, familiesToCompact, this.timestamp);
        }
        return Optional.ofNullable(request);
    }

    Set<String> getStoresRequiringCompaction(Set<String> requestedStores) throws IOException {
        try (Connection connection = this.getConnection(this.configuration);){
            HRegionFileSystem fileSystem = this.getFileSystem(connection);
            HashSet familiesToCompact = Sets.newHashSet();
            for (String family : requestedStores) {
                Collection<StoreFileInfo> storeFiles = fileSystem.getStoreFiles(family);
                if (storeFiles == null) {
                    LOG.info("Excluding store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName(), (Object)" has no store files");
                    continue;
                }
                if (fileSystem.hasReferences(family) && this.familyHasReferenceFile(fileSystem, family)) {
                    familiesToCompact.add(family);
                    LOG.info("Including store: " + family + " with: " + storeFiles.size() + " files for compaction for region: " + fileSystem.getRegionInfo().getEncodedName());
                    continue;
                }
                boolean includeStore = false;
                for (StoreFileInfo storeFile : storeFiles) {
                    if (storeFile.getModificationTime() >= this.timestamp) continue;
                    LOG.info("Including store: " + family + " with: " + storeFiles.size() + " files for compaction for region: " + fileSystem.getRegionInfo().getEncodedName());
                    familiesToCompact.add(family);
                    includeStore = true;
                    break;
                }
                if (includeStore) continue;
                LOG.info("Excluding store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName(), (Object)" already compacted");
            }
            HashSet hashSet = familiesToCompact;
            return hashSet;
        }
    }

    @VisibleForTesting
    Connection getConnection(Configuration configuration) throws IOException {
        return ConnectionFactory.createConnection((Configuration)configuration);
    }

    private boolean familyHasReferenceFile(HRegionFileSystem fileSystem, String family) throws IOException {
        List<Path> referenceFiles = this.getReferenceFilePaths(fileSystem.getFileSystem(), fileSystem.getStoreDir(family));
        for (Path referenceFile : referenceFiles) {
            FileStatus status = fileSystem.getFileSystem().getFileLinkStatus(referenceFile);
            if (status.getModificationTime() >= this.timestamp) continue;
            LOG.info("Including store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName() + " (reference store files)");
            return true;
        }
        return false;
    }

    @VisibleForTesting
    List<Path> getReferenceFilePaths(FileSystem fileSystem, Path familyDir) throws IOException {
        return FSUtils.getReferenceFilePaths(fileSystem, familyDir);
    }

    @VisibleForTesting
    HRegionFileSystem getFileSystem(Connection connection) throws IOException {
        Admin admin = connection.getAdmin();
        return HRegionFileSystem.openRegionFromFileSystem(admin.getConfiguration(), FSUtils.getCurrentFileSystem((Configuration)admin.getConfiguration()), FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)admin.getConfiguration()), (TableName)this.region.getTable()), this.region, true);
    }

    public String toString() {
        return "region: " + this.region.getEncodedName() + " store(s): " + this.stores;
    }
}

