/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import ch.cern.hbase.thirdparty.com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class WALKeyImpl
implements WALKey {
    public static final WALKeyImpl EMPTY_WALKEYIMPL = new WALKeyImpl();
    private byte[] encodedRegionName;
    private TableName tablename;
    private long sequenceId;
    private long origLogSeqNum = 0L;
    private long writeTime;
    private List<UUID> clusterIds;
    private NavigableMap<byte[], Integer> replicationScope;
    private long nonceGroup = 0L;
    private long nonce = 0L;
    private MultiVersionConcurrencyControl mvcc;
    private MultiVersionConcurrencyControl.WriteEntry writeEntry;

    public MultiVersionConcurrencyControl getMvcc() {
        return this.mvcc;
    }

    public MultiVersionConcurrencyControl.WriteEntry getWriteEntry() {
        return this.writeEntry;
    }

    public void setWriteEntry(MultiVersionConcurrencyControl.WriteEntry writeEntry) {
        assert (this.writeEntry == null);
        this.writeEntry = writeEntry;
        this.sequenceId = writeEntry.getWriteNumber();
    }

    public WALKeyImpl() {
        this.init(null, null, 0L, Long.MAX_VALUE, new ArrayList<UUID>(), 0L, 0L, null, null);
    }

    public WALKeyImpl(NavigableMap<byte[], Integer> replicationScope) {
        this.init(null, null, 0L, Long.MAX_VALUE, new ArrayList<UUID>(), 0L, 0L, null, replicationScope);
    }

    @VisibleForTesting
    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, UUID clusterId) {
        ArrayList<UUID> clusterIds = new ArrayList<UUID>(1);
        clusterIds.add(clusterId);
        this.init(encodedRegionName, tablename, logSeqNum, now, clusterIds, 0L, 0L, null, null);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long now) {
        this.init(encodedRegionName, tablename, -1L, now, EMPTY_UUIDS, 0L, 0L, null, null);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long now, NavigableMap<byte[], Integer> replicationScope) {
        this.init(encodedRegionName, tablename, -1L, now, EMPTY_UUIDS, 0L, 0L, null, replicationScope);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long now, MultiVersionConcurrencyControl mvcc, NavigableMap<byte[], Integer> replicationScope) {
        this.init(encodedRegionName, tablename, -1L, now, EMPTY_UUIDS, 0L, 0L, mvcc, replicationScope);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long now, MultiVersionConcurrencyControl mvcc) {
        this.init(encodedRegionName, tablename, -1L, now, EMPTY_UUIDS, 0L, 0L, mvcc, null);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, List<UUID> clusterIds, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc, NavigableMap<byte[], Integer> replicationScope) {
        this.init(encodedRegionName, tablename, logSeqNum, now, clusterIds, nonceGroup, nonce, mvcc, replicationScope);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, List<UUID> clusterIds, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc) {
        this.init(encodedRegionName, tablename, logSeqNum, now, clusterIds, nonceGroup, nonce, mvcc, null);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long now, List<UUID> clusterIds, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc) {
        this.init(encodedRegionName, tablename, -1L, now, clusterIds, nonceGroup, nonce, mvcc, null);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long now, List<UUID> clusterIds, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc, NavigableMap<byte[], Integer> replicationScope) {
        this.init(encodedRegionName, tablename, -1L, now, clusterIds, nonceGroup, nonce, mvcc, replicationScope);
    }

    public WALKeyImpl(byte[] encodedRegionName, TableName tablename, long logSeqNum, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc) {
        this.init(encodedRegionName, tablename, logSeqNum, EnvironmentEdgeManager.currentTime(), EMPTY_UUIDS, nonceGroup, nonce, mvcc, null);
    }

    @InterfaceAudience.Private
    protected void init(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, List<UUID> clusterIds, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc, NavigableMap<byte[], Integer> replicationScope) {
        this.sequenceId = logSeqNum;
        this.writeTime = now;
        this.clusterIds = clusterIds;
        this.encodedRegionName = encodedRegionName;
        this.tablename = tablename;
        this.nonceGroup = nonceGroup;
        this.nonce = nonce;
        this.mvcc = mvcc;
        if (logSeqNum != -1L) {
            this.setSequenceId(logSeqNum);
        }
        this.replicationScope = replicationScope;
    }

    @InterfaceAudience.Private
    protected void setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    @Deprecated
    public void setCompressionContext(CompressionContext compressionContext) {
    }

    @Override
    public byte[] getEncodedRegionName() {
        return this.encodedRegionName;
    }

    @Override
    public TableName getTableName() {
        return this.tablename;
    }

    @Deprecated
    public long getLogSeqNum() {
        return this.getSequenceId();
    }

    public void setOrigLogSeqNum(long sequenceId) {
        this.origLogSeqNum = sequenceId;
    }

    @Override
    public long getOrigLogSeqNum() {
        return this.origLogSeqNum;
    }

    @Override
    public long getSequenceId() {
        return this.sequenceId;
    }

    @Override
    public long getWriteTime() {
        return this.writeTime;
    }

    public NavigableMap<byte[], Integer> getReplicationScopes() {
        return this.replicationScope;
    }

    @Override
    public long getNonceGroup() {
        return this.nonceGroup;
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    private void setReplicationScope(NavigableMap<byte[], Integer> replicationScope) {
        this.replicationScope = replicationScope;
    }

    public void clearReplicationScope() {
        this.setReplicationScope(null);
    }

    public void addClusterId(UUID clusterId) {
        if (!this.clusterIds.contains(clusterId)) {
            this.clusterIds.add(clusterId);
        }
    }

    public List<UUID> getClusterIds() {
        return this.clusterIds;
    }

    @Override
    public UUID getOriginatingClusterId() {
        return this.clusterIds.isEmpty() ? HConstants.DEFAULT_CLUSTER_ID : this.clusterIds.get(0);
    }

    public String toString() {
        return this.tablename + "/" + Bytes.toString((byte[])this.encodedRegionName) + "/" + this.sequenceId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((WALKey)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode((byte[])this.encodedRegionName);
        result = (int)((long)result ^ this.getSequenceId());
        result = (int)((long)result ^ this.writeTime);
        return result;
    }

    @Override
    public int compareTo(WALKey o) {
        int result = Bytes.compareTo((byte[])this.encodedRegionName, (byte[])o.getEncodedRegionName());
        if (result == 0) {
            long otherSid;
            long sid = this.getSequenceId();
            if (sid < (otherSid = o.getSequenceId())) {
                result = -1;
            } else if (sid > otherSid) {
                result = 1;
            }
            if (result == 0) {
                if (this.writeTime < o.getWriteTime()) {
                    result = -1;
                } else if (this.writeTime > o.getWriteTime()) {
                    return 1;
                }
            }
        }
        return result;
    }

    void internTableName(TableName tablename) {
        assert (tablename.equals((Object)this.tablename));
        this.tablename = tablename;
    }

    void internEncodedRegionName(byte[] encodedRegionName) {
        assert (Bytes.equals((byte[])this.encodedRegionName, (byte[])encodedRegionName));
        this.encodedRegionName = encodedRegionName;
    }

    public WALProtos.WALKey.Builder getBuilder(WALCellCodec.ByteStringCompressor compressor) throws IOException {
        WALProtos.WALKey.Builder builder = WALProtos.WALKey.newBuilder();
        builder.setEncodedRegionName(compressor.compress(this.encodedRegionName, CompressionContext.DictionaryIndex.REGION));
        builder.setTableName(compressor.compress(this.tablename.getName(), CompressionContext.DictionaryIndex.TABLE));
        builder.setLogSequenceNumber(this.getSequenceId());
        builder.setWriteTime(this.writeTime);
        if (this.origLogSeqNum > 0L) {
            builder.setOrigSequenceNumber(this.origLogSeqNum);
        }
        if (this.nonce != 0L) {
            builder.setNonce(this.nonce);
        }
        if (this.nonceGroup != 0L) {
            builder.setNonceGroup(this.nonceGroup);
        }
        HBaseProtos.UUID.Builder uuidBuilder = HBaseProtos.UUID.newBuilder();
        for (UUID uUID : this.clusterIds) {
            uuidBuilder.setLeastSigBits(uUID.getLeastSignificantBits());
            uuidBuilder.setMostSigBits(uUID.getMostSignificantBits());
            builder.addClusterIds(uuidBuilder.build());
        }
        if (this.replicationScope != null) {
            for (Map.Entry entry : this.replicationScope.entrySet()) {
                ByteString family = compressor.compress((byte[])entry.getKey(), CompressionContext.DictionaryIndex.FAMILY);
                builder.addScopes(WALProtos.FamilyScope.newBuilder().setFamily(family).setScopeType(WALProtos.ScopeType.forNumber((int)((Integer)entry.getValue()))));
            }
        }
        return builder;
    }

    public void readFieldsFromPb(WALProtos.WALKey walKey, WALCellCodec.ByteStringUncompressor uncompressor) throws IOException {
        this.encodedRegionName = uncompressor.uncompress(walKey.getEncodedRegionName(), CompressionContext.DictionaryIndex.REGION);
        byte[] tablenameBytes = uncompressor.uncompress(walKey.getTableName(), CompressionContext.DictionaryIndex.TABLE);
        this.tablename = TableName.valueOf((byte[])tablenameBytes);
        this.clusterIds.clear();
        for (HBaseProtos.UUID clusterId : walKey.getClusterIdsList()) {
            this.clusterIds.add(new UUID(clusterId.getMostSigBits(), clusterId.getLeastSigBits()));
        }
        if (walKey.hasNonceGroup()) {
            this.nonceGroup = walKey.getNonceGroup();
        }
        if (walKey.hasNonce()) {
            this.nonce = walKey.getNonce();
        }
        this.replicationScope = null;
        if (walKey.getScopesCount() > 0) {
            this.replicationScope = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            for (WALProtos.FamilyScope scope : walKey.getScopesList()) {
                byte[] family = uncompressor.uncompress(scope.getFamily(), CompressionContext.DictionaryIndex.FAMILY);
                this.replicationScope.put(family, scope.getScopeType().getNumber());
            }
        }
        this.setSequenceId(walKey.getLogSequenceNumber());
        this.writeTime = walKey.getWriteTime();
        if (walKey.hasOrigSequenceNumber()) {
            this.origLogSeqNum = walKey.getOrigSequenceNumber();
        }
    }

    @Override
    public long estimatedSerializedSizeOf() {
        long size = this.encodedRegionName != null ? (long)this.encodedRegionName.length : 0L;
        size += this.tablename != null ? (long)this.tablename.toBytes().length : 0L;
        if (this.clusterIds != null) {
            size += (long)(16 * this.clusterIds.size());
        }
        if (this.nonceGroup != 0L) {
            size += 8L;
        }
        if (this.nonce != 0L) {
            size += 8L;
        }
        if (this.replicationScope != null) {
            for (Map.Entry scope : this.replicationScope.entrySet()) {
                size += (long)((byte[])scope.getKey()).length;
                size += 4L;
            }
        }
        size += 8L;
        size += 8L;
        if (this.origLogSeqNum > 0L) {
            size += 8L;
        }
        return size;
    }
}

