/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class WALSplitUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WALSplitUtil.class);
    private static final Pattern EDITFILES_NAME_PATTERN = Pattern.compile("-?[0-9]+");
    private static final String RECOVERED_LOG_TMPFILE_SUFFIX = ".temp";
    private static final String SEQUENCE_ID_FILE_SUFFIX = ".seqid";
    private static final String OLD_SEQUENCE_ID_FILE_SUFFIX = "_seqid";
    private static final int SEQUENCE_ID_FILE_SUFFIX_LENGTH = ".seqid".length();

    private WALSplitUtil() {
    }

    public static void finishSplitLogFile(String logfile, Configuration conf) throws IOException {
        Path walDir = FSUtils.getWALRootDir((Configuration)conf);
        Path oldLogDir = new Path(walDir, "oldWALs");
        Path walPath = FSUtils.isStartingWithPath((Path)walDir, (String)logfile) ? new Path(logfile) : new Path(walDir, logfile);
        WALSplitUtil.finishSplitLogFile(walDir, oldLogDir, walPath, conf);
    }

    static void finishSplitLogFile(Path walDir, Path oldWALDir, Path walPath, Configuration conf) throws IOException {
        ArrayList<Path> processedLogs = new ArrayList<Path>();
        ArrayList<Path> corruptedLogs = new ArrayList<Path>();
        FileSystem walFS = walDir.getFileSystem(conf);
        if (ZKSplitLog.isCorrupted((Path)walDir, (String)walPath.getName(), (FileSystem)walFS)) {
            corruptedLogs.add(walPath);
        } else {
            processedLogs.add(walPath);
        }
        WALSplitUtil.archiveWALs(corruptedLogs, processedLogs, oldWALDir, walFS, conf);
        Path stagingDir = ZKSplitLog.getSplitLogDir((Path)walDir, (String)walPath.getName());
        walFS.delete(stagingDir, true);
    }

    private static void archiveWALs(List<Path> corruptedWALs, List<Path> processedWALs, Path oldWALDir, FileSystem walFS, Configuration conf) throws IOException {
        Path corruptDir = new Path(FSUtils.getWALRootDir((Configuration)conf), "corrupt");
        if (conf.get("hbase.regionserver.hlog.splitlog.corrupt.dir") != null) {
            LOG.warn("hbase.regionserver.hlog.splitlog.corrupt.dir is deprecated. Default to {}", (Object)corruptDir);
        }
        if (!walFS.mkdirs(corruptDir)) {
            LOG.info("Unable to mkdir {}", (Object)corruptDir);
        }
        walFS.mkdirs(oldWALDir);
        for (Path corruptedWAL : corruptedWALs) {
            Path p = new Path(corruptDir, corruptedWAL.getName());
            if (!walFS.exists(corruptedWAL)) continue;
            if (!walFS.rename(corruptedWAL, p)) {
                LOG.warn("Unable to move corrupted log {} to {}", (Object)corruptedWAL, (Object)p);
                continue;
            }
            LOG.warn("Moved corrupted log {} to {}", (Object)corruptedWAL, (Object)p);
        }
        for (Path p : processedWALs) {
            Path newPath = AbstractFSWAL.getWALArchivePath(oldWALDir, p);
            if (!walFS.exists(p)) continue;
            if (!FSUtils.renameAndSetModifyTime((FileSystem)walFS, (Path)p, (Path)newPath)) {
                LOG.warn("Unable to move {} to {}", (Object)p, (Object)newPath);
                continue;
            }
            LOG.info("Archived processed log {} to {}", (Object)p, (Object)newPath);
        }
    }

    @VisibleForTesting
    static Path getRegionSplitEditsPath(WAL.Entry walEntry, String fileNameBeingSplit, String tmpDirName, Configuration conf) throws IOException {
        String encodedRegionName;
        Path tableDir;
        Path regionDir;
        Path dir;
        FileSystem walFS = FSUtils.getWALFileSystem((Configuration)conf);
        if (walFS.exists(dir = WALSplitUtil.getRegionDirRecoveredEditsDir(regionDir = HRegion.getRegionDir(tableDir = FSUtils.getWALTableDir((Configuration)conf, (TableName)walEntry.getKey().getTableName()), encodedRegionName = Bytes.toString((byte[])walEntry.getKey().getEncodedRegionName())))) && walFS.isFile(dir)) {
            Path tmp = new Path(tmpDirName);
            if (!walFS.exists(tmp)) {
                walFS.mkdirs(tmp);
            }
            tmp = new Path(tmp, "recovered.edits_" + encodedRegionName);
            LOG.warn("Found existing old file: {}. It could be some leftover of an old installation. It should be a folder instead. So moving it to {}", (Object)dir, (Object)tmp);
            if (!walFS.rename(dir, tmp)) {
                LOG.warn("Failed to sideline old file {}", (Object)dir);
            }
        }
        if (!walFS.exists(dir) && !walFS.mkdirs(dir)) {
            LOG.warn("mkdir failed on {}", (Object)dir);
        }
        String fileName = WALSplitUtil.formatRecoveredEditsFileName(walEntry.getKey().getSequenceId());
        fileName = WALSplitUtil.getTmpRecoveredEditsFileName(fileName + "-" + fileNameBeingSplit);
        return new Path(dir, fileName);
    }

    private static String getTmpRecoveredEditsFileName(String fileName) {
        return fileName + RECOVERED_LOG_TMPFILE_SUFFIX;
    }

    static Path getCompletedRecoveredEditsFilePath(Path srcPath, long maximumEditWALSeqNum) {
        String fileName = WALSplitUtil.formatRecoveredEditsFileName(maximumEditWALSeqNum);
        return new Path(srcPath.getParent(), fileName);
    }

    @VisibleForTesting
    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    public static Path getRegionDirRecoveredEditsDir(Path regionDir) {
        return new Path(regionDir, "recovered.edits");
    }

    public static boolean hasRecoveredEdits(Configuration conf, RegionInfo regionInfo) throws IOException {
        if (regionInfo.getReplicaId() != 0) {
            return false;
        }
        Path regionWALDir = FSUtils.getWALRegionDir((Configuration)conf, (TableName)regionInfo.getTable(), (String)regionInfo.getEncodedName());
        Path regionDir = FSUtils.getRegionDirFromRootDir(FSUtils.getRootDir((Configuration)conf), regionInfo);
        Path wrongRegionWALDir = FSUtils.getWrongWALRegionDir((Configuration)conf, (TableName)regionInfo.getTable(), (String)regionInfo.getEncodedName());
        FileSystem walFs = FSUtils.getWALFileSystem((Configuration)conf);
        FileSystem rootFs = FSUtils.getRootDirFileSystem((Configuration)conf);
        NavigableSet<Path> files = WALSplitUtil.getSplitEditFilesSorted(walFs, regionWALDir);
        if (!files.isEmpty()) {
            return true;
        }
        files = WALSplitUtil.getSplitEditFilesSorted(rootFs, regionDir);
        if (!files.isEmpty()) {
            return true;
        }
        files = WALSplitUtil.getSplitEditFilesSorted(walFs, wrongRegionWALDir);
        return !files.isEmpty();
    }

    @Deprecated
    public static long getMaxRegionSequenceId(Configuration conf, RegionInfo region, ConcurrentMapUtils.IOExceptionSupplier<FileSystem> rootFsSupplier, ConcurrentMapUtils.IOExceptionSupplier<FileSystem> walFsSupplier) throws IOException {
        FileSystem rootFs = (FileSystem)rootFsSupplier.get();
        FileSystem walFs = (FileSystem)walFsSupplier.get();
        Path regionWALDir = FSUtils.getWALRegionDir((Configuration)conf, (TableName)region.getTable(), (String)region.getEncodedName());
        Path regionDir = FSUtils.getRegionDirFromRootDir(FSUtils.getRootDir((Configuration)conf), region);
        Path wrongRegionWALDir = FSUtils.getWrongWALRegionDir((Configuration)conf, (TableName)region.getTable(), (String)region.getEncodedName());
        long maxSeqId = WALSplitUtil.getMaxRegionSequenceId(walFs, regionWALDir);
        maxSeqId = Math.max(maxSeqId, WALSplitUtil.getMaxRegionSequenceId(rootFs, regionDir));
        maxSeqId = Math.max(maxSeqId, WALSplitUtil.getMaxRegionSequenceId(walFs, wrongRegionWALDir));
        return maxSeqId;
    }

    public static NavigableSet<Path> getSplitEditFilesSorted(final FileSystem walFS, Path regionDir) throws IOException {
        TreeSet<Path> filesSorted = new TreeSet<Path>();
        Path editsdir = WALSplitUtil.getRegionDirRecoveredEditsDir(regionDir);
        if (!walFS.exists(editsdir)) {
            return filesSorted;
        }
        Object[] files = FSUtils.listStatus((FileSystem)walFS, (Path)editsdir, (PathFilter)new PathFilter(){

            public boolean accept(Path p) {
                boolean result = false;
                try {
                    Matcher m = EDITFILES_NAME_PATTERN.matcher(p.getName());
                    boolean bl = result = walFS.isFile(p) && m.matches();
                    if (p.getName().endsWith(WALSplitUtil.RECOVERED_LOG_TMPFILE_SUFFIX)) {
                        result = false;
                    }
                    if (WALSplitUtil.isSequenceIdFile(p)) {
                        result = false;
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed isFile check on {}", (Object)p, (Object)e);
                }
                return result;
            }
        });
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            Arrays.asList(files).forEach(status -> filesSorted.add(status.getPath()));
        }
        return filesSorted;
    }

    public static Path moveAsideBadEditsFile(FileSystem walFS, Path edits) throws IOException {
        Path moveAsideName = new Path(edits.getParent(), edits.getName() + "." + System.currentTimeMillis());
        if (!walFS.rename(edits, moveAsideName)) {
            LOG.warn("Rename failed from {} to {}", (Object)edits, (Object)moveAsideName);
        }
        return moveAsideName;
    }

    @VisibleForTesting
    public static boolean isSequenceIdFile(Path file) {
        return file.getName().endsWith(SEQUENCE_ID_FILE_SUFFIX) || file.getName().endsWith(OLD_SEQUENCE_ID_FILE_SUFFIX);
    }

    private static FileStatus[] getSequenceIdFiles(FileSystem walFS, Path regionDir) throws IOException {
        Path editsDir = WALSplitUtil.getRegionDirRecoveredEditsDir(regionDir);
        try {
            FileStatus[] files = walFS.listStatus(editsDir, WALSplitUtil::isSequenceIdFile);
            return files != null ? files : new FileStatus[]{};
        }
        catch (FileNotFoundException e) {
            return new FileStatus[0];
        }
    }

    private static long getMaxSequenceId(FileStatus[] files) {
        long maxSeqId = -1L;
        for (FileStatus file : files) {
            String fileName = file.getPath().getName();
            try {
                maxSeqId = Math.max(maxSeqId, Long.parseLong(fileName.substring(0, fileName.length() - SEQUENCE_ID_FILE_SUFFIX_LENGTH)));
            }
            catch (NumberFormatException ex) {
                LOG.warn("Invalid SeqId File Name={}", (Object)fileName);
            }
        }
        return maxSeqId;
    }

    public static long getMaxRegionSequenceId(FileSystem walFS, Path regionDir) throws IOException {
        return WALSplitUtil.getMaxSequenceId(WALSplitUtil.getSequenceIdFiles(walFS, regionDir));
    }

    public static void writeRegionSequenceIdFile(FileSystem walFS, Path regionDir, long newMaxSeqId) throws IOException {
        FileStatus[] files = WALSplitUtil.getSequenceIdFiles(walFS, regionDir);
        long maxSeqId = WALSplitUtil.getMaxSequenceId(files);
        if (maxSeqId > newMaxSeqId) {
            throw new IOException("The new max sequence id " + newMaxSeqId + " is less than the old max sequence id " + maxSeqId);
        }
        Path newSeqIdFile = new Path(WALSplitUtil.getRegionDirRecoveredEditsDir(regionDir), newMaxSeqId + SEQUENCE_ID_FILE_SUFFIX);
        if (newMaxSeqId != maxSeqId) {
            try {
                if (!walFS.createNewFile(newSeqIdFile) && !walFS.exists(newSeqIdFile)) {
                    throw new IOException("Failed to create SeqId file:" + newSeqIdFile);
                }
                LOG.debug("Wrote file={}, newMaxSeqId={}, maxSeqId={}", new Object[]{newSeqIdFile, newMaxSeqId, maxSeqId});
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        for (FileStatus status : files) {
            if (newSeqIdFile.equals((Object)status.getPath())) continue;
            walFS.delete(status.getPath(), false);
        }
    }

    public static List<MutationReplay> getMutationsFromWALEntry(AdminProtos.WALEntry entry, CellScanner cells, Pair<WALKey, WALEdit> logEntry, Durability durability) throws IOException {
        if (entry == null) {
            return Collections.emptyList();
        }
        long replaySeqId = entry.getKey().hasOrigSequenceNumber() ? entry.getKey().getOrigSequenceNumber() : entry.getKey().getLogSequenceNumber();
        int count = entry.getAssociatedCellCount();
        ArrayList<MutationReplay> mutations = new ArrayList<MutationReplay>();
        Cell previousCell = null;
        Delete m = null;
        WALKeyImpl key = null;
        WALEdit val = null;
        if (logEntry != null) {
            val = new WALEdit();
        }
        for (int i = 0; i < count; ++i) {
            boolean isNewRowOrType;
            if (!cells.advance()) {
                throw new ArrayIndexOutOfBoundsException("Expected=" + count + ", index=" + i);
            }
            Cell cell = cells.current();
            if (val != null) {
                val.add(cell);
            }
            boolean bl = isNewRowOrType = previousCell == null || previousCell.getTypeByte() != cell.getTypeByte() || !CellUtil.matchingRows(previousCell, (Cell)cell);
            if (isNewRowOrType) {
                if (CellUtil.isDelete((Cell)cell)) {
                    m = new Delete(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
                    mutations.add(new MutationReplay(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)m, 0L, 0L));
                } else {
                    m = new Put(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
                    long nonceGroup = entry.getKey().hasNonceGroup() ? entry.getKey().getNonceGroup() : 0L;
                    long nonce = entry.getKey().hasNonce() ? entry.getKey().getNonce() : 0L;
                    mutations.add(new MutationReplay(ClientProtos.MutationProto.MutationType.PUT, (Mutation)m, nonceGroup, nonce));
                }
            }
            if (CellUtil.isDelete((Cell)cell)) {
                ((Delete)m).add(cell);
            } else {
                ((Put)m).add(cell);
            }
            m.setDurability(durability);
            previousCell = cell;
        }
        if (logEntry != null) {
            WALProtos.WALKey walKeyProto = entry.getKey();
            ArrayList<UUID> clusterIds = new ArrayList<UUID>(walKeyProto.getClusterIdsCount());
            for (HBaseProtos.UUID uuid : entry.getKey().getClusterIdsList()) {
                clusterIds.add(new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits()));
            }
            key = new WALKeyImpl(walKeyProto.getEncodedRegionName().toByteArray(), TableName.valueOf((byte[])walKeyProto.getTableName().toByteArray()), replaySeqId, walKeyProto.getWriteTime(), clusterIds, walKeyProto.getNonceGroup(), walKeyProto.getNonce(), null);
            logEntry.setFirst((Object)key);
            logEntry.setSecond((Object)val);
        }
        return mutations;
    }

    public static class MutationReplay
    implements Comparable<MutationReplay> {
        private final ClientProtos.MutationProto.MutationType type;
        public final Mutation mutation;
        public final long nonceGroup;
        public final long nonce;

        public MutationReplay(ClientProtos.MutationProto.MutationType type, Mutation mutation, long nonceGroup, long nonce) {
            this.type = type;
            this.mutation = mutation;
            if (this.mutation.getDurability() != Durability.SKIP_WAL) {
                this.mutation.setDurability(Durability.ASYNC_WAL);
            }
            this.nonceGroup = nonceGroup;
            this.nonce = nonce;
        }

        @Override
        public int compareTo(MutationReplay d) {
            return this.mutation.compareTo((Row)d.mutation);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MutationReplay)) {
                return false;
            }
            return this.compareTo((MutationReplay)obj) == 0;
        }

        public int hashCode() {
            return this.mutation.hashCode();
        }

        public ClientProtos.MutationProto.MutationType getType() {
            return this.type;
        }
    }
}

