/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class AccessControlClient {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "acl");

    public static boolean isAuthorizationEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.AUTHORIZATION);
    }

    public static boolean isCellAuthorizationEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.CELL_AUTHORIZATION);
    }

    private static AccessControlProtos.AccessControlService.BlockingInterface getAccessControlServiceStub(Table ht) throws IOException {
        CoprocessorRpcChannel service = ht.coprocessorService(HConstants.EMPTY_START_ROW);
        AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
        return protocol;
    }

    private static void grant(Connection connection, TableName tableName, String userName, byte[] family, byte[] qual, boolean mergeExistingPermissions, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            AccessControlUtil.grant(null, AccessControlClient.getAccessControlServiceStub(table), userName, tableName, family, qual, mergeExistingPermissions, actions);
        }
    }

    public static void grant(Connection connection, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        AccessControlClient.grant(connection, tableName, userName, family, qual, true, actions);
    }

    private static void grant(Connection connection, String namespace, String userName, boolean mergeExistingPermissions, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            AccessControlUtil.grant(null, AccessControlClient.getAccessControlServiceStub(table), userName, namespace, mergeExistingPermissions, actions);
        }
    }

    public static void grant(Connection connection, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        AccessControlClient.grant(connection, namespace, userName, true, actions);
    }

    private static void grant(Connection connection, String userName, boolean mergeExistingPermissions, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            AccessControlUtil.grant(null, AccessControlClient.getAccessControlServiceStub(table), userName, mergeExistingPermissions, actions);
        }
    }

    public static void grant(Connection connection, String userName, Permission.Action ... actions) throws Throwable {
        AccessControlClient.grant(connection, userName, true, actions);
    }

    public static boolean isAccessControllerRunning(Connection connection) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        try (Admin admin = connection.getAdmin();){
            boolean bl = admin.isTableAvailable(ACL_TABLE_NAME);
            return bl;
        }
    }

    public static void revoke(Connection connection, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            AccessControlUtil.revoke(null, AccessControlClient.getAccessControlServiceStub(table), username, tableName, family, qualifier, actions);
        }
    }

    public static void revoke(Connection connection, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            AccessControlUtil.revoke(null, AccessControlClient.getAccessControlServiceStub(table), userName, namespace, actions);
        }
    }

    public static void revoke(Connection connection, String userName, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            AccessControlUtil.revoke(null, AccessControlClient.getAccessControlServiceStub(table), userName, actions);
        }
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex) throws Throwable {
        ArrayList<UserPermission> permList = new ArrayList();
        try (Table table = connection.getTable(ACL_TABLE_NAME);
             Admin admin = connection.getAdmin();){
            CoprocessorRpcChannel service = table.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
            HTableDescriptor[] htds = null;
            if (tableRegex == null || tableRegex.isEmpty()) {
                permList = AccessControlUtil.getUserPermissions(null, protocol);
            } else if (tableRegex.charAt(0) == '@') {
                String namespaceRegex = tableRegex.substring(1);
                for (NamespaceDescriptor nsds : admin.listNamespaceDescriptors()) {
                    String namespace = nsds.getName();
                    if (!namespace.matches(namespaceRegex)) continue;
                    permList.addAll(AccessControlUtil.getUserPermissions(null, protocol, Bytes.toBytes(namespace)));
                }
            } else {
                for (HTableDescriptor hd : htds = admin.listTables(Pattern.compile(tableRegex), true)) {
                    permList.addAll(AccessControlUtil.getUserPermissions(null, protocol, hd.getTableName()));
                }
            }
        }
        return permList;
    }
}

