/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.Asn1Object;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.EncoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.i18n.I18n;

public abstract class AbstractAsn1Object
implements Asn1Object {
    private int currentLength;
    private int expectedLength;
    private AbstractAsn1Object parent;
    private int tlvId;

    protected AbstractAsn1Object(int tlvId) {
        this.tlvId = tlvId;
    }

    protected AbstractAsn1Object() {
        this.tlvId = -1;
    }

    @Override
    public void addLength(int length) throws DecoderException {
        this.currentLength += length;
        if (this.currentLength > this.expectedLength) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_00041_CURRENT_LENGTH_EXCEED_EXPECTED_LENGTH, (Object[])new Object[0]));
        }
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        return null;
    }

    @Override
    public int getCurrentLength() {
        return this.currentLength;
    }

    @Override
    public void setCurrentLength(int currentLength) {
        this.currentLength = currentLength;
    }

    @Override
    public int getExpectedLength() {
        return this.expectedLength;
    }

    @Override
    public void setExpectedLength(int expectedLength) {
        this.expectedLength = expectedLength;
    }

    @Override
    public AbstractAsn1Object getParent() {
        return this.parent;
    }

    public void setParent(AbstractAsn1Object parent) {
        this.parent = parent;
    }

    public int getTlvId() {
        return this.tlvId;
    }
}

