/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.FailureInfo;
import org.apache.hadoop.hbase.client.FastFailInterceptorContext;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorContext;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.PreemptiveFastFailException;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class PreemptiveFastFailInterceptor
extends RetryingCallerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(PreemptiveFastFailInterceptor.class);
    protected final long fastFailThresholdMilliSec;
    protected final ConcurrentMap<ServerName, FailureInfo> repeatedFailuresMap = new ConcurrentHashMap<ServerName, FailureInfo>();
    protected final long failureMapCleanupIntervalMilliSec;
    protected volatile long lastFailureMapCleanupTimeMilliSec;
    private long fastFailClearingTimeMilliSec;
    private final ThreadLocal<MutableBoolean> threadRetryingInFastFailMode = new ThreadLocal();

    public PreemptiveFastFailInterceptor(Configuration conf) {
        this.fastFailThresholdMilliSec = conf.getLong("hbase.client.fastfail.threshold", 60000L);
        this.failureMapCleanupIntervalMilliSec = conf.getLong("hbase.client.fast.fail.cleanup.duration", 600000L);
        this.lastFailureMapCleanupTimeMilliSec = EnvironmentEdgeManager.currentTime();
    }

    public void intercept(FastFailInterceptorContext context) throws PreemptiveFastFailException {
        context.setFailureInfo((FailureInfo)this.repeatedFailuresMap.get(context.getServer()));
        if (this.inFastFailMode(context.getServer()) && !this.currentThreadInFastFailMode()) {
            context.setRetryDespiteFastFailMode(this.shouldRetryInspiteOfFastFail(context.getFailureInfo()));
            if (!context.isRetryDespiteFastFailMode()) {
                LOG.debug("Throwing PFFE : " + context.getFailureInfo() + " tries : " + context.getTries());
                throw new PreemptiveFastFailException(context.getFailureInfo().numConsecutiveFailures.get(), context.getFailureInfo().timeOfFirstFailureMilliSec, context.getFailureInfo().timeOfLatestAttemptMilliSec, context.getServer(), context.getGuaranteedClientSideOnly().isTrue());
            }
        }
        context.setDidTry(true);
    }

    public void handleFailure(FastFailInterceptorContext context, Throwable t) throws IOException {
        this.handleThrowable(t, context.getServer(), context.getCouldNotCommunicateWithServer(), context.getGuaranteedClientSideOnly());
    }

    public void updateFailureInfo(FastFailInterceptorContext context) {
        this.updateFailureInfoForServer(context.getServer(), context.getFailureInfo(), context.didTry(), context.getCouldNotCommunicateWithServer().booleanValue(), context.isRetryDespiteFastFailMode());
    }

    @VisibleForTesting
    protected void handleFailureToServer(ServerName serverName, Throwable t) {
        if (serverName == null || t == null) {
            return;
        }
        long currentTime = EnvironmentEdgeManager.currentTime();
        FailureInfo fInfo = CollectionUtils.computeIfAbsent(this.repeatedFailuresMap, serverName, () -> new FailureInfo(currentTime));
        fInfo.timeOfLatestAttemptMilliSec = currentTime;
        fInfo.numConsecutiveFailures.incrementAndGet();
    }

    public void handleThrowable(Throwable t1, ServerName serverName, MutableBoolean couldNotCommunicateWithServer, MutableBoolean guaranteedClientSideOnly) throws IOException {
        boolean isLocalException;
        Throwable t2 = ClientExceptionsUtil.translatePFFE(t1);
        boolean bl = isLocalException = !(t2 instanceof RemoteException);
        if (isLocalException && ClientExceptionsUtil.isConnectionException(t2)) {
            couldNotCommunicateWithServer.setValue(true);
            guaranteedClientSideOnly.setValue(!(t2 instanceof CallTimeoutException));
            this.handleFailureToServer(serverName, t2);
        }
    }

    protected void occasionallyCleanupFailureInformation() {
        long now = System.currentTimeMillis();
        if (now <= this.lastFailureMapCleanupTimeMilliSec + this.failureMapCleanupIntervalMilliSec) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.repeatedFailuresMap.entrySet()) {
            if (now > ((FailureInfo)entry.getValue()).timeOfLatestAttemptMilliSec + this.failureMapCleanupIntervalMilliSec) {
                this.repeatedFailuresMap.remove(entry.getKey());
                continue;
            }
            if (now > ((FailureInfo)entry.getValue()).timeOfFirstFailureMilliSec + this.fastFailClearingTimeMilliSec) {
                LOG.error(entry.getKey() + " been failing for a long time. clearing out." + ((FailureInfo)entry.getValue()).toString());
                this.repeatedFailuresMap.remove(entry.getKey());
                continue;
            }
            sb.append(((ServerName)entry.getKey()).toString()).append(" failing ").append(((FailureInfo)entry.getValue()).toString()).append("\n");
        }
        if (sb.length() > 0) {
            LOG.warn("Preemptive failure enabled for : " + sb.toString());
        }
        this.lastFailureMapCleanupTimeMilliSec = now;
    }

    private boolean inFastFailMode(ServerName server) {
        FailureInfo fInfo = (FailureInfo)this.repeatedFailuresMap.get(server);
        return fInfo != null && EnvironmentEdgeManager.currentTime() > fInfo.timeOfFirstFailureMilliSec + this.fastFailThresholdMilliSec;
    }

    private boolean currentThreadInFastFailMode() {
        return this.threadRetryingInFastFailMode.get() != null && this.threadRetryingInFastFailMode.get().booleanValue();
    }

    protected boolean shouldRetryInspiteOfFastFail(FailureInfo fInfo) {
        if (fInfo != null && fInfo.exclusivelyRetringInspiteOfFastFail.compareAndSet(false, true)) {
            MutableBoolean threadAlreadyInFF = this.threadRetryingInFastFailMode.get();
            if (threadAlreadyInFF == null) {
                threadAlreadyInFF = new MutableBoolean();
                this.threadRetryingInFastFailMode.set(threadAlreadyInFF);
            }
            threadAlreadyInFF.setValue(true);
            return true;
        }
        return false;
    }

    private void updateFailureInfoForServer(ServerName server, FailureInfo fInfo, boolean didTry, boolean couldNotCommunicate, boolean retryDespiteFastFailMode) {
        if (server == null || fInfo == null || !didTry) {
            return;
        }
        if (!couldNotCommunicate) {
            LOG.info("Clearing out PFFE for server " + server);
            this.repeatedFailuresMap.remove(server);
        } else {
            long currentTime;
            fInfo.timeOfLatestAttemptMilliSec = currentTime = System.currentTimeMillis();
            if (retryDespiteFastFailMode) {
                fInfo.exclusivelyRetringInspiteOfFastFail.set(false);
                this.threadRetryingInFastFailMode.get().setValue(false);
            }
        }
        this.occasionallyCleanupFailureInformation();
    }

    @Override
    public void intercept(RetryingCallerInterceptorContext context) throws PreemptiveFastFailException {
        if (context instanceof FastFailInterceptorContext) {
            this.intercept((FastFailInterceptorContext)context);
        }
    }

    @Override
    public void handleFailure(RetryingCallerInterceptorContext context, Throwable t) throws IOException {
        if (context instanceof FastFailInterceptorContext) {
            this.handleFailure((FastFailInterceptorContext)context, t);
        }
    }

    @Override
    public void updateFailureInfo(RetryingCallerInterceptorContext context) {
        if (context instanceof FastFailInterceptorContext) {
            this.updateFailureInfo((FastFailInterceptorContext)context);
        }
    }

    @Override
    public RetryingCallerInterceptorContext createEmptyContext() {
        return new FastFailInterceptorContext();
    }

    protected boolean isServerInFailureMap(ServerName serverName) {
        return this.repeatedFailuresMap.containsKey(serverName);
    }

    @Override
    public String toString() {
        return "PreemptiveFastFailInterceptor";
    }
}

