/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.io.ByteBufferPool;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ByteBufferListOutputStream
extends ByteBufferOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ByteBufferListOutputStream.class);
    private ByteBufferPool pool;
    protected List<ByteBuffer> allBufs = new ArrayList<ByteBuffer>();
    protected List<ByteBuffer> bufsFromPool = new ArrayList<ByteBuffer>();
    private boolean lastBufFlipped = false;

    public ByteBufferListOutputStream(ByteBufferPool pool) {
        this.pool = pool;
        this.allocateNewBuffer();
    }

    private void allocateNewBuffer() {
        if (this.curBuf != null) {
            this.curBuf.flip();
        }
        this.curBuf = this.pool.getBuffer();
        if (this.curBuf == null) {
            this.curBuf = ByteBuffer.allocate(this.pool.getBufferSize());
        } else {
            this.bufsFromPool.add(this.curBuf);
        }
        this.allBufs.add(this.curBuf);
    }

    @Override
    public int size() {
        int s = 0;
        for (int i = 0; i < this.allBufs.size() - 1; ++i) {
            s += this.allBufs.get(i).remaining();
        }
        s = this.lastBufFlipped ? (s += this.curBuf.remaining()) : (s += this.curBuf.position());
        return s;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        throw new UnsupportedOperationException("This stream is not backed by a single ByteBuffer");
    }

    @Override
    protected void checkSizeAndGrow(int extra) {
        long capacityNeeded = (long)this.curBuf.position() + (long)extra;
        if (capacityNeeded > (long)this.curBuf.limit()) {
            this.allocateNewBuffer();
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void releaseResources() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.debug(e.toString(), (Throwable)e);
        }
        if (this.bufsFromPool != null) {
            for (int i = 0; i < this.bufsFromPool.size(); ++i) {
                this.pool.putbackBuffer(this.bufsFromPool.get(i));
            }
            this.bufsFromPool = null;
        }
        this.allBufs = null;
        this.curBuf = null;
    }

    @Override
    public byte[] toByteArray(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public List<ByteBuffer> getByteBuffers() {
        if (!this.lastBufFlipped) {
            this.lastBufFlipped = true;
            this.curBuf.flip();
        }
        return this.allBufs;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int toWrite = 0;
        while (len > 0) {
            toWrite = Math.min(len, this.curBuf.remaining());
            ByteBufferUtils.copyFromArrayToBuffer(this.curBuf, b, off, toWrite);
            off += toWrite;
            if ((len -= toWrite) <= 0) continue;
            this.allocateNewBuffer();
        }
    }

    @Override
    public void write(ByteBuffer b, int off, int len) throws IOException {
        int toWrite = 0;
        while (len > 0) {
            toWrite = Math.min(len, this.curBuf.remaining());
            ByteBufferUtils.copyFromBufferToBuffer(b, this.curBuf, off, toWrite);
            off += toWrite;
            if ((len -= toWrite) <= 0) continue;
            this.allocateNewBuffer();
        }
    }
}

