/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.master.MetricsAssignmentManagerSource;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.OperationMetrics;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsAssignmentManagerSourceImpl
extends BaseSourceImpl
implements MetricsAssignmentManagerSource {
    private MutableGaugeLong ritGauge;
    private MutableGaugeLong ritCountOverThresholdGauge;
    private MutableGaugeLong ritOldestAgeGauge;
    private MetricHistogram ritDurationHisto;
    private MutableFastCounter operationCounter;
    private OperationMetrics assignMetrics;
    private OperationMetrics unassignMetrics;
    private OperationMetrics splitMetrics;
    private OperationMetrics mergeMetrics;

    public MetricsAssignmentManagerSourceImpl() {
        this("AssignmentManager", "Metrics about HBase master assignment manager.", "master", "Master,sub=AssignmentManager");
    }

    public MetricsAssignmentManagerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.ritGauge = this.metricsRegistry.newGauge("ritCount", "Current number of Regions In Transition (Gauge).", 0L);
        this.ritCountOverThresholdGauge = this.metricsRegistry.newGauge("ritCountOverThreshold", "Current number of Regions In Transition over threshold time (Gauge).", 0L);
        this.ritOldestAgeGauge = this.metricsRegistry.newGauge("ritOldestAge", "Timestamp in milliseconds of the oldest Region In Transition (Gauge).", 0L);
        this.ritDurationHisto = this.metricsRegistry.newTimeHistogram("ritDuration", "Total durations in milliseconds for all Regions in Transition (Histogram).");
        this.operationCounter = this.metricsRegistry.getCounter("operationCount", 0L);
        this.assignMetrics = new OperationMetrics(this.registry, "assign");
        this.unassignMetrics = new OperationMetrics(this.registry, "unassign");
        this.splitMetrics = new OperationMetrics(this.registry, "split");
        this.mergeMetrics = new OperationMetrics(this.registry, "merge");
    }

    @Override
    public void setRIT(int ritCount) {
        this.ritGauge.set((long)ritCount);
    }

    @Override
    public void setRITCountOverThreshold(int ritCount) {
        this.ritCountOverThresholdGauge.set((long)ritCount);
    }

    @Override
    public void setRITOldestAge(long ritCount) {
        this.ritOldestAgeGauge.set(ritCount);
    }

    @Override
    public void incrementOperationCounter() {
        this.operationCounter.incr();
    }

    @Override
    public void updateRitDuration(long duration) {
        this.ritDurationHisto.add(duration);
    }

    @Override
    public OperationMetrics getAssignMetrics() {
        return this.assignMetrics;
    }

    @Override
    public OperationMetrics getUnassignMetrics() {
        return this.unassignMetrics;
    }

    @Override
    public OperationMetrics getSplitMetrics() {
        return this.splitMetrics;
    }

    @Override
    public OperationMetrics getMergeMetrics() {
        return this.mergeMetrics;
    }
}

